/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.mags;

import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemAmmoBag;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.particle.SpentCasing;
import com.hbm.util.BobMathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class MagazineSingleTypeBase
implements IMagazine<BulletConfig> {
    public static final String KEY_MAG_COUNT = "magcount";
    public static final String KEY_MAG_TYPE = "magtype";
    public static final String KEY_MAG_PREV = "magprev";
    public static final String KEY_MAG_AFTER = "magafter";
    public List<BulletConfig> acceptedBullets = new ArrayList<BulletConfig>();
    public int index;
    public int capacity;

    public MagazineSingleTypeBase(int index, int capacity) {
        this.index = index;
        this.capacity = capacity;
    }

    public MagazineSingleTypeBase addConfigs(BulletConfig ... cfgs) {
        for (BulletConfig cfg : cfgs) {
            this.acceptedBullets.add(cfg);
        }
        return this;
    }

    @Override
    public BulletConfig getType(ItemStack stack, IInventory inventory) {
        int type = MagazineSingleTypeBase.getMagType(stack, this.index);
        if (type >= 0 && type < BulletConfig.configs.size()) {
            BulletConfig cfg = BulletConfig.configs.get(type);
            if (this.acceptedBullets.contains(cfg)) {
                return cfg;
            }
            return this.acceptedBullets.get(0);
        }
        return null;
    }

    @Override
    public void setType(ItemStack stack, BulletConfig type) {
        int i = BulletConfig.configs.indexOf(type);
        if (i >= 0) {
            MagazineSingleTypeBase.setMagType(stack, this.index, i);
        }
    }

    @Override
    public ItemStack getIconForHUD(ItemStack stack, EntityPlayer player) {
        BulletConfig config = this.getType(stack, (IInventory)player.field_71071_by);
        if (config != null) {
            return config.ammo.toStack();
        }
        return null;
    }

    @Override
    public String reportAmmoStateForHUD(ItemStack stack, EntityPlayer player) {
        return this.getAmount(stack, (IInventory)player.field_71071_by) + " / " + this.getCapacity(stack);
    }

    @Override
    public SpentCasing getCasing(ItemStack stack, IInventory inventory) {
        return this.getType((ItemStack)stack, (IInventory)inventory).casing;
    }

    @Override
    public void useUpAmmo(ItemStack stack, IInventory inventory, int amount) {
        if (!IMagazine.shouldUseUpTrenchie(inventory) && this.getCapacity(stack) != 1) {
            return;
        }
        this.setAmount(stack, this.getAmount(stack, inventory) - amount);
        IMagazine.handleAmmoBag(inventory, this.getType(stack, inventory), amount);
    }

    @Override
    public boolean canReload(ItemStack stack, IInventory inventory) {
        if (this.getAmount(stack, inventory) >= this.getCapacity(stack)) {
            return false;
        }
        if (inventory == null) {
            return true;
        }
        BulletConfig nextConfig = this.getFirstConfig(stack, inventory);
        return nextConfig != null;
    }

    public void standardReload(ItemStack stack, IInventory inventory, int loadLimit) {
        if (inventory == null) {
            BulletConfig config = this.getType(stack, inventory);
            if (config == null) {
                config = this.acceptedBullets.get(0);
                this.setType(stack, config);
            }
            this.setAmount(stack, this.capacity);
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            boolean infBag;
            int toLoad;
            int wantsToLoad;
            ItemStack slot = inventory.func_70301_a(i);
            if (loadLimit <= 0) {
                return;
            }
            if (slot == null) continue;
            if (this.getAmount(stack, null) == 0) {
                for (BulletConfig config : this.acceptedBullets) {
                    if (!config.ammo.matchesRecipe(slot, true)) continue;
                    this.setType(stack, config);
                    wantsToLoad = (int)Math.ceil((double)this.getCapacity(stack) / (double)config.ammoReloadCount);
                    toLoad = BobMathUtil.min(wantsToLoad, slot.field_77994_a, loadLimit);
                    this.setAmount(stack, Math.min(toLoad * config.ammoReloadCount, this.capacity));
                    inventory.func_70298_a(i, toLoad);
                    loadLimit -= toLoad;
                    break;
                }
            } else {
                BulletConfig config = this.getType(stack, null);
                if (config == null) {
                    config = this.acceptedBullets.get(0);
                    this.setType(stack, config);
                }
                if (config.ammo.matchesRecipe(slot, true)) {
                    int alreadyLoaded = this.getAmount(stack, null);
                    wantsToLoad = (int)Math.ceil((double)(this.getCapacity(stack) - alreadyLoaded) / (double)config.ammoReloadCount);
                    toLoad = BobMathUtil.min(wantsToLoad, slot.field_77994_a, loadLimit);
                    this.setAmount(stack, Math.min(toLoad * config.ammoReloadCount + alreadyLoaded, this.capacity));
                    inventory.func_70298_a(i, toLoad);
                    loadLimit -= toLoad;
                }
            }
            boolean bl = infBag = slot.func_77973_b() == ModItems.ammo_bag_infinite;
            if (slot.func_77973_b() != ModItems.ammo_bag && !infBag) continue;
            ItemAmmoBag.InventoryAmmoBag bag = new ItemAmmoBag.InventoryAmmoBag(slot);
            block2: for (int j = 0; j < bag.func_70302_i_(); ++j) {
                int toLoad2;
                int wantsToLoad2;
                ItemStack bagslot = bag.func_70301_a(j);
                if (bagslot == null) continue;
                if (this.getAmount(stack, null) == 0) {
                    for (BulletConfig config : this.acceptedBullets) {
                        if (!config.ammo.matchesRecipe(bagslot, true)) continue;
                        this.setType(stack, config);
                        wantsToLoad2 = (int)Math.ceil((double)this.getCapacity(stack) / (double)config.ammoReloadCount);
                        toLoad2 = BobMathUtil.min(wantsToLoad2, infBag ? 9999 : bagslot.field_77994_a, loadLimit);
                        this.setAmount(stack, Math.min(toLoad2 * config.ammoReloadCount, this.capacity));
                        if (!infBag) {
                            bag.func_70298_a(j, toLoad2);
                        }
                        loadLimit -= toLoad2;
                        continue block2;
                    }
                    continue;
                }
                BulletConfig config = this.getType(stack, null);
                if (config == null) {
                    config = this.acceptedBullets.get(0);
                    this.setType(stack, config);
                }
                if (!config.ammo.matchesRecipe(bagslot, true)) continue;
                int alreadyLoaded = this.getAmount(stack, bag);
                wantsToLoad2 = (int)Math.ceil((double)(this.getCapacity(stack) - alreadyLoaded) / (double)config.ammoReloadCount);
                toLoad2 = BobMathUtil.min(wantsToLoad2, infBag ? 9999 : bagslot.field_77994_a, loadLimit);
                this.setAmount(stack, Math.min(toLoad2 * config.ammoReloadCount + alreadyLoaded, this.capacity));
                if (!infBag) {
                    bag.func_70298_a(j, toLoad2);
                }
                loadLimit -= toLoad2;
            }
        }
    }

    public BulletConfig getFirstConfig(ItemStack stack, IInventory inventory) {
        if (inventory == null) {
            return null;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            if (this.getAmount(stack, null) == 0) {
                for (BulletConfig config : this.acceptedBullets) {
                    if (!config.ammo.matchesRecipe(slot, true)) continue;
                    return config;
                }
            } else {
                BulletConfig config = this.getType(stack, null);
                if (config == null) {
                    config = this.acceptedBullets.get(0);
                    this.setType(stack, config);
                }
                if (config.ammo.matchesRecipe(slot, true)) {
                    return config;
                }
            }
            if (slot.func_77973_b() != ModItems.ammo_bag && slot.func_77973_b() != ModItems.ammo_bag_infinite) continue;
            ItemAmmoBag.InventoryAmmoBag bag = new ItemAmmoBag.InventoryAmmoBag(slot);
            for (int j = 0; j < bag.func_70302_i_(); ++j) {
                ItemStack bagslot = bag.func_70301_a(j);
                if (bagslot == null) continue;
                if (this.getAmount(stack, null) == 0) {
                    for (BulletConfig config : this.acceptedBullets) {
                        if (!config.ammo.matchesRecipe(bagslot, true)) continue;
                        return config;
                    }
                    continue;
                }
                BulletConfig config = this.getType(stack, null);
                if (config == null) {
                    config = this.acceptedBullets.get(0);
                    this.setType(stack, config);
                }
                if (!config.ammo.matchesRecipe(bagslot, true)) continue;
                return config;
            }
        }
        return null;
    }

    @Override
    public void initNewType(ItemStack stack, IInventory inventory) {
        if (inventory == null) {
            return;
        }
        BulletConfig nextConfig = this.getFirstConfig(stack, inventory);
        if (nextConfig != null) {
            int i = BulletConfig.configs.indexOf(nextConfig);
            MagazineSingleTypeBase.setMagType(stack, this.index, i);
        }
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public int getAmount(ItemStack stack, IInventory inventory) {
        return MagazineSingleTypeBase.getMagCount(stack, this.index);
    }

    @Override
    public void setAmount(ItemStack stack, int amount) {
        MagazineSingleTypeBase.setMagCount(stack, this.index, amount);
    }

    @Override
    public void setAmountBeforeReload(ItemStack stack, int amount) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_PREV + this.index, amount);
    }

    @Override
    public int getAmountBeforeReload(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_PREV + this.index);
    }

    @Override
    public void setAmountAfterReload(ItemStack stack, int amount) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_AFTER + this.index, amount);
    }

    @Override
    public int getAmountAfterReload(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_AFTER + this.index);
    }

    public static int getMagType(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_TYPE + index);
    }

    public static void setMagType(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_TYPE + index, value);
    }

    public static int getMagCount(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_COUNT + index);
    }

    public static void setMagCount(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_COUNT + index, value);
    }
}

