/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.helper;

import com.hbm.entity.mob.EntityDummy;
import com.hbm.entity.mob.EntityUndeadSoldier;
import com.hbm.main.ClientProxy;
import com.hbm.particle.ParticleSkeleton;
import com.hbm.particle.helper.IParticleCreator;
import com.hbm.util.Vec3NT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SkeletonCreator
implements IParticleCreator {
    public static HashMap<String, Function<EntityLivingBase, BoneDefinition[]>> skullanizer = new HashMap();
    public static Function<EntityLivingBase, BoneDefinition[]> BONES_BIPED = entity -> {
        Vec3NT leftarm = new Vec3NT(0.375, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        Vec3NT leftleg = new Vec3NT(0.125, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        return new BoneDefinition[]{new BoneDefinition(EnumSkeletonType.SKULL, -entity.field_70759_as, entity.field_70125_A, entity.field_70165_t, entity.field_70163_u + 1.75, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.TORSO, -entity.field_70761_aq, 0.0f, entity.field_70165_t, entity.field_70163_u + 1.125, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t + leftarm.field_72450_a, entity.field_70163_u + 1.125, entity.field_70161_v + leftarm.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t - leftarm.field_72450_a, entity.field_70163_u + 1.125, entity.field_70161_v - leftarm.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t + leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v + leftleg.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t - leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v - leftleg.field_72449_c)};
    };
    public static Function<EntityLivingBase, BoneDefinition[]> BONES_ZOMBIE = entity -> {
        Vec3NT leftarm = new Vec3NT(0.375, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        Vec3NT forward = new Vec3NT(0.0, 0.0, 0.25).rotateAroundYDeg(-entity.field_70761_aq);
        Vec3NT leftleg = new Vec3NT(0.125, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        return new BoneDefinition[]{new BoneDefinition(EnumSkeletonType.SKULL, -entity.field_70759_as, entity.field_70125_A, entity.field_70165_t, entity.field_70163_u + 1.75, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.TORSO, -entity.field_70761_aq, 0.0f, entity.field_70165_t, entity.field_70163_u + 1.125, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, -90.0f, entity.field_70165_t + leftarm.field_72450_a + forward.field_72450_a, entity.field_70163_u + 1.375, entity.field_70161_v + leftarm.field_72449_c + forward.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, -90.0f, entity.field_70165_t - leftarm.field_72450_a + forward.field_72450_a, entity.field_70163_u + 1.375, entity.field_70161_v - leftarm.field_72449_c + forward.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t + leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v + leftleg.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t - leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v - leftleg.field_72449_c)};
    };
    public static Function<EntityLivingBase, BoneDefinition[]> BONES_VILLAGER = entity -> {
        Vec3NT leftarm = new Vec3NT(0.375, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        Vec3NT forward = new Vec3NT(0.0, 0.0, 0.25).rotateAroundYDeg(-entity.field_70761_aq);
        Vec3NT leftleg = new Vec3NT(0.125, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        return new BoneDefinition[]{new BoneDefinition(EnumSkeletonType.SKULL_VILLAGER, -entity.field_70759_as, entity.field_70125_A, entity.field_70165_t, entity.field_70163_u + 1.6875, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.TORSO, -entity.field_70761_aq, 0.0f, entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, -45.0f, entity.field_70165_t + leftarm.field_72450_a + forward.field_72450_a, entity.field_70163_u + 1.125, entity.field_70161_v + leftarm.field_72449_c + forward.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, -45.0f, entity.field_70165_t - leftarm.field_72450_a + forward.field_72450_a, entity.field_70163_u + 1.125, entity.field_70161_v - leftarm.field_72449_c + forward.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t + leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v + leftleg.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t - leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v - leftleg.field_72449_c)};
    };
    public static Function<EntityLivingBase, BoneDefinition[]> BONES_DUMMY = entity -> {
        Vec3NT leftarm = new Vec3NT(0.375, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        Vec3NT leftleg = new Vec3NT(0.125, 0.0, 0.0).rotateAroundYDeg(-entity.field_70761_aq);
        return new BoneDefinition[]{new BoneDefinition(EnumSkeletonType.SKULL, -entity.field_70759_as, entity.field_70125_A, entity.field_70165_t, entity.field_70163_u + 1.75, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.TORSO, -entity.field_70761_aq, 0.0f, entity.field_70165_t, entity.field_70163_u + 1.125, entity.field_70161_v), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t + leftarm.field_72450_a, entity.field_70163_u + 1.125, entity.field_70161_v + leftarm.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t - leftarm.field_72450_a, entity.field_70163_u + 1.125, entity.field_70161_v - leftarm.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t + leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v + leftleg.field_72449_c), new BoneDefinition(EnumSkeletonType.LIMB, -entity.field_70761_aq, 0.0f, entity.field_70165_t - leftleg.field_72450_a, entity.field_70163_u + 0.375, entity.field_70161_v - leftleg.field_72449_c)};
    };

    public static void composeEffect(World world, Entity toSkeletonize, float brightness) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "skeleton");
        data.func_74768_a("entityID", toSkeletonize.func_145782_y());
        data.func_74776_a("brightness", brightness);
        IParticleCreator.sendPacket(world, toSkeletonize.field_70165_t, toSkeletonize.field_70163_u, toSkeletonize.field_70161_v, 100, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void makeParticle(World world, EntityPlayer player, TextureManager texman, Random rand, double x, double y, double z, NBTTagCompound data) {
        int entityID;
        Entity entity;
        if (skullanizer.isEmpty()) {
            SkeletonCreator.init();
        }
        if (!((entity = world.func_73045_a(entityID = data.func_74762_e("entityID"))) instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)entity;
        ClientProxy.vanish(entityID);
        float brightness = data.func_74760_g("brightness");
        Function<EntityLivingBase, BoneDefinition[]> bonealizer = skullanizer.get(entity.getClass().getSimpleName());
        if (bonealizer != null) {
            BoneDefinition[] bones;
            for (BoneDefinition bone : bones = bonealizer.apply(living)) {
                ParticleSkeleton skeleton = new ParticleSkeleton(Minecraft.func_71410_x().func_110434_K(), world, bone.x, bone.y, bone.z, brightness, brightness, brightness, bone.type);
                skeleton.field_70126_B = skeleton.field_70177_z = bone.yaw;
                skeleton.field_70127_C = skeleton.field_70125_A = bone.pitch;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)skeleton);
            }
        }
    }

    public static void init() {
        skullanizer.put(EntityOtherPlayerMP.class.getSimpleName(), BONES_BIPED);
        skullanizer.put(EntityClientPlayerMP.class.getSimpleName(), BONES_BIPED);
        skullanizer.put(EntityPlayerSP.class.getSimpleName(), BONES_BIPED);
        skullanizer.put(EntityZombie.class.getSimpleName(), BONES_ZOMBIE);
        skullanizer.put(EntitySkeleton.class.getSimpleName(), BONES_ZOMBIE);
        skullanizer.put(EntityPigZombie.class.getSimpleName(), BONES_ZOMBIE);
        skullanizer.put(EntityUndeadSoldier.class.getSimpleName(), BONES_ZOMBIE);
        skullanizer.put(EntityVillager.class.getSimpleName(), BONES_VILLAGER);
        skullanizer.put(EntityWitch.class.getSimpleName(), BONES_VILLAGER);
        skullanizer.put(EntityDummy.class.getSimpleName(), BONES_DUMMY);
        skullanizer.put("ArmySoldier", BONES_ZOMBIE);
        skullanizer.put("PsychoSteve", BONES_ZOMBIE);
        skullanizer.put("SkeletonSoldier", BONES_ZOMBIE);
        skullanizer.put("ZombieFarmer", BONES_ZOMBIE);
        skullanizer.put("ZombieMiner", BONES_ZOMBIE);
        skullanizer.put("ZombiePigmanSoldier", BONES_ZOMBIE);
        skullanizer.put("ZombieSoldier", BONES_ZOMBIE);
    }

    public static enum EnumSkeletonType {
        SKULL,
        TORSO,
        LIMB,
        SKULL_VILLAGER;

    }

    public static class BoneDefinition {
        public EnumSkeletonType type;
        public float yaw;
        public float pitch;
        public double x;
        public double y;
        public double z;

        public BoneDefinition(EnumSkeletonType type, float yaw, float pitch, double x, double y, double z) {
            this.type = type;
            this.yaw = yaw;
            this.pitch = pitch;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

