/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.block;

import com.hbm.blocks.machine.Spotlight;
import com.hbm.blocks.machine.SpotlightModular;
import com.hbm.render.util.ObjUtil;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderLight
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof Spotlight)) {
            return;
        }
        Spotlight spot = (Spotlight)block;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon iicon = block.func_149691_a(0, 0);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        if (renderer.func_147744_b()) {
            iicon = renderer.field_147840_d;
        }
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
        tessellator.func_78382_b();
        ObjUtil.renderPartWithIcon(spot.getModel(), spot.getPartName(0), iicon, tessellator, 0.0f, false);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof Spotlight)) {
            return true;
        }
        Spotlight spot = (Spotlight)block;
        Tessellator tessellator = Tessellator.field_78398_a;
        ForgeDirection dir = spot.getDirection(world, x, y, z);
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        float ox = 0.5f - (float)dir.offsetX * 0.5f;
        float oy = 0.5f - (float)dir.offsetY * 0.5f;
        float oz = 0.5f - (float)dir.offsetZ * 0.5f;
        float rot = ObjUtil.getYaw(dir);
        float pitch = ObjUtil.getPitch(dir);
        float roll = 0.0f;
        int connectionCount = 0;
        if (spot instanceof SpotlightModular) {
            ForgeDirection connectionDirection = null;
            SpotlightModular modular = (SpotlightModular)spot;
            for (ForgeDirection availableDir : ForgeDirection.VALID_DIRECTIONS) {
                if (availableDir == dir || availableDir == dir.getOpposite() || !modular.canConnectTo(world, x + availableDir.offsetX, y + availableDir.offsetY, z + availableDir.offsetZ)) continue;
                ++connectionCount;
                connectionDirection = availableDir;
                break;
            }
            if (connectionDirection != null) {
                if (modular.canConnectTo(world, x - connectionDirection.offsetX, y - connectionDirection.offsetY, z - connectionDirection.offsetZ)) {
                    ++connectionCount;
                }
                roll = this.getRotation(connectionDirection, dir);
            }
        }
        tessellator.func_78372_c((float)x + ox, (float)y + oy, (float)z + oz);
        ObjUtil.renderPartWithIcon(spot.getModel(), spot.getPartName(connectionCount), block.func_149691_a(0, 0), tessellator, rot, pitch, roll, false);
        tessellator.func_78372_c((float)(-x) - ox, (float)(-y) - oy, (float)(-z) - oz);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return Spotlight.renderID;
    }

    private float getRotation(ForgeDirection dir, ForgeDirection axis) {
        float flipX = axis == ForgeDirection.DOWN || axis == ForgeDirection.NORTH || axis == ForgeDirection.WEST ? -0.5f : 0.5f;
        float addX = axis == ForgeDirection.NORTH || axis == ForgeDirection.SOUTH ? -0.5f : 0.0f;
        boolean flipNS = axis == ForgeDirection.WEST;
        switch (dir) {
            case NORTH: {
                return flipNS ? (float)Math.PI : 0.0f;
            }
            case SOUTH: {
                return !flipNS ? (float)Math.PI : 0.0f;
            }
            case EAST: {
                return (float)Math.PI * (flipX + addX);
            }
            case WEST: {
                return (float)Math.PI * (-flipX + addX);
            }
            case UP: {
                return -1.5707964f;
            }
            case DOWN: {
                return 1.5707964f;
            }
        }
        return 0.0f;
    }
}

