/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mods.WeaponModManager;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderUzi
extends ItemRenderWeaponBase {
    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.25f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderUzi.standardAimingTransform(stack, -1.75f * offset, -1.5f * offset, 2.5f * offset, 0.0, -0.546875, 1.0);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.isSaturnite(stack) ? ResourceManager.uzi_saturnite_tex : ResourceManager.uzi_tex);
        double scale = 0.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] stockFront = HbmAnimations.getRelevantTransformation("STOCKFRONT");
        double[] stockBack = HbmAnimations.getRelevantTransformation("STOCKBACK");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] lift = HbmAnimations.getRelevantTransformation("LIFT");
        double[] mag = HbmAnimations.getRelevantTransformation("MAG");
        double[] bullet = HbmAnimations.getRelevantTransformation("BULLET");
        double[] slide = HbmAnimations.getRelevantTransformation("SLIDE");
        double[] yeet = HbmAnimations.getRelevantTransformation("YEET");
        double[] speen = HbmAnimations.getRelevantTransformation("SPEEN");
        GL11.glTranslated((double)yeet[0], (double)yeet[1], (double)yeet[2]);
        GL11.glRotated((double)speen[0], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-2.0, (double)-4.0);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)2.0, (double)4.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-6.0);
        GL11.glRotated((double)lift[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)6.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)recoil[2]);
        GL11.glShadeModel((int)7425);
        ResourceManager.uzi.renderPart("Gun");
        boolean silenced = this.hasSilencer(stack, 0);
        if (silenced) {
            ResourceManager.uzi.renderPart("Silencer");
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.3125, (double)-5.75);
        GL11.glRotated((double)(180.0 - stockFront[0]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.3125, (double)5.75);
        ResourceManager.uzi.renderPart("StockFront");
        GL11.glTranslated((double)0.0, (double)-0.3125, (double)-3.0);
        GL11.glRotated((double)(-200.0 - stockBack[0]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.3125, (double)3.0);
        ResourceManager.uzi.renderPart("StockBack");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)slide[2]);
        ResourceManager.uzi.renderPart("Slide");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)mag[0], (double)mag[1], (double)mag[2]);
        ResourceManager.uzi.renderPart("Magazine");
        if (bullet[0] == 1.0) {
            ResourceManager.uzi.renderPart("Bullet");
        }
        GL11.glPopMatrix();
        if (!silenced) {
            double smokeScale = 0.5;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.75, (double)8.5);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
            ItemRenderUzi.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 0.75);
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.75, (double)8.5);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 * gun.shotRand), (double)1.0, (double)0.0, (double)0.0);
            ItemRenderUzi.renderMuzzleFlash(gun.lastShot[0], 75, 7.5);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        GL11.glTranslated((double)0.0, (double)1.0, (double)1.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -6.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)-4.0);
    }

    @Override
    public void renderModTable(ItemStack stack, int index) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.isSaturnite(stack) ? ResourceManager.uzi_saturnite_tex : ResourceManager.uzi_tex);
        ResourceManager.uzi.renderPart("Gun");
        ResourceManager.uzi.renderPart("StockBack");
        ResourceManager.uzi.renderPart("StockFront");
        ResourceManager.uzi.renderPart("Slide");
        ResourceManager.uzi.renderPart("Magazine");
        if (this.hasSilencer(stack, index)) {
            ResourceManager.uzi.renderPart("Silencer");
        }
        GL11.glShadeModel((int)7424);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type) {
        GL11.glEnable((int)2896);
        boolean silenced = this.hasSilencer(stack, 0);
        if (silenced && type == IItemRenderer.ItemRenderType.INVENTORY) {
            double scale = 0.625;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-4.0);
        }
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.isSaturnite(stack) ? ResourceManager.uzi_saturnite_tex : ResourceManager.uzi_tex);
        ResourceManager.uzi.renderPart("Gun");
        ResourceManager.uzi.renderPart("StockBack");
        ResourceManager.uzi.renderPart("StockFront");
        ResourceManager.uzi.renderPart("Slide");
        ResourceManager.uzi.renderPart("Magazine");
        if (silenced) {
            ResourceManager.uzi.renderPart("Silencer");
        }
        GL11.glShadeModel((int)7424);
    }

    public boolean hasSilencer(ItemStack stack, int cfg) {
        return WeaponModManager.hasUpgrade(stack, cfg, 201);
    }

    public boolean isSaturnite(ItemStack stack) {
        return WeaponModManager.hasUpgrade(stack, 0, 215);
    }
}

