/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineArcFurnaceLarge;
import com.hbm.inventory.gui.GUIMachineArcFurnaceLarge;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.ArcFurnaceRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemArcElectrode;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.CrucibleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineArcFurnaceLarge
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IControlReceiver,
IGUIProvider,
IUpgradeInfoProvider {
    public long power;
    public static final long maxPower = 2500000L;
    public boolean liquidMode = false;
    public float progress;
    public boolean isProgressing;
    public boolean hasMaterial;
    public int delay;
    public int upgrade;
    public float lid;
    public float prevLid;
    public int approachNum;
    public float syncLid;
    private AudioWrapper audioLid;
    private AudioWrapper audioProgress;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    public byte[] electrodes = new byte[3];
    public static final byte ELECTRODE_NONE = 0;
    public static final byte ELECTRODE_FRESH = 1;
    public static final byte ELECTRODE_USED = 2;
    public static final byte ELECTRODE_DEPLETED = 3;
    public static final int maxLiquid = MaterialShapes.BLOCK.q(128);
    public List<Mats.MaterialStack> liquids = new ArrayList<Mats.MaterialStack>();
    AxisAlignedBB bb = null;

    public int getMaxInputSize() {
        return this.upgrade == 0 ? 1 : (this.upgrade == 1 ? 4 : (this.upgrade == 2 ? 8 : 16));
    }

    public TileEntityMachineArcFurnaceLarge() {
        super(25);
    }

    @Override
    public String getName() {
        return "container.machineArcFurnaceLarge";
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && stack.func_77973_b() instanceof ItemMachineUpgrade && i == 4) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public void func_145845_h() {
        this.upgradeManager.checkSlots(this, this.slots, 4, 4);
        this.upgrade = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 3, this.power, 2500000L);
            this.isProgressing = false;
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.power > 0L) {
                boolean ingredients = this.hasIngredients();
                boolean electrodes = this.hasElectrodes();
                int consumption = (int)(1000.0 * Math.pow(5.0, this.upgrade));
                if (ingredients && electrodes && this.delay <= 0 && this.liquids.isEmpty()) {
                    if (this.lid > 0.0f) {
                        this.lid = (float)((double)this.lid - 1.0 / (60.0 / ((double)this.upgrade * 0.5 + 1.0)));
                        if (this.lid < 0.0f) {
                            this.lid = 0.0f;
                        }
                        this.progress = 0.0f;
                    } else if (this.power >= (long)consumption) {
                        int duration = 400 / (this.upgrade * 2 + 1);
                        this.progress += 1.0f / (float)duration;
                        this.isProgressing = true;
                        this.power -= (long)consumption;
                        if (this.progress >= 1.0f) {
                            this.process();
                            this.progress = 0.0f;
                            this.func_70296_d();
                            this.delay = (int)(120.0 / ((double)this.upgrade * 0.5 + 1.0));
                            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 10.0f);
                        }
                    }
                } else {
                    if (this.delay > 0) {
                        --this.delay;
                    }
                    this.progress = 0.0f;
                    if (this.lid < 1.0f && this.electrodes[0] != 0 && this.electrodes[1] != 0 && this.electrodes[2] != 0) {
                        this.lid = (float)((double)this.lid + 1.0 / (60.0 / ((double)this.upgrade * 0.5 + 1.0)));
                        if (this.lid > 1.0f) {
                            this.lid = 1.0f;
                        }
                    }
                }
                this.hasMaterial = ingredients;
            }
            this.decideElectrodeState();
            if (!this.hasMaterial) {
                this.hasMaterial = this.hasIngredients();
            }
            if (!this.liquids.isEmpty() && this.lid > 0.0f) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                Vec3 impact = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                Mats.MaterialStack didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 2.875, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 2.875, 6.0, true, this.liquids, MaterialShapes.INGOT.q(1), impact);
                if (didPour != null) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)(this.field_145848_d + 1) - (float)(Math.ceil(impact.field_72448_b) - 0.875)));
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 2.875, this.field_145848_d + 1, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 2.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 50.0));
                }
            }
            this.liquids.removeIf(o -> o.amount <= 0);
            this.networkPackNT(150);
        } else {
            int i;
            this.prevLid = this.lid;
            if (this.approachNum > 0) {
                this.lid += (this.syncLid - this.lid) / (float)this.approachNum;
                --this.approachNum;
            } else {
                this.lid = this.syncLid;
            }
            if (this.lid != this.prevLid) {
                if (this.audioLid == null || !this.audioLid.isPlaying()) {
                    this.audioLid = MainRegistry.proxy.getLoopedSound("hbm:door.wgh_start", this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getVolume(0.75f), 15.0f, 1.0f, 5);
                    this.audioLid.startSound();
                }
                this.audioLid.keepAlive();
            } else if (this.audioLid != null) {
                this.audioLid.stopSound();
                this.audioLid = null;
            }
            if (!(this.lid != 1.0f && this.lid != 0.0f || this.lid == this.prevLid || this.prevLid == 0.0f && this.lid == 1.0f)) {
                MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:door.wgh_stop", this.getVolume(1.0f), 1.0f);
            }
            if (this.isProgressing) {
                if (this.audioProgress == null || !this.audioProgress.isPlaying()) {
                    this.audioProgress = MainRegistry.proxy.getLoopedSound("hbm:block.electricHum", this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getVolume(1.5f), 15.0f, 0.75f, 5);
                    this.audioProgress.startSound();
                }
                this.audioProgress.updatePitch(0.75f);
                this.audioProgress.keepAlive();
            } else if (this.audioProgress != null) {
                this.audioProgress.stopSound();
                this.audioProgress = null;
            }
            if (this.lid != this.prevLid && this.lid > this.prevLid && (this.prevLid != 0.0f || this.lid != 1.0f) && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 4), (double)this.field_145849_e + 0.5) < 50.0) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "tower");
                data.func_74776_a("lift", 0.01f);
                data.func_74776_a("base", 0.5f);
                data.func_74776_a("max", 2.0f);
                data.func_74768_a("life", 70 + this.field_145850_b.field_73012_v.nextInt(30));
                data.func_74780_a("posX", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                data.func_74780_a("posY", (double)(this.field_145848_d + 4));
                data.func_74757_a("noWind", true);
                data.func_74776_a("alphaMod", this.prevLid / this.lid);
                data.func_74768_a("color", 0);
                data.func_74776_a("strafe", 0.05f);
                for (i = 0; i < 3; ++i) {
                    MainRegistry.proxy.effectNT(data);
                }
            }
            if (this.lid != this.prevLid && this.lid < this.prevLid && this.lid > 0.5f && this.hasMaterial && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 4), (double)this.field_145849_e + 0.5) < 50.0 && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
                NBTTagCompound flame = new NBTTagCompound();
                flame.func_74778_a("type", "rbmkflame");
                flame.func_74780_a("posX", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                flame.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                flame.func_74780_a("posY", (double)this.field_145848_d + 2.75);
                flame.func_74768_a("maxAge", 50);
                for (i = 0; i < 2; ++i) {
                    MainRegistry.proxy.effectNT(flame);
                }
            }
        }
    }

    public void decideElectrodeState() {
        for (int i = 0; i < 3; ++i) {
            if (this.slots[i] != null) {
                if (this.slots[i].func_77973_b() == ModItems.arc_electrode_burnt) {
                    this.electrodes[i] = 3;
                    continue;
                }
                if (this.slots[i].func_77973_b() == ModItems.arc_electrode) {
                    if (this.isProgressing || ItemArcElectrode.getDurability(this.slots[i]) > 0) {
                        this.electrodes[i] = 2;
                        continue;
                    }
                    this.electrodes[i] = 1;
                    continue;
                }
            }
            this.electrodes[i] = 0;
        }
    }

    public void process() {
        int i;
        block0: for (i = 5; i < 25; ++i) {
            ArcFurnaceRecipes.ArcFurnaceRecipe recipe;
            if (this.slots[i] == null || (recipe = ArcFurnaceRecipes.getOutput(this.slots[i], this.liquidMode)) == null) continue;
            if (!this.liquidMode && recipe.solidOutput != null) {
                int amount = this.slots[i].field_77994_a;
                this.slots[i] = recipe.solidOutput.func_77946_l();
                this.slots[i].field_77994_a *= amount;
            }
            if (!this.liquidMode || recipe.fluidOutput == null) continue;
            while (this.slots[i] != null && this.slots[i].field_77994_a > 0) {
                int liquid = TileEntityMachineArcFurnaceLarge.getStackAmount(this.liquids);
                int toAdd = TileEntityMachineArcFurnaceLarge.getStackAmount(recipe.fluidOutput);
                if (liquid + toAdd > maxLiquid) continue block0;
                this.func_70298_a(i, 1);
                for (Mats.MaterialStack stack : recipe.fluidOutput) {
                    this.addToStack(stack);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            if (!ItemArcElectrode.damage(this.slots[i])) continue;
            this.slots[i] = new ItemStack(ModItems.arc_electrode_burnt, 1, this.slots[i].func_77960_j());
        }
    }

    public boolean hasIngredients() {
        for (int i = 5; i < 25; ++i) {
            ArcFurnaceRecipes.ArcFurnaceRecipe recipe;
            if (this.slots[i] == null || (recipe = ArcFurnaceRecipes.getOutput(this.slots[i], this.liquidMode)) == null) continue;
            if (this.liquidMode && recipe.fluidOutput != null) {
                return true;
            }
            if (this.liquidMode || recipe.solidOutput == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasElectrodes() {
        for (int i = 0; i < 3; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.arc_electrode) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (this.lid <= 0.0f) {
            return false;
        }
        if (slot < 3) {
            return stack.func_77973_b() == ModItems.arc_electrode;
        }
        if (slot > 4) {
            ArcFurnaceRecipes.ArcFurnaceRecipe recipe = ArcFurnaceRecipes.getOutput(stack, this.liquidMode);
            if (recipe == null) {
                return false;
            }
            if (this.liquidMode) {
                if (recipe.fluidOutput == null) {
                    return false;
                }
                int sta = this.slots[slot] != null ? this.slots[slot].field_77994_a : 0;
                return (sta += stack.field_77994_a) <= this.getMaxInputSize();
            }
            if (recipe.solidOutput == null) {
                return false;
            }
            int sta = this.slots[slot] != null ? this.slots[slot].field_77994_a : 0;
            return (sta += stack.field_77994_a) * recipe.solidOutput.field_77994_a <= recipe.solidOutput.func_77976_d() && sta <= this.getMaxInputSize();
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 3) {
            return stack.func_77973_b() == ModItems.arc_electrode;
        }
        if (slot > 4) {
            ArcFurnaceRecipes.ArcFurnaceRecipe recipe = ArcFurnaceRecipes.getOutput(stack, this.liquidMode);
            if (recipe == null) {
                return false;
            }
            if (this.liquidMode) {
                return recipe.fluidOutput != null;
            }
            return recipe.solidOutput != null;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot < 3) {
            return this.lid >= 1.0f && stack.func_77973_b() != ModItems.arc_electrode;
        }
        if (slot > 4) {
            return this.lid > 0.0f && ArcFurnaceRecipes.getOutput(stack, this.liquidMode) == null;
        }
        return false;
    }

    public void addToStack(Mats.MaterialStack matStack) {
        for (Mats.MaterialStack mat : this.liquids) {
            if (mat.material != matStack.material) continue;
            mat.amount += matStack.amount;
            return;
        }
        this.liquids.add(matStack.copy());
    }

    public static int getStackAmount(List<Mats.MaterialStack> stack) {
        int amount = 0;
        for (Mats.MaterialStack mat : stack) {
            amount += mat.amount;
        }
        return amount;
    }

    public static int getStackAmount(Mats.MaterialStack[] stack) {
        int amount = 0;
        for (Mats.MaterialStack mat : stack) {
            amount += mat.amount;
        }
        return amount;
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 3 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 3 - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 - rot.offsetZ, dir), new DirPos(this.field_145851_c + rot.offsetX * 3 + dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3 + dir.offsetZ, rot), new DirPos(this.field_145851_c + rot.offsetX * 3 - dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3 - dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX * 3 + dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 3 + dir.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 3 - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 3 - dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeFloat(this.progress);
        buf.writeFloat(this.lid);
        buf.writeBoolean(this.isProgressing);
        buf.writeBoolean(this.liquidMode);
        buf.writeBoolean(this.hasMaterial);
        for (int i = 0; i < 3; ++i) {
            buf.writeByte((int)this.electrodes[i]);
        }
        buf.writeShort(this.liquids.size());
        for (Mats.MaterialStack mat : this.liquids) {
            buf.writeInt(mat.material.id);
            buf.writeInt(mat.amount);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.progress = buf.readFloat();
        this.syncLid = buf.readFloat();
        this.isProgressing = buf.readBoolean();
        this.liquidMode = buf.readBoolean();
        this.hasMaterial = buf.readBoolean();
        for (int i = 0; i < 3; ++i) {
            this.electrodes[i] = buf.readByte();
        }
        int mats = buf.readShort();
        this.liquids.clear();
        for (int i = 0; i < mats; ++i) {
            this.liquids.add(new Mats.MaterialStack(Mats.matById.get(buf.readInt()), buf.readInt()));
        }
        if (this.syncLid != 0.0f && this.syncLid != 1.0f) {
            this.approachNum = 2;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.liquidMode = nbt.func_74767_n("liquidMode");
        this.progress = nbt.func_74760_g("progress");
        this.lid = nbt.func_74760_g("lid");
        this.delay = nbt.func_74762_e("delay");
        int count = nbt.func_74765_d("count");
        this.liquids.clear();
        for (int i = 0; i < count; ++i) {
            this.liquids.add(new Mats.MaterialStack(Mats.matById.get(nbt.func_74762_e("m" + i)), nbt.func_74762_e("a" + i)));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("liquidMode", this.liquidMode);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74776_a("lid", this.lid);
        nbt.func_74768_a("delay", this.delay);
        int count = this.liquids.size();
        nbt.func_74777_a("count", (short)count);
        for (int i = 0; i < count; ++i) {
            Mats.MaterialStack mat = this.liquids.get(i);
            nbt.func_74768_a("m" + i, mat.material.id);
            nbt.func_74768_a("a" + i, mat.amount);
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 2500000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 6), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineArcFurnaceLarge(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineArcFurnaceLarge(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74767_n("liquid")) {
            this.liquidMode = !this.liquidMode;
            this.func_70296_d();
        }
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_arc_furnace));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + (100 - 100 / (level * 2 + 1)) + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + ((int)Math.pow(5.0, level) * 100 - 100) + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        return upgrades;
    }
}

