/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineITER;
import com.hbm.inventory.container.ContainerPlasmaHeater;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIPlasmaHeater;
import com.hbm.lib.Library;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityITER;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachinePlasmaHeater
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiver,
IGUIProvider,
IFluidCopiable {
    public long power;
    public static final long maxPower = 100000000L;
    public FluidTank[] tanks = new FluidTank[2];
    public FluidTank plasma;

    public TileEntityMachinePlasmaHeater() {
        super(5);
        this.tanks[0] = new FluidTank(Fluids.DEUTERIUM, 16000);
        this.tanks[1] = new FluidTank(Fluids.TRITIUM, 16000);
        this.plasma = new FluidTank(Fluids.PLASMA_DT, 64000);
    }

    @Override
    public String getName() {
        return "container.plasmaHeater";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity te;
            int[] pos;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000000L);
            this.tanks[0].setType(1, 2, this.slots);
            this.tanks[1].setType(3, 4, this.slots);
            this.updateType();
            int maxConv = 50;
            int powerReq = 10000;
            int convert = Math.min(this.tanks[0].getFill(), this.tanks[1].getFill());
            convert = Math.min(convert, (this.plasma.getMaxFill() - this.plasma.getFill()) / 2);
            convert = Math.min(convert, maxConv);
            convert = (int)Math.min((long)convert, this.power / (long)powerReq);
            convert = Math.max(0, convert);
            if (convert > 0 && this.plasma.getTankType() != Fluids.NONE) {
                this.tanks[0].setFill(this.tanks[0].getFill() - convert);
                this.tanks[1].setFill(this.tanks[1].getFill() - convert);
                this.plasma.setFill(this.plasma.getFill() + convert * 2);
                this.power -= (long)(convert * powerReq);
                this.func_70296_d();
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
            int dist = 11;
            if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX * dist, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * dist) == ModBlocks.iter && (pos = ((MachineITER)ModBlocks.iter).findCore(this.field_145850_b, this.field_145851_c + dir.offsetX * dist, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * dist)) != null && (te = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2])) instanceof TileEntityITER) {
                TileEntityITER iter = (TileEntityITER)te;
                if (iter.plasma.getFill() == 0 && this.plasma.getTankType() != Fluids.NONE) {
                    iter.plasma.setTankType(this.plasma.getTankType());
                }
                if (iter.isOn && iter.plasma.getTankType() == this.plasma.getTankType()) {
                    int toLoad = Math.min(iter.plasma.getMaxFill() - iter.plasma.getFill(), this.plasma.getFill());
                    toLoad = Math.min(toLoad, 40);
                    this.plasma.setFill(this.plasma.getFill() - toLoad);
                    iter.plasma.setFill(iter.plasma.getFill() + toLoad);
                    this.func_70296_d();
                    iter.func_70296_d();
                }
            }
            this.networkPackNT(50);
        }
    }

    private void updateConnections() {
        this.func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.field_145847_g - 10));
        ForgeDirection side = dir.getRotation(ForgeDirection.UP);
        for (int i = 1; i < 4; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + side.offsetX * j + dir.offsetX * 2, this.field_145848_d + i, this.field_145849_e + side.offsetZ * j + dir.offsetZ * 2, j < 0 ? ForgeDirection.DOWN : ForgeDirection.UP);
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, this.field_145851_c + side.offsetX * j + dir.offsetX * 2, this.field_145848_d + i, this.field_145849_e + side.offsetZ * j + dir.offsetZ * 2, j < 0 ? ForgeDirection.DOWN : ForgeDirection.UP);
                this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, this.field_145851_c + side.offsetX * j + dir.offsetX * 2, this.field_145848_d + i, this.field_145849_e + side.offsetZ * j + dir.offsetZ * 2, j < 0 ? ForgeDirection.DOWN : ForgeDirection.UP);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        this.plasma.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.plasma.deserialize(buf);
    }

    private void updateType() {
        ArrayList types = new ArrayList(){
            {
                this.add(TileEntityMachinePlasmaHeater.this.tanks[0].getTankType());
                this.add(TileEntityMachinePlasmaHeater.this.tanks[1].getTankType());
            }
        };
        if (types.contains(Fluids.DEUTERIUM) && types.contains(Fluids.TRITIUM)) {
            this.plasma.setTankType(Fluids.PLASMA_DT);
            return;
        }
        if (types.contains(Fluids.DEUTERIUM) && types.contains(Fluids.HELIUM3)) {
            this.plasma.setTankType(Fluids.PLASMA_DH3);
            return;
        }
        if (types.contains(Fluids.DEUTERIUM) && types.contains(Fluids.HYDROGEN)) {
            this.plasma.setTankType(Fluids.PLASMA_HD);
            return;
        }
        if (types.contains(Fluids.HYDROGEN) && types.contains(Fluids.TRITIUM)) {
            this.plasma.setTankType(Fluids.PLASMA_HT);
            return;
        }
        if (types.contains(Fluids.HELIUM4) && types.contains(Fluids.OXYGEN)) {
            this.plasma.setTankType(Fluids.PLASMA_XM);
            return;
        }
        if (types.contains(Fluids.BALEFIRE) && types.contains(Fluids.AMAT)) {
            this.plasma.setTankType(Fluids.PLASMA_BF);
            return;
        }
        this.plasma.setTankType(Fluids.NONE);
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 100000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "fuel_1");
        this.tanks[1].readFromNBT(nbt, "fuel_2");
        this.plasma.readFromNBT(nbt, "plasma");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "fuel_1");
        this.tanks[1].writeToNBT(nbt, "fuel_2");
        this.plasma.writeToNBT(nbt, "plasma");
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1], this.plasma};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPlasmaHeater(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPlasmaHeater(player.field_71071_by, this);
    }
}

