/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.container.ContainerMachinePress;
import com.hbm.inventory.gui.GUIMachinePress;
import com.hbm.inventory.recipes.PressRecipes;
import com.hbm.items.machine.ItemStamp;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachinePress
extends TileEntityMachineBase
implements IGUIProvider {
    public int speed = 0;
    public static final int maxSpeed = 400;
    public static final int progressAtMax = 25;
    public int burnTime = 0;
    public int press;
    public double renderPress;
    public double lastPress;
    private int syncPress;
    private int turnProgress;
    public static final int maxPress = 200;
    boolean isRetracting = false;
    private int delay;
    public ItemStack syncStack;
    AxisAlignedBB aabb;

    public TileEntityMachinePress() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.press";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean canProcess;
            if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) < 12) {
                this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1);
            }
            boolean preheated = false;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) != ModBlocks.press_preheater) continue;
                preheated = true;
                break;
            }
            if (((canProcess = this.canProcess()) || this.isRetracting) && this.burnTime >= 200) {
                this.speed += preheated ? 4 : 1;
                if (this.speed > 400) {
                    this.speed = 400;
                }
            } else {
                --this.speed;
                if (this.speed < 0) {
                    this.speed = 0;
                }
            }
            if (this.delay <= 0) {
                int stampSpeed = this.speed * 25 / 400;
                if (this.isRetracting) {
                    this.press -= stampSpeed;
                    if (this.press <= 0) {
                        this.isRetracting = false;
                        this.delay = 5;
                    }
                } else if (canProcess) {
                    this.press += stampSpeed;
                    if (this.press >= 200) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.pressOperate", this.getVolume(1.5f), 1.0f);
                        ItemStack output = PressRecipes.getOutput(this.slots[2], this.slots[1]);
                        if (this.slots[3] == null) {
                            this.slots[3] = output.func_77946_l();
                        } else {
                            this.slots[3].field_77994_a += output.field_77994_a;
                        }
                        this.func_70298_a(2, 1);
                        if (this.slots[1].func_77958_k() != 0) {
                            this.slots[1].func_77964_b(this.slots[1].func_77960_j() + 1);
                            if (this.slots[1].func_77960_j() >= this.slots[1].func_77958_k()) {
                                this.slots[1] = null;
                            }
                        }
                        this.isRetracting = true;
                        this.delay = 5;
                        if (this.burnTime >= 200) {
                            this.burnTime -= 200;
                        }
                        this.func_70296_d();
                    }
                } else if (this.press > 0) {
                    this.isRetracting = true;
                }
            } else {
                --this.delay;
            }
            if (this.slots[0] != null && this.burnTime < 200 && TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]) > 0) {
                this.burnTime += TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]);
                if (this.slots[0].field_77994_a == 1 && this.slots[0].func_77973_b().hasContainerItem(this.slots[0])) {
                    this.slots[0] = this.slots[0].func_77973_b().getContainerItem(this.slots[0]).func_77946_l();
                } else {
                    this.func_70298_a(0, 1);
                }
                this.markChanged();
            }
            this.networkPackNT(50);
        } else {
            this.lastPress = this.renderPress;
            if (this.turnProgress > 0) {
                this.renderPress += ((double)this.syncPress - this.renderPress) / (double)this.turnProgress;
                --this.turnProgress;
            } else {
                this.renderPress = this.syncPress;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.speed);
        buf.writeInt(this.burnTime);
        buf.writeInt(this.press);
        BufferUtil.writeItemStack(buf, this.slots[2]);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.speed = buf.readInt();
        this.burnTime = buf.readInt();
        this.syncPress = buf.readInt();
        this.syncStack = BufferUtil.readItemStack(buf);
        this.turnProgress = 2;
    }

    public boolean canProcess() {
        if (this.burnTime < 200) {
            return false;
        }
        if (this.slots[1] == null || this.slots[2] == null) {
            return false;
        }
        ItemStack output = PressRecipes.getOutput(this.slots[2], this.slots[1]);
        if (output == null) {
            return false;
        }
        if (this.slots[3] == null) {
            return true;
        }
        return this.slots[3].field_77994_a + output.field_77994_a <= this.slots[3].func_77976_d() && this.slots[3].func_77973_b() == output.func_77973_b() && this.slots[3].func_77960_j() == output.func_77960_j();
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemStamp) {
            return i == 1;
        }
        if (TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 && i == 0) {
            return true;
        }
        return i == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.press = nbt.func_74762_e("press");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.speed = nbt.func_74762_e("speed");
        this.isRetracting = nbt.func_74767_n("ret");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("press", this.press);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("speed", this.speed);
        nbt.func_74757_a("ret", this.isRetracting);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.aabb != null) {
            return this.aabb;
        }
        this.aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
        return this.aabb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachinePress(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachinePress(player.field_71071_by, this);
    }
}

