/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.config.VersatileConfig;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.container.ContainerMachineSchrabidiumTransmutator;
import com.hbm.inventory.gui.GUIMachineSchrabidiumTransmutator;
import com.hbm.inventory.recipes.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineSchrabidiumTransmutator
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider {
    public long power = 0L;
    public int process = 0;
    public static final long maxPower = 5000000L;
    public static final int processSpeed = 600;
    private AudioWrapper audio;
    private static final int[] slots_io = new int[]{0, 1, 2, 3};

    public TileEntityMachineSchrabidiumTransmutator() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.machine_schrabidium_transmutator";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 0: {
                if (!MachineRecipes.mODE(stack, OreDictManager.U.ingot())) break;
                return true;
            }
            case 2: {
                if (stack.func_77973_b() != ModItems.redcoil_capacitor && stack.func_77973_b() != ModItems.euphemium_capacitor) break;
                return true;
            }
            case 3: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.process = nbt.func_74762_e("process");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("process", this.process);
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return slots_io;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (stack.func_77973_b() == ModItems.euphemium_capacitor) {
            return false;
        }
        if (i == 2 && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.redcoil_capacitor && stack.func_77960_j() == stack.func_77958_k()) {
            return true;
        }
        if (i == 1) {
            return true;
        }
        return i == 3 && stack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)stack.func_77973_b()).getCharge(stack) == 0L;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 5000000L;
    }

    public int getProgressScaled(int i) {
        return this.process * i / 600;
    }

    public boolean canProcess() {
        return this.power >= 4990000L && this.slots[0] != null && MachineRecipes.mODE(this.slots[0], OreDictManager.U.ingot()) && this.slots[2] != null && (this.slots[2].func_77973_b() == ModItems.redcoil_capacitor && this.slots[2].func_77960_j() < this.slots[2].func_77958_k() || this.slots[2].func_77973_b() == ModItems.euphemium_capacitor) && (this.slots[1] == null || this.slots[1] != null && this.slots[1].func_77973_b() == VersatileConfig.getTransmutatorItem() && this.slots[1].field_77994_a < this.slots[1].func_77976_d());
    }

    public boolean isProcessing() {
        return this.process > 0;
    }

    public void process() {
        ++this.process;
        if (this.process >= 600) {
            this.power = 0L;
            this.process = 0;
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            if (this.slots[1] == null) {
                this.slots[1] = new ItemStack(VersatileConfig.getTransmutatorItem());
            } else {
                ++this.slots[1].field_77994_a;
            }
            if (this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.redcoil_capacitor) {
                this.slots[2].func_77964_b(this.slots[2].func_77960_j() + 1);
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 3, this.power, 5000000L);
            if (this.canProcess()) {
                this.process();
            } else {
                this.process = 0;
            }
            this.networkPackNT(50);
        } else if (this.process > 0) {
            if (this.audio == null) {
                this.audio = this.createAudioLoop();
                this.audio.startSound();
            } else if (!this.audio.isPlaying()) {
                this.audio = this.rebootAudio(this.audio);
            }
            this.audio.updateVolume(this.getVolume(1.0f));
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.process);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.process = buf.readInt();
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:weapon.tauChargeLoop", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    private void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 5000000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineSchrabidiumTransmutator(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineSchrabidiumTransmutator(player.field_71071_by, this);
    }
}

