/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.HbmKeybinds;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.machine.rbmk.IRBMKLoadable;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityCraneConsole
extends TileEntityLoadedBase
implements SimpleComponent,
CompatHandler.OCComponent {
    public int centerX;
    public int centerY;
    public int centerZ;
    public int spanF;
    public int spanB;
    public int spanL;
    public int spanR;
    public int height;
    public boolean setUpCrane = false;
    public int craneRotationOffset = 0;
    public double lastTiltFront = 0.0;
    public double lastTiltLeft = 0.0;
    public double tiltFront = 0.0;
    public double tiltLeft = 0.0;
    public double lastPosFront = 0.0;
    public double lastPosLeft = 0.0;
    public double posFront = 0.0;
    public double posLeft = 0.0;
    private static final double speed = 0.05;
    private boolean goesDown = false;
    public double lastProgress = 1.0;
    public double progress = 1.0;
    private ItemStack loadedItem;
    private boolean hasLoaded = false;
    public double loadedHeat;
    public double loadedEnrichment;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.lastTiltFront = this.tiltFront;
            this.lastTiltLeft = this.tiltLeft;
        }
        if (this.goesDown) {
            if (this.progress > 0.0) {
                this.progress -= 0.04;
            } else {
                IRBMKLoadable column;
                this.progress = 0.0;
                this.goesDown = false;
                if (!this.field_145850_b.field_72995_K && this.canTargetInteract() && (column = this.getColumnAtPos()) != null) {
                    if (this.loadedItem != null) {
                        column.load(this.loadedItem);
                        this.loadedItem = null;
                    } else {
                        this.loadedItem = column.provideNext();
                        column.unload();
                    }
                    this.func_70296_d();
                }
            }
        } else if (this.progress != 1.0) {
            this.progress += 0.04;
            if (this.progress > 1.0) {
                this.progress = 1.0;
            }
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection side = dir.getRotation(ForgeDirection.UP);
        double minX = (double)this.field_145851_c + 0.5 - (double)side.offsetX * 1.5;
        double maxX = (double)this.field_145851_c + 0.5 + (double)side.offsetX * 1.5 + (double)(dir.offsetX * 2);
        double minZ = (double)this.field_145849_e + 0.5 - (double)side.offsetZ * 1.5;
        double maxZ = (double)this.field_145849_e + 0.5 + (double)side.offsetZ * 1.5 + (double)(dir.offsetZ * 2);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)Math.min(minX, maxX), (double)this.field_145848_d, (double)Math.min(minZ, maxZ), (double)Math.max(minX, maxX), (double)(this.field_145848_d + 2), (double)Math.max(minZ, maxZ)));
        this.tiltFront = 0.0;
        this.tiltLeft = 0.0;
        if (players.size() > 0 && !this.isCraneLoading()) {
            EntityPlayer player = (EntityPlayer)players.get(0);
            HbmPlayerProps props = HbmPlayerProps.getData(player);
            boolean up = props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_UP);
            boolean down = props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_DOWN);
            boolean left = props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_LEFT);
            boolean right = props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_RIGHT);
            if (up && !down) {
                this.tiltFront = 30.0;
                if (!this.field_145850_b.field_72995_K) {
                    this.posFront += 0.05;
                }
            }
            if (!up && down) {
                this.tiltFront = -30.0;
                if (!this.field_145850_b.field_72995_K) {
                    this.posFront -= 0.05;
                }
            }
            if (left && !right) {
                this.tiltLeft = 30.0;
                if (!this.field_145850_b.field_72995_K) {
                    this.posLeft += 0.05;
                }
            }
            if (!left && right) {
                this.tiltLeft = -30.0;
                if (!this.field_145850_b.field_72995_K) {
                    this.posLeft -= 0.05;
                }
            }
            if (props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_LOAD)) {
                this.goesDown = true;
            }
        }
        this.posFront = MathHelper.func_151237_a((double)this.posFront, (double)(-this.spanB), (double)this.spanF);
        this.posLeft = MathHelper.func_151237_a((double)this.posLeft, (double)(-this.spanR), (double)this.spanL);
        if (!this.field_145850_b.field_72995_K) {
            if (this.loadedItem != null && this.loadedItem.func_77973_b() instanceof ItemRBMKRod) {
                this.loadedHeat = ItemRBMKRod.getHullHeat(this.loadedItem);
                this.loadedEnrichment = ItemRBMKRod.getEnrichment(this.loadedItem);
            } else {
                this.loadedHeat = 0.0;
                this.loadedEnrichment = 0.0;
            }
            this.networkPackNT(250);
        }
    }

    public boolean hasItemLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            return this.loadedItem != null;
        }
        return this.hasLoaded;
    }

    public boolean isCraneLoading() {
        return this.progress != 1.0;
    }

    public boolean isAboveValidTarget() {
        return this.getColumnAtPos() != null;
    }

    public boolean canTargetInteract() {
        IRBMKLoadable column = this.getColumnAtPos();
        if (column == null) {
            return false;
        }
        if (this.hasItemLoaded()) {
            return column.canLoad(this.loadedItem);
        }
        return column.canUnload();
    }

    public IRBMKLoadable getColumnAtPos() {
        TileEntityRBMKBase column;
        int[] pos;
        int z;
        int y;
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection left = dir.getRotation(ForgeDirection.DOWN);
        int x = (int)Math.floor((double)this.centerX - (double)dir.offsetX * this.posFront - (double)left.offsetX * this.posLeft + 0.5);
        Block b = this.field_145850_b.func_147439_a(x, y = this.centerY - 1, z = (int)Math.floor((double)this.centerZ - (double)dir.offsetZ * this.posFront - (double)left.offsetZ * this.posLeft + 0.5));
        if (b instanceof RBMKBase && (pos = ((BlockDummyable)b).findCore(this.field_145850_b, x, y, z)) != null && (column = (TileEntityRBMKBase)this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2])) instanceof IRBMKLoadable) {
            return (IRBMKLoadable)((Object)column);
        }
        return null;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.setUpCrane);
        if (this.setUpCrane) {
            buf.writeInt(this.craneRotationOffset);
            buf.writeInt(this.centerX);
            buf.writeInt(this.centerY);
            buf.writeInt(this.centerZ);
            buf.writeInt(this.spanF);
            buf.writeInt(this.spanB);
            buf.writeInt(this.spanL);
            buf.writeInt(this.spanR);
            buf.writeInt(this.height);
            buf.writeDouble(this.posFront);
            buf.writeDouble(this.posLeft);
            buf.writeBoolean(this.hasItemLoaded());
            buf.writeDouble(this.loadedHeat);
            buf.writeDouble(this.loadedEnrichment);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.lastPosFront = this.posFront;
        this.lastPosLeft = this.posLeft;
        this.lastProgress = this.progress;
        this.setUpCrane = buf.readBoolean();
        if (this.setUpCrane) {
            this.craneRotationOffset = buf.readInt();
            this.centerX = buf.readInt();
            this.centerY = buf.readInt();
            this.centerZ = buf.readInt();
            this.spanF = buf.readInt();
            this.spanB = buf.readInt();
            this.spanL = buf.readInt();
            this.spanR = buf.readInt();
            this.height = buf.readInt();
            this.posFront = buf.readDouble();
            this.posLeft = buf.readDouble();
            this.hasLoaded = buf.readBoolean();
            this.loadedHeat = buf.readDouble();
            this.loadedEnrichment = buf.readDouble();
        }
    }

    public void setTarget(int x, int y, int z) {
        this.centerX = x;
        this.centerY = y + RBMKDials.getColumnHeight(this.field_145850_b) + 1;
        this.centerZ = z;
        this.spanF = 7;
        this.spanB = 7;
        this.spanL = 7;
        this.spanR = 7;
        this.height = 7;
        this.setUpCrane = true;
        this.func_70296_d();
    }

    public void cycleCraneRotation() {
        this.craneRotationOffset = (this.craneRotationOffset + 90) % 360;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setUpCrane = nbt.func_74767_n("crane");
        this.craneRotationOffset = nbt.func_74762_e("craneRotationOffset");
        this.centerX = nbt.func_74762_e("centerX");
        this.centerY = nbt.func_74762_e("centerY");
        this.centerZ = nbt.func_74762_e("centerZ");
        this.spanF = nbt.func_74762_e("spanF");
        this.spanB = nbt.func_74762_e("spanB");
        this.spanL = nbt.func_74762_e("spanL");
        this.spanR = nbt.func_74762_e("spanR");
        this.height = nbt.func_74762_e("height");
        this.posFront = nbt.func_74769_h("posFront");
        this.posLeft = nbt.func_74769_h("posLeft");
        NBTTagCompound held = nbt.func_74775_l("held");
        this.loadedItem = ItemStack.func_77949_a((NBTTagCompound)held);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("crane", this.setUpCrane);
        nbt.func_74768_a("craneRotationOffset", this.craneRotationOffset);
        nbt.func_74768_a("centerX", this.centerX);
        nbt.func_74768_a("centerY", this.centerY);
        nbt.func_74768_a("centerZ", this.centerZ);
        nbt.func_74768_a("spanF", this.spanF);
        nbt.func_74768_a("spanB", this.spanB);
        nbt.func_74768_a("spanL", this.spanL);
        nbt.func_74768_a("spanR", this.spanR);
        nbt.func_74768_a("height", this.height);
        nbt.func_74780_a("posFront", this.posFront);
        nbt.func_74780_a("posLeft", this.posLeft);
        if (this.loadedItem != null) {
            NBTTagCompound held = new NBTTagCompound();
            this.loadedItem.func_77955_b(held);
            nbt.func_74782_a("held", (NBTBase)held);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_crane";
    }

    @Callback(direct=true, limit=2)
    @Optional.Method(modid="OpenComputers")
    public Object[] move(Context context, Arguments args) {
        if (this.setUpCrane) {
            String direction;
            switch (direction = args.checkString(0)) {
                case "up": {
                    this.tiltFront = 30.0;
                    if (this.field_145850_b.field_72995_K) break;
                    this.posFront += 0.05;
                    break;
                }
                case "down": {
                    this.tiltFront = -30.0;
                    if (this.field_145850_b.field_72995_K) break;
                    this.posFront -= 0.05;
                    break;
                }
                case "left": {
                    this.tiltLeft = 30.0;
                    if (this.field_145850_b.field_72995_K) break;
                    this.posLeft += 0.05;
                    break;
                }
                case "right": {
                    this.tiltLeft = -30.0;
                    if (this.field_145850_b.field_72995_K) break;
                    this.posLeft -= 0.05;
                }
            }
            return new Object[0];
        }
        return new Object[]{"Crane not found"};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] load(Context context, Arguments args) {
        if (this.setUpCrane) {
            this.goesDown = true;
            return new Object[0];
        }
        return new Object[]{"Crane not found"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDepletion(Context context, Arguments args) {
        if (this.loadedItem != null && this.loadedItem.func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getEnrichment(this.loadedItem)};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getXenonPoison(Context context, Arguments args) {
        if (this.loadedItem != null && this.loadedItem.func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getPoison(this.loadedItem)};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCranePos(Context context, Arguments args) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection left = dir.getRotation(ForgeDirection.DOWN);
        int x = (int)Math.floor((double)this.centerX - (double)dir.offsetX * this.posFront - (double)left.offsetX * this.posLeft + 0.5);
        int z = (int)Math.floor((double)this.centerZ - (double)dir.offsetZ * this.posFront - (double)left.offsetZ * this.posLeft + 0.5);
        return new Object[]{x, z};
    }
}

