/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.uninos.networkproviders;

import com.hbm.tileentity.machine.TileEntityMachineAutocrafter;
import com.hbm.tileentity.network.TileEntityPneumoTube;
import com.hbm.uninos.NodeNet;
import com.hbm.util.BobMathUtil;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class PneumaticNetwork
extends NodeNet {
    public static final byte SEND_FIRST = 0;
    public static final byte SEND_LAST = 1;
    public static final byte SEND_RANDOM = 2;
    public static final byte RECEIVE_ROBIN = 0;
    public static final byte RECEIVE_RANDOM = 1;
    public Random rand = new Random();
    public int nextReceiver = 0;
    protected static final int timeout = 1000;
    public static final int ITEMS_PER_TRANSFER = 64;
    public HashMap<IInventory, Tuple.Pair<ForgeDirection, Long>> receivers = new HashMap();

    public void addReceiver(IInventory inventory, ForgeDirection pipeDir) {
        this.receivers.put(inventory, new Tuple.Pair<ForgeDirection, Long>(pipeDir, System.currentTimeMillis()));
    }

    @Override
    public void update() {
        long timestamp = System.currentTimeMillis();
        this.receivers.entrySet().removeIf(x -> timestamp - (Long)((Tuple.Pair)x.getValue()).getValue() > 1000L || NodeNet.isBadLink(x.getKey()));
    }

    public boolean send(IInventory source, TileEntityPneumoTube tube, ForgeDirection accessDir, int sendOrder, int receiveOrder, int maxRange) {
        int sq;
        TileEntity tile2;
        long timestamp = System.currentTimeMillis();
        this.receivers.entrySet().removeIf(x -> timestamp - (Long)((Tuple.Pair)x.getValue()).getValue() > 1000L || NodeNet.isBadLink(x.getKey()));
        if (this.receivers.isEmpty()) {
            return false;
        }
        int sourceSide = accessDir.ordinal();
        int[] sourceSlotAccess = PneumaticNetwork.getSlotAccess(source, sourceSide);
        if (sendOrder == 1) {
            BobMathUtil.reverseIntArray(sourceSlotAccess);
        }
        if (sendOrder == 2) {
            BobMathUtil.shuffleIntArray(sourceSlotAccess);
        }
        ReceiverComparator comparator = new ReceiverComparator(tube);
        ArrayList<Map.Entry<IInventory, Tuple.Pair<ForgeDirection, Long>>> receiverList = new ArrayList<Map.Entry<IInventory, Tuple.Pair<ForgeDirection, Long>>>(this.receivers.size());
        receiverList.addAll(this.receivers.entrySet());
        receiverList.sort(comparator);
        int index = this.nextReceiver % this.receivers.size();
        Map.Entry chosenReceiverEntry = null;
        ++this.nextReceiver;
        if (receiveOrder == 0) {
            chosenReceiverEntry = (Map.Entry)receiverList.get(index);
        }
        if (receiveOrder == 1) {
            chosenReceiverEntry = (Map.Entry)receiverList.get(this.rand.nextInt(receiverList.size()));
        }
        if (chosenReceiverEntry == null) {
            return false;
        }
        IInventory dest = (IInventory)chosenReceiverEntry.getKey();
        ISidedInventory sidedDest = dest instanceof ISidedInventory ? (ISidedInventory)dest : null;
        ISidedInventory sidedSource = source instanceof ISidedInventory ? (ISidedInventory)source : null;
        TileEntity tile1 = source instanceof TileEntity ? (TileEntity)source : null;
        TileEntity tileEntity = tile2 = dest instanceof TileEntity ? (TileEntity)dest : null;
        if (tile1 != null && tile2 != null && (sq = (tile1.field_145851_c - tile2.field_145851_c) * (tile1.field_145851_c - tile2.field_145851_c) + (tile1.field_145848_d - tile2.field_145848_d) * (tile1.field_145848_d - tile2.field_145848_d) + (tile1.field_145849_e - tile2.field_145849_e) * (tile1.field_145849_e - tile2.field_145849_e)) > maxRange * maxRange) {
            return false;
        }
        int destSide = ((ForgeDirection)((Tuple.Pair)chosenReceiverEntry.getValue()).getKey()).getOpposite().ordinal();
        int[] destSlotAccess = PneumaticNetwork.getSlotAccess(dest, destSide);
        int itemsLeftToSend = 64;
        int itemHardCap = dest instanceof TileEntityMachineAutocrafter ? 1 : 64;
        boolean didSomething = false;
        for (int sourceIndex : sourceSlotAccess) {
            boolean match;
            ItemStack sourceStack = source.func_70301_a(sourceIndex);
            if (sourceStack == null || sidedSource != null && !sidedSource.func_102008_b(sourceIndex, sourceStack, sourceSide) || (match = tube.matchesFilter(sourceStack)) && !tube.whitelist || !match && tube.whitelist) continue;
            int proportionalValue = MathHelper.func_76125_a((int)(64 / sourceStack.func_77976_d()), (int)1, (int)64);
            for (int destIndex : destSlotAccess) {
                int toMove;
                ItemStack destStack = dest.func_70301_a(destIndex);
                if (destStack == null || !ItemStackUtil.areStacksCompatible(sourceStack, destStack) || (toMove = BobMathUtil.min(sourceStack.field_77994_a, destStack.func_77976_d() - destStack.field_77994_a, dest.func_70297_j_() - destStack.field_77994_a, itemsLeftToSend / proportionalValue, itemHardCap)) <= 0) continue;
                ItemStack checkStack = destStack.func_77946_l();
                checkStack.field_77994_a += toMove;
                if (!dest.func_94041_b(destIndex, checkStack) || sidedDest != null && !sidedDest.func_102007_a(destIndex, checkStack, destSide)) continue;
                sourceStack.field_77994_a -= toMove;
                if (sourceStack.field_77994_a <= 0) {
                    source.func_70299_a(sourceIndex, null);
                }
                destStack.field_77994_a += toMove;
                didSomething = true;
                if ((itemsLeftToSend -= toMove * proportionalValue) <= 0) break;
            }
            if (itemsLeftToSend > 0 && sourceStack.field_77994_a > 0) {
                for (int destIndex : destSlotAccess) {
                    int toMove;
                    if (dest.func_70301_a(destIndex) != null || (toMove = BobMathUtil.min(sourceStack.field_77994_a, dest.func_70297_j_(), itemsLeftToSend / proportionalValue, itemHardCap)) <= 0) continue;
                    ItemStack checkStack = sourceStack.func_77946_l();
                    checkStack.field_77994_a = toMove;
                    if (!dest.func_94041_b(destIndex, checkStack) || sidedDest != null && !sidedDest.func_102007_a(destIndex, checkStack, destSide)) continue;
                    ItemStack newStack = sourceStack.func_77946_l();
                    newStack.field_77994_a = toMove;
                    sourceStack.field_77994_a -= toMove;
                    if (sourceStack.field_77994_a <= 0) {
                        source.func_70299_a(sourceIndex, null);
                    }
                    dest.func_70299_a(destIndex, newStack);
                    didSomething = true;
                    if ((itemsLeftToSend -= toMove * proportionalValue) <= 0) break;
                }
            }
            if (itemsLeftToSend <= 0) break;
        }
        if (didSomething) {
            source.func_70296_d();
            dest.func_70296_d();
        }
        return didSomething;
    }

    public static int[] getSlotAccess(IInventory inventory, int dir) {
        if (inventory instanceof ISidedInventory) {
            int[] slotAccess = ((ISidedInventory)inventory).func_94128_d(dir);
            return Arrays.copyOf(slotAccess, slotAccess.length);
        }
        int[] slotAccess = new int[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            slotAccess[i] = i;
        }
        return slotAccess;
    }

    public static class ReceiverComparator
    implements Comparator<Map.Entry<IInventory, Tuple.Pair<ForgeDirection, Long>>> {
        private TileEntityPneumoTube origin;

        public ReceiverComparator(TileEntityPneumoTube origin) {
            this.origin = origin;
        }

        @Override
        public int compare(Map.Entry<IInventory, Tuple.Pair<ForgeDirection, Long>> o1, Map.Entry<IInventory, Tuple.Pair<ForgeDirection, Long>> o2) {
            TileEntity tile2;
            TileEntity tile1 = o1.getKey() instanceof TileEntity ? (TileEntity)o1.getKey() : null;
            TileEntity tileEntity = tile2 = o2.getKey() instanceof TileEntity ? (TileEntity)o2.getKey() : null;
            if (tile1 == null && tile2 != null) {
                return 1;
            }
            if (tile1 != null && tile2 == null) {
                return -1;
            }
            if (tile1 == null && tile2 == null) {
                return 0;
            }
            int dist1 = (tile1.field_145851_c - this.origin.field_145851_c) * (tile1.field_145851_c - this.origin.field_145851_c) + (tile1.field_145848_d - this.origin.field_145848_d) * (tile1.field_145848_d - this.origin.field_145848_d) + (tile1.field_145849_e - this.origin.field_145849_e) * (tile1.field_145849_e - this.origin.field_145849_e);
            int dist2 = (tile2.field_145851_c - this.origin.field_145851_c) * (tile2.field_145851_c - this.origin.field_145851_c) + (tile2.field_145848_d - this.origin.field_145848_d) * (tile2.field_145848_d - this.origin.field_145848_d) + (tile2.field_145849_e - this.origin.field_145849_e) * (tile2.field_145849_e - this.origin.field_145849_e);
            if (dist1 == dist2) {
                return TileEntityPneumoTube.getIdentifier(tile1.field_145851_c, tile1.field_145848_d, tile1.field_145849_e) - TileEntityPneumoTube.getIdentifier(tile2.field_145851_c, tile2.field_145848_d, tile2.field_145849_e);
            }
            return dist1 - dist2;
        }
    }
}

