/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.block.ICrucibleAcceptor;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CrucibleUtil {
    public static Mats.MaterialStack pourSingleStack(World world, double x, double y, double z, double range, boolean safe, Mats.MaterialStack stack, int quanta, Vec3 impactPosHolder) {
        Vec3 start = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 end = Vec3.func_72443_a((double)x, (double)(y - range), (double)z);
        MovingObjectPosition[] mopHolder = new MovingObjectPosition[1];
        ICrucibleAcceptor acc = CrucibleUtil.getPouringTarget(world, start, end, mopHolder);
        MovingObjectPosition mop = mopHolder[0];
        if (acc == null) {
            CrucibleUtil.spill(mop, safe, stack, quanta, impactPosHolder);
            return stack;
        }
        Mats.MaterialStack ret = CrucibleUtil.tryPourStack(world, acc, mop, stack, impactPosHolder);
        if (ret != null) {
            return ret;
        }
        CrucibleUtil.spill(mop, safe, stack, quanta, impactPosHolder);
        return stack;
    }

    public static Mats.MaterialStack pourFullStack(World world, double x, double y, double z, double range, boolean safe, List<Mats.MaterialStack> stacks, int quanta, Vec3 impactPosHolder) {
        if (stacks.isEmpty()) {
            return null;
        }
        Vec3 start = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 end = Vec3.func_72443_a((double)x, (double)(y - range), (double)z);
        MovingObjectPosition[] mopHolder = new MovingObjectPosition[1];
        ICrucibleAcceptor acc = CrucibleUtil.getPouringTarget(world, start, end, mopHolder);
        MovingObjectPosition mop = mopHolder[0];
        if (acc == null) {
            return CrucibleUtil.spill(mop, safe, stacks, quanta, impactPosHolder);
        }
        for (Mats.MaterialStack stack : stacks) {
            int amountToPour;
            Mats.MaterialStack toPour;
            Mats.MaterialStack left;
            if (stack.material == null || (left = CrucibleUtil.tryPourStack(world, acc, mop, toPour = new Mats.MaterialStack(stack.material, amountToPour = Math.min(stack.amount, quanta)), impactPosHolder)) == null) continue;
            stack.amount -= amountToPour - left.amount;
            return new Mats.MaterialStack(stack.material, stack.amount - left.amount);
        }
        return CrucibleUtil.spill(mop, safe, stacks, quanta, impactPosHolder);
    }

    public static Mats.MaterialStack tryPourStack(World world, ICrucibleAcceptor acc, MovingObjectPosition mop, Mats.MaterialStack stack, Vec3 impactPosHolder) {
        Vec3 hit = mop.field_72307_f;
        if (stack.material.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) {
            return null;
        }
        if (acc.canAcceptPartialPour(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, ForgeDirection.getOrientation((int)mop.field_72310_e), stack)) {
            Mats.MaterialStack left = acc.pour(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, ForgeDirection.getOrientation((int)mop.field_72310_e), stack);
            if (left == null) {
                left = new Mats.MaterialStack(stack.material, 0);
            }
            impactPosHolder.field_72450_a = hit.field_72450_a;
            impactPosHolder.field_72448_b = hit.field_72448_b;
            impactPosHolder.field_72449_c = hit.field_72449_c;
            return left;
        }
        return null;
    }

    public static ICrucibleAcceptor getPouringTarget(World world, Vec3 start, Vec3 end, MovingObjectPosition[] mopHolder) {
        MovingObjectPosition mop;
        block6: {
            block5: {
                mop = world.func_147447_a(start, end, true, true, true);
                if (mopHolder != null) {
                    mopHolder[0] = mop;
                }
                if (mop == null) break block5;
                MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) break block6;
            }
            return null;
        }
        Block b = world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (!(b instanceof ICrucibleAcceptor)) {
            return null;
        }
        return (ICrucibleAcceptor)b;
    }

    public static Mats.MaterialStack spill(MovingObjectPosition mop, boolean safe, List<Mats.MaterialStack> stacks, int quanta, Vec3 impactPos) {
        Mats.MaterialStack top = stacks.get(0);
        Mats.MaterialStack ret = CrucibleUtil.spill(mop, safe, top, quanta, impactPos);
        stacks.removeIf(o -> o.amount <= 0);
        return ret;
    }

    public static Mats.MaterialStack spill(MovingObjectPosition mop, boolean safe, Mats.MaterialStack stack, int quanta, Vec3 impactPos) {
        if (safe) {
            return null;
        }
        Mats.MaterialStack toWaste = new Mats.MaterialStack(stack.material, Math.min(stack.amount, quanta));
        stack.amount -= toWaste.amount;
        if (impactPos != null && mop != null) {
            impactPos.field_72450_a = mop.field_72307_f.field_72450_a;
            impactPos.field_72448_b = mop.field_72307_f.field_72448_b;
            impactPos.field_72449_c = mop.field_72307_f.field_72449_c;
        }
        return toWaste;
    }
}

