/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockLoot;
import com.hbm.crafting.handlers.MKUCraftingHandler;
import com.hbm.inventory.OreDictManager;
import com.hbm.itempool.ItemPool;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBookLore;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LootGenerator {
    public static final String LOOT_BOOKLET = "LOOT_BOOKLET";
    public static final String LOOT_CAPNUKE = "LOOT_CAPNUKE";
    public static final String LOOT_MEDICINE = "LOOT_MEDICINE";
    public static final String LOOT_CAPSTASH = "LOOT_CAPSTASH";
    public static final String LOOT_MAKESHIFT_GUN = "LOOT_MAKESHIFT_GUN";
    public static final String LOOT_NUKE_STORAGE = "LOOT_NUKE_STORAGE";
    public static final String LOOT_BONES = "LOOT_BONES";
    public static final String LOOT_GLYPHID_HIVE = "LOOT_GLYPHID_HIVE";
    public static final String LOOT_METEOR = "LOOT_METEOR";
    public static final String LOOT_FLAREGUN = "LOOT_FLAREGUN";

    public static void applyLoot(World world, int x, int y, int z, String name) {
        switch (name) {
            case "LOOT_BOOKLET": {
                LootGenerator.lootBooklet(world, x, y, z);
            }
            case "LOOT_CAPNUKE": {
                LootGenerator.lootCapNuke(world, x, y, z);
            }
            case "LOOT_MEDICINE": {
                LootGenerator.lootMedicine(world, x, y, z);
            }
            case "LOOT_CAPSTASH": {
                LootGenerator.lootCapStash(world, x, y, z);
            }
            case "LOOT_MAKESHIFT_GUN": {
                LootGenerator.lootMakeshiftGun(world, x, y, z);
            }
            case "LOOT_NUKE_STORAGE": {
                LootGenerator.lootNukeStorage(world, x, y, z);
            }
            case "LOOT_BONES": {
                LootGenerator.lootBones(world, x, y, z);
            }
            case "LOOT_GLYPHID_HIVE": {
                LootGenerator.lootGlyphidHive(world, x, y, z);
            }
            case "LOOT_METEOR": {
                LootGenerator.lootBookMeteor(world, x, y, z);
            }
            case "LOOT_FLAREGUN": {
                LootGenerator.lootFlareGun(world, x, y, z);
            }
        }
        LootGenerator.lootBones(world, x, y, z);
    }

    public static String[] getLootNames() {
        return new String[]{LOOT_BOOKLET, LOOT_CAPNUKE, LOOT_MEDICINE, LOOT_CAPSTASH, LOOT_MAKESHIFT_GUN, LOOT_NUKE_STORAGE, LOOT_BONES, LOOT_GLYPHID_HIVE, LOOT_METEOR, LOOT_FLAREGUN};
    }

    public static void setBlock(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, ModBlocks.deco_loot);
    }

    public static void addItemWithDeviation(BlockLoot.TileEntityLoot loot, Random rand, ItemStack stack, double x, double y, double z) {
        loot.addItem(stack, x + rand.nextGaussian() * 0.02, y, z + rand.nextGaussian() * 0.02);
    }

    public static void lootBooklet(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            loot.addItem(ItemBookLore.createBook("beacon", 12, 0x404040, 14038963), 0.0, 0.0, 0.0);
        }
    }

    public static void lootCapNuke(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int i;
            if (world.field_73012_v.nextInt(5) == 0) {
                loot.addItem(OreDictManager.DictFrame.fromOne(ModItems.ammo_standard, (Enum)GunFactory.EnumAmmo.NUKE_STANDARD), -0.25, 0.0, -0.125);
            } else {
                loot.addItem(OreDictManager.DictFrame.fromOne(ModItems.ammo_standard, (Enum)GunFactory.EnumAmmo.ROCKET_HEAT), -0.25, 0.0, -0.25);
            }
            for (i = 0; i < 4; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.cap_nuka, 2), 0.125, (double)i * 0.03125, 0.25);
            }
            for (i = 0; i < 2; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.syringe_metal_stimpak, 1), -0.25, (double)i * 0.03125, 0.25);
            }
            for (i = 0; i < 6; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.cap_nuka, 2), 0.125, (double)i * 0.03125, -0.25);
            }
        }
    }

    public static void lootMedicine(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack("POOL_PILE_MED_SYRINGE", world.field_73012_v), 0.125, (double)i * 0.03125, 0.25);
            }
            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack("POOL_PILE_MED_PILLS", world.field_73012_v), -0.25, 0.0, -0.125);
        }
    }

    public static void lootCapStash(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    int count = world.field_73012_v.nextInt(5) + 3;
                    for (int k = 0; k < count; ++k) {
                        LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack("POOL_PILE_CAPS", world.field_73012_v), (double)i * 0.3125, (double)k * 0.03125, (double)j * 0.3125);
                    }
                }
            }
        }
    }

    public static void lootMakeshiftGun(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int i;
            boolean r = world.field_73012_v.nextBoolean();
            if (r) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack("POOL_PILE_MAKESHIFT_GUN", world.field_73012_v), 0.125, 0.025, 0.25);
            }
            if (!r || world.field_73012_v.nextBoolean()) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack("POOL_PILE_MAKESHIFT_WRENCH", world.field_73012_v), -0.25, 0.0, -0.28125);
            }
            int count = world.field_73012_v.nextInt(2) + 1;
            for (i = 0; i < count; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack("POOL_PILE_MAKESHIFT_PLATES", world.field_73012_v), -0.25, (double)i * 0.03125, 0.3125);
            }
            count = world.field_73012_v.nextInt(2) + 2;
            for (i = 0; i < count; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack("POOL_PILE_MAKESHIFT_WIRE", world.field_73012_v), 0.25, (double)i * 0.03125, 0.1875);
            }
        }
    }

    public static void lootNukeStorage(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (!world.field_73012_v.nextBoolean()) continue;
                    loot.addItem(ItemPool.getStack("POOL_PILE_NUKE_STORAGE", world.field_73012_v), -0.375 + (double)i * 0.25, 0.0, -0.375 + (double)j * 0.25);
                }
            }
        }
    }

    public static void lootBones(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int limit = world.field_73012_v.nextInt(3) + 3;
            for (int i = 0; i < limit; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack(ItemPool.getPool("POOL_PILE_BONES"), world.field_73012_v), world.field_73012_v.nextDouble() - 0.5, (double)i * 0.03125, world.field_73012_v.nextDouble() - 0.5);
            }
        }
    }

    public static void lootGlyphidHive(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int limit = world.field_73012_v.nextInt(3) + 3;
            for (int i = 0; i < limit; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, ItemPool.getStack(ItemPool.getPool("POOL_PILE_HIVE"), world.field_73012_v), world.field_73012_v.nextDouble() - 0.5, (double)i * 0.03125, world.field_73012_v.nextDouble() - 0.5);
            }
        }
    }

    public static void lootBookMeteor(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            Item mkuItem = MKUCraftingHandler.getMKUItem(world);
            ItemStack mkuBook = MKUCraftingHandler.generateBook(world, mkuItem);
            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(mkuItem), 0.0, 0.0, 0.25);
            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, mkuBook, 0.0, 0.0, -0.25);
        }
    }

    public static void lootBookLore(World world, int x, int y, int z, ItemStack book) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int k;
            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, book, 0.0, 0.0, -0.25);
            int count = world.field_73012_v.nextInt(3) + 2;
            for (k = 0; k < count; ++k) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(Items.field_151122_aG), -0.25, (double)k * 0.03125, 0.25);
            }
            count = world.field_73012_v.nextInt(2) + 1;
            for (k = 0; k < count; ++k) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(Items.field_151121_aF), 0.25, (double)k * 0.03125, 0.125);
            }
        }
    }

    public static void lootFlareGun(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int k;
            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.gun_flaregun), 0.0, 0.0, -0.25);
            int count = world.field_73012_v.nextInt(3) + 2;
            for (k = 0; k < count; ++k) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.ammo_standard, 1, GunFactory.EnumAmmo.G26_FLARE.ordinal()), -0.25, (double)k * 0.03125, 0.25);
            }
            count = world.field_73012_v.nextInt(1) + 1;
            for (k = 0; k < count; ++k) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.ammo_standard, 1, world.field_73012_v.nextBoolean() ? GunFactory.EnumAmmo.G26_FLARE_SUPPLY.ordinal() : GunFactory.EnumAmmo.G26_FLARE_WEAPON.ordinal()), 0.25, (double)k * 0.03125, 0.125);
            }
        }
    }
}

