/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util.function;

import com.hbm.util.BobMathUtil;
import java.util.Locale;
import net.minecraft.util.EnumChatFormatting;

public abstract class Function {
    protected double div = 1.0;
    protected double off = 0.0;

    public abstract double effonix(double var1);

    public abstract String getLabelForFuel();

    public abstract String getDangerFromFuel();

    public Function withDiv(double div) {
        this.div = div;
        return this;
    }

    public Function withOff(double off) {
        this.off = off;
        return this;
    }

    public double getX(double x) {
        return x / this.div + this.off;
    }

    public String getXName() {
        return this.getXName(true);
    }

    public String getXName(boolean brackets) {
        String x = "x";
        boolean mod = false;
        if (this.div != 1.0) {
            x = x + " / " + String.format(Locale.US, "%,.1f", this.div);
        }
        if (this.off != 0.0) {
            x = x + " + " + String.format(Locale.US, "%,.1f", this.off);
        }
        if (mod && brackets) {
            x = "(" + x + ")";
        }
        return x;
    }

    public static class FunctionExperiment
    extends FunctionSingleArg {
        public FunctionExperiment(double level) {
            super(level);
        }

        @Override
        public double effonix(double x) {
            return this.getX(x) * this.level;
        }

        @Override
        public String getLabelForFuel() {
            return this.getXName(true) + " * " + String.format(Locale.US, "%,.1f", this.level);
        }

        @Override
        public String getDangerFromFuel() {
            return EnumChatFormatting.DARK_RED + "Dangerous / Experimental DO NOT USE";
        }
    }

    public static class FunctionQuadratic
    extends FunctionDoubleArg {
        public FunctionQuadratic(double level) {
            super(level, 0.0);
        }

        public FunctionQuadratic(double level, double vOff) {
            super(level, vOff);
        }

        @Override
        public double effonix(double x) {
            return this.getX(x) * this.getX(x) * this.level + this.vOff;
        }

        @Override
        public String getLabelForFuel() {
            return this.getXName(true) + "\u00b2 * " + String.format(Locale.US, "%,.1f", this.level) + (this.vOff != 0.0 ? " + " + String.format(Locale.US, "%,.1f", this.vOff) : "");
        }

        @Override
        public String getDangerFromFuel() {
            return EnumChatFormatting.RED + "DANGEROUS / QUADRATIC";
        }
    }

    public static class FunctionLinear
    extends FunctionSingleArg {
        public FunctionLinear(double level) {
            super(level);
        }

        @Override
        public double effonix(double x) {
            return this.getX(x) * this.level;
        }

        @Override
        public String getLabelForFuel() {
            return this.getXName(true) + " * " + String.format(Locale.US, "%,.1f", this.level);
        }

        @Override
        public String getDangerFromFuel() {
            return EnumChatFormatting.RED + "DANGEROUS / LINEAR";
        }
    }

    public static class FunctionSqrtFalling
    extends FunctionSqrt {
        public FunctionSqrtFalling(double fallFactor) {
            super(1.0 / fallFactor);
            this.withOff(fallFactor * fallFactor);
        }
    }

    public static class FunctionSqrt
    extends FunctionSingleArg {
        public FunctionSqrt(double level) {
            super(level);
        }

        @Override
        public double effonix(double x) {
            return BobMathUtil.squirt(this.getX(x)) * this.level;
        }

        @Override
        public String getLabelForFuel() {
            return "sqrt(" + this.getXName(false) + ") * " + String.format(Locale.US, "%,.3f", this.level);
        }

        @Override
        public String getDangerFromFuel() {
            return EnumChatFormatting.YELLOW + "MEDIUM / SQUARE ROOT";
        }
    }

    public static class FunctionPassive
    extends FunctionSingleArg {
        public FunctionPassive(double level) {
            super(level);
        }

        @Override
        public double effonix(double x) {
            return this.level;
        }

        @Override
        public String getLabelForFuel() {
            return "" + String.format(Locale.US, "%,.1f", this.level);
        }

        @Override
        public String getDangerFromFuel() {
            return EnumChatFormatting.DARK_GREEN + "SAFE / PASSIVE";
        }
    }

    public static class FunctionLogarithmic
    extends FunctionSingleArg {
        public FunctionLogarithmic(double level) {
            super(level);
            this.withOff(1.0);
        }

        @Override
        public double effonix(double x) {
            return Math.log10(this.getX(x)) * this.level;
        }

        @Override
        public String getLabelForFuel() {
            return "log10(" + this.getXName(false) + ") * " + String.format(Locale.US, "%,.1f", this.level);
        }

        @Override
        public String getDangerFromFuel() {
            return EnumChatFormatting.YELLOW + "MEDIUM / LOGARITHMIC";
        }
    }

    public static abstract class FunctionDoubleArg
    extends Function {
        protected double level;
        protected double vOff;

        public FunctionDoubleArg(double level, double vOff) {
            this.level = level;
            this.vOff = vOff;
        }
    }

    public static abstract class FunctionSingleArg
    extends Function {
        protected double level;

        public FunctionSingleArg(double level) {
            this.level = level;
        }
    }
}

