/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluidmk2;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidConnectorMK2;
import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import api.hbm.fluidmk2.IFluidUserMK2;
import api.ntm1of90.compat.fluid.HBMForgeFluidCompat;
import api.ntm1of90.compat.fluid.bridge.NTMFluidNetworkBridge;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.DirPos;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public interface IFluidReceiverMK2
extends IFluidUserMK2 {
    public long transferFluid(FluidType var1, int var2, long var3);

    default public long getReceiverSpeed(FluidType type, int pressure) {
        return 1000000000L;
    }

    public long getDemand(FluidType var1, int var2);

    default public int[] getReceivingPressureRange(FluidType type) {
        return DEFAULT_PRESSURE_RANGE;
    }

    default public void trySubscribe(FluidType type, World world, DirPos pos) {
        this.trySubscribe(type, world, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
    }

    default public void trySubscribe(FluidType type, World world, int x, int y, int z, ForgeDirection dir) {
        IFluidHandler forgeHandler;
        TileEntity te = Compat.getTileStandard(world, x, y, z);
        boolean red = false;
        if (te instanceof IFluidConnectorMK2) {
            IFluidConnectorMK2 con = (IFluidConnectorMK2)te;
            if (!con.canConnect(type, dir.getOpposite())) {
                return;
            }
            GenNode node = UniNodespace.getNode(world, x, y, z, type.getNetworkProvider());
            if (node != null && node.net != null) {
                ((NodeNet)node.net).addReceiver((IFluidReceiverMK2)this);
                red = true;
            }
        }
        if (te != this && HBMForgeFluidCompat.isForgeFluidHandler(te) && NTMFluidNetworkBridge.canForgeHandlerProvideFluid(forgeHandler = HBMForgeFluidCompat.getForgeFluidHandler(te), type, dir.getOpposite())) {
            long demand = this.getDemand(type, 0);
            if (demand <= 0L) {
                return;
            }
            if (this instanceof IFluidStandardReceiverMK2) {
                FluidTank[] tanks;
                IFluidStandardReceiverMK2 receiver = (IFluidStandardReceiverMK2)this;
                for (FluidTank tank : tanks = receiver.getReceivingTanks()) {
                    int transferred;
                    if (tank.getTankType() != type && tank.getTankType() != Fluids.NONE || (transferred = NTMFluidNetworkBridge.transferFromForge(forgeHandler, tank, dir.getOpposite(), tank.getMaxFill() - tank.getFill())) <= 0) continue;
                    if (tank.getTankType() == Fluids.NONE) {
                        tank.setTankType(type);
                    }
                    red = true;
                }
            }
        }
    }

    default public IEnergyReceiverMK2.ConnectionPriority getFluidPriority() {
        return IEnergyReceiverMK2.ConnectionPriority.NORMAL;
    }
}

