/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@SideOnly(value=Side.CLIENT)
public class AE2CompatTest {
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 compatibility test");
            return;
        }
        try {
            FMLCommonHandler.instance().bus().register((Object)new AE2CompatTest());
            MinecraftForge.EVENT_BUS.register((Object)new AE2CompatTest());
            AE2CompatTest.testAE2Integration();
            System.out.println("[NTM] AE2 compatibility test initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 compatibility test: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void testAE2Integration() {
        try {
            AE2CompatTest.testFluidRenderMap();
            AE2CompatTest.testFluidCellInventory();
            AE2CompatTest.testFluidItems();
            System.out.println("[NTM] AE2 compatibility test completed");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error testing AE2 integration: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void testFluidRenderMap() {
        try {
            Class<?> fluidRenderMapClass = Class.forName("appeng.client.texture.FluidRenderMap");
            Method instanceMethod = fluidRenderMapClass.getMethod("instance", new Class[0]);
            Object fluidRenderMap = instanceMethod.invoke(null, new Object[0]);
            Field colorsField = fluidRenderMapClass.getDeclaredField("colors");
            colorsField.setAccessible(true);
            Map colors = (Map)colorsField.get(fluidRenderMap);
            System.out.println("[NTM] AE2 FluidRenderMap colors map size: " + colors.size());
            int count = 0;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid) || !colors.containsKey(fluid)) continue;
                ++count;
            }
            System.out.println("[NTM] AE2 FluidRenderMap contains " + count + " of our fluids");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error testing AE2 FluidRenderMap: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void testFluidCellInventory() {
        try {
            Map fluidColorsMap;
            Class<?> fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
            Field fluidColorsField = null;
            for (Field field : fluidCellInventoryClass.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                fluidColorsField = field;
                break;
            }
            if (fluidColorsField != null && (fluidColorsMap = (Map)fluidColorsField.get(null)) != null) {
                System.out.println("[NTM] AE2 FluidCellInventory fluid colors map size: " + fluidColorsMap.size());
                int count = 0;
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    if (!(fluid instanceof ColoredForgeFluid) || !fluidColorsMap.containsKey(fluid)) continue;
                    ++count;
                }
                System.out.println("[NTM] AE2 FluidCellInventory contains " + count + " of our fluids");
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Error testing AE2 FluidCellInventory: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void testFluidItems() {
        try {
            Map fluidItemsMap;
            Class<?> fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
            Field fluidItemsField = null;
            for (Field field : fluidCellInventoryClass.getDeclaredFields()) {
                Map map;
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(null);
                if (fieldValue instanceof Map && !(map = (Map)fieldValue).isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof Fluid) || !(entry.getValue() instanceof ItemStack)) continue;
                        fluidItemsField = field;
                        break;
                    }
                }
                if (fluidItemsField != null) break;
            }
            if (fluidItemsField != null && (fluidItemsMap = (Map)fluidItemsField.get(null)) != null) {
                System.out.println("[NTM] AE2 FluidCellInventory fluid items map size: " + fluidItemsMap.size());
                int count = 0;
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    if (!(fluid instanceof ColoredForgeFluid) || !fluidItemsMap.containsKey(fluid)) continue;
                    ItemStack itemStack = (ItemStack)fluidItemsMap.get(fluid);
                    System.out.println("[NTM] AE2 FluidCellInventory contains item for fluid: " + fluid.getName() + " (item: " + itemStack.func_77973_b().func_77658_a() + ", meta: " + itemStack.func_77960_j() + ")");
                    ++count;
                }
                System.out.println("[NTM] AE2 FluidCellInventory contains " + count + " of our fluid items");
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Error testing fluid items: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            return;
        }
        GuiScreen gui = event.gui;
        if (gui == null) {
            return;
        }
        if (gui.getClass().getName().startsWith("appeng.client.gui")) {
            System.out.println("[NTM] AE2 GUI opened: " + gui.getClass().getName());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 600L == 0L) {
            AE2CompatTest.testAE2Integration();
        }
    }
}

