/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@SideOnly(value=Side.CLIENT)
public class AE2DirectColorFixer {
    private static boolean initialized = false;
    private static Map<String, Integer> fluidColors = new HashMap<String, Integer>();
    private static Class<?> fluidRenderMapClass = null;
    private static Object fluidRenderMapInstance = null;
    private static Field colorsField = null;
    private static Method registerFluidMethod = null;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 direct color fixer");
            return;
        }
        try {
            FMLCommonHandler.instance().bus().register((Object)new AE2DirectColorFixer());
            AE2DirectColorFixer.initializeAE2();
            System.out.println("[NTM] AE2 direct color fixer initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 direct color fixer: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        try {
            fluidRenderMapClass = Class.forName("appeng.client.texture.FluidRenderMap");
            Method instanceMethod = fluidRenderMapClass.getMethod("instance", new Class[0]);
            fluidRenderMapInstance = instanceMethod.invoke(null, new Object[0]);
            colorsField = fluidRenderMapClass.getDeclaredField("colors");
            colorsField.setAccessible(true);
            registerFluidMethod = fluidRenderMapClass.getMethod("registerFluid", Fluid.class, Integer.TYPE);
            AE2DirectColorFixer.registerAllFluidColors();
            System.out.println("[NTM] Successfully initialized AE2 direct color fixer");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 direct color fixer: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerAllFluidColors() {
        try {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int color = ((ColoredForgeFluid)fluid).getColorARGB();
                fluidColors.put(fluid.getName(), color);
                AE2DirectColorFixer.registerFluidColor(fluid, color);
            }
            System.out.println("[NTM] Registered all fluid colors with AE2");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering fluid colors with AE2: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerFluidColor(Fluid fluid, int color) {
        if (fluid == null) {
            return;
        }
        try {
            if (fluidRenderMapInstance != null && registerFluidMethod != null) {
                registerFluidMethod.invoke(fluidRenderMapInstance, fluid, color);
            }
            if (fluidRenderMapInstance != null && colorsField != null) {
                Map colors = (Map)colorsField.get(fluidRenderMapInstance);
                colors.put(fluid, color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 100L == 0L) {
            AE2DirectColorFixer.registerAllFluidColors();
        }
    }

    public static int getFluidColor(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        Integer color = fluidColors.get(fluid.getName());
        return color != null ? color : -1;
    }
}

