/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@SideOnly(value=Side.CLIENT)
public class AE2FluidCellInventoryFixer {
    private static boolean initialized = false;
    private static Map<String, Integer> fluidColors = new HashMap<String, Integer>();
    private static Class<?> fluidCellInventoryClass = null;
    private static Field fluidColorsField = null;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 fluid cell inventory fixer");
            return;
        }
        try {
            FMLCommonHandler.instance().bus().register((Object)new AE2FluidCellInventoryFixer());
            AE2FluidCellInventoryFixer.initializeAE2();
            System.out.println("[NTM] AE2 fluid cell inventory fixer initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid cell inventory fixer: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        try {
            fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
            for (Field field : fluidCellInventoryClass.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                fluidColorsField = field;
                break;
            }
            if (fluidColorsField == null) {
                System.err.println("[NTM] Could not find fluid colors field in FluidCellInventory");
                return;
            }
            AE2FluidCellInventoryFixer.registerAllFluidColors();
            System.out.println("[NTM] Successfully initialized AE2 fluid cell inventory fixer");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid cell inventory fixer: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerAllFluidColors() {
        if (fluidCellInventoryClass == null || fluidColorsField == null) {
            return;
        }
        try {
            Map colors = (Map)fluidColorsField.get(null);
            if (colors == null) {
                System.err.println("[NTM] Fluid colors map is null in FluidCellInventory");
                return;
            }
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int color = ((ColoredForgeFluid)fluid).getColorARGB();
                fluidColors.put(fluid.getName(), color);
                colors.put(fluid, color);
            }
            System.out.println("[NTM] Registered all fluid colors with AE2's fluid cell inventory");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering fluid colors with AE2's fluid cell inventory: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 100L == 0L) {
            AE2FluidCellInventoryFixer.registerAllFluidColors();
        }
    }

    public static int getFluidColor(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        Integer color = fluidColors.get(fluid.getName());
        return color != null ? color : -1;
    }
}

