/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.ae2.AE2CorePatcher;
import api.ntm1of90.compat.ae2.AE2DirectColorFixer;
import api.ntm1of90.compat.ae2.AE2FluidCellInventoryFixer;
import api.ntm1of90.compat.ae2.AE2FluidCellPatcher;
import api.ntm1of90.compat.ae2.AE2FluidCellRenderer;
import api.ntm1of90.compat.ae2.AE2FluidGUIHandler;
import api.ntm1of90.compat.ae2.AE2FluidStorageHandler;
import api.ntm1of90.compat.ae2.AE2RV2FluidColorHandler;
import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import api.ntm1of90.compat.fluid.render.NTMFluidColorApplier;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class AE2FluidColorHandler {
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 fluid color handler");
            return;
        }
        try {
            AE2FluidColorHandler.initializeAE2();
            System.out.println("[NTM] AE2 fluid color handler initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid color handler: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        MinecraftForge.EVENT_BUS.register((Object)new AE2FluidColorHandler());
        AE2FluidColorHandler.registerFluidColors();
        AE2FluidCellRenderer.initialize();
        AE2FluidStorageHandler.initialize();
        AE2FluidGUIHandler.initialize();
        AE2RV2FluidColorHandler.initialize();
        AE2CorePatcher.initialize();
        AE2FluidCellPatcher.initialize();
        AE2DirectColorFixer.initialize();
        AE2FluidCellInventoryFixer.initialize();
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerFluidColors() {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!(fluid instanceof ColoredForgeFluid)) continue;
            int color = NTMFluidColorApplier.getFluidColorForAE2(fluid);
            AE2FluidColorHandler.registerFluidColorWithAE2(fluid, color);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerFluidColorWithAE2(Fluid fluid, int color) {
        try {
            Object instance;
            try {
                Class<?> fluidRenderClass = Class.forName("appeng.client.render.FluidRendererRegistry");
                instance = fluidRenderClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                fluidRenderClass.getMethod("setFluidColor", Fluid.class, Integer.TYPE).invoke(instance, fluid, color);
                System.out.println("[NTM] Registered AE2 color for fluid via FluidRendererRegistry: " + fluid.getName() + " (0x" + Integer.toHexString(color) + ")");
            }
            catch (Exception e) {
                System.err.println("[NTM] Could not use FluidRendererRegistry: " + e.getMessage());
            }
            try {
                Class<?> fluidRenderMapClass = Class.forName("appeng.client.texture.FluidRenderMap");
                instance = fluidRenderMapClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                fluidRenderMapClass.getMethod("registerFluid", Fluid.class, Integer.TYPE).invoke(instance, fluid, color);
                System.out.println("[NTM] Registered AE2 color for fluid via FluidRenderMap: " + fluid.getName() + " (0x" + Integer.toHexString(color) + ")");
            }
            catch (Exception e) {
                System.err.println("[NTM] Could not use FluidRenderMap: " + e.getMessage());
            }
            try {
                Class<?> cellInventoryHandlerClass = Class.forName("appeng.me.storage.CellInventoryHandler");
                cellInventoryHandlerClass.getMethod("registerFluidColor", Fluid.class, Integer.TYPE).invoke(null, fluid, color);
                System.out.println("[NTM] Registered AE2 color for fluid via CellInventoryHandler: " + fluid.getName() + " (0x" + Integer.toHexString(color) + ")");
            }
            catch (Exception e) {
                System.err.println("[NTM] Could not use CellInventoryHandler: " + e.getMessage());
            }
            try {
                Class<?> fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
                fluidCellInventoryClass.getMethod("registerFluidColor", Fluid.class, Integer.TYPE).invoke(null, fluid, color);
                System.out.println("[NTM] Registered AE2 color for fluid via FluidCellInventory: " + fluid.getName() + " (0x" + Integer.toHexString(color) + ")");
            }
            catch (Exception e) {
                System.err.println("[NTM] Could not use FluidCellInventory: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering AE2 color for fluid " + fluid.getName() + ": " + e.getMessage());
        }
    }
}

