/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.adapter;

import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardSenderMK2;
import api.hbm.fluidmk2.IFluidUserMK2;
import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.util.NTMForgeFluidConverter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class AutoForgeFluidAdapter
implements IFluidHandler {
    private final IFluidUserMK2 fluidUser;
    private final TileEntity tileEntity;

    public AutoForgeFluidAdapter(IFluidUserMK2 fluidUser, TileEntity tileEntity) {
        this.fluidUser = fluidUser;
        this.tileEntity = tileEntity;
    }

    private int toForgeAmount(int ntmAmount) {
        return NTMForgeFluidConverter.toForgeAmount(ntmAmount);
    }

    private int toNTMAmount(int forgeAmount) {
        return NTMForgeFluidConverter.toNTMAmount(forgeAmount);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
        if (ntmFluid == Fluids.NONE) {
            return 0;
        }
        if (this.fluidUser instanceof IFluidStandardReceiverMK2) {
            IFluidStandardReceiverMK2 receiver = (IFluidStandardReceiverMK2)this.fluidUser;
            FluidTank[] tanks = receiver.getReceivingTanks();
            if (tanks.length == 0) {
                return 0;
            }
            for (FluidTank tank : tanks) {
                int ntmAmount;
                int fillAmount;
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                int maxFill = tank.getMaxFill();
                if (currentFill >= maxFill || currentFill > 0 && currentType != ntmFluid || (fillAmount = Math.min(ntmAmount = this.toNTMAmount(resource.amount), maxFill - currentFill)) <= 0) continue;
                if (doFill) {
                    if (currentFill == 0) {
                        tank.setTankType(ntmFluid);
                    }
                    tank.setFill(currentFill + fillAmount);
                    if (this.tileEntity != null) {
                        this.tileEntity.func_70296_d();
                    }
                }
                return this.toForgeAmount(fillAmount);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0) {
            return null;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
        if (ntmFluid == Fluids.NONE) {
            return null;
        }
        if (this.fluidUser instanceof IFluidStandardSenderMK2) {
            IFluidStandardSenderMK2 sender = (IFluidStandardSenderMK2)this.fluidUser;
            FluidTank[] tanks = sender.getSendingTanks();
            if (tanks.length == 0) {
                return null;
            }
            for (FluidTank tank : tanks) {
                Fluid forgeFluid;
                int ntmAmount;
                int drainAmount;
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                if (currentFill <= 0 || currentType != ntmFluid || (drainAmount = Math.min(ntmAmount = this.toNTMAmount(resource.amount), currentFill)) <= 0) continue;
                if (doDrain) {
                    int newFill = currentFill - drainAmount;
                    tank.setFill(newFill);
                    if (newFill <= 0) {
                        tank.setTankType(Fluids.NONE);
                    }
                    if (this.tileEntity != null) {
                        this.tileEntity.func_70296_d();
                    }
                }
                if ((forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null) continue;
                return new FluidStack(forgeFluid, this.toForgeAmount(drainAmount));
            }
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        if (this.fluidUser instanceof IFluidStandardSenderMK2) {
            IFluidStandardSenderMK2 sender = (IFluidStandardSenderMK2)this.fluidUser;
            FluidTank[] tanks = sender.getSendingTanks();
            if (tanks.length == 0) {
                return null;
            }
            for (FluidTank tank : tanks) {
                int ntmDrainAmount;
                int drainAmount;
                Fluid forgeFluid;
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                if (currentFill <= 0 || currentType == Fluids.NONE || (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null || (drainAmount = Math.min(ntmDrainAmount = this.toNTMAmount(maxDrain), currentFill)) <= 0) continue;
                if (doDrain) {
                    int newFill = currentFill - drainAmount;
                    tank.setFill(newFill);
                    if (newFill <= 0) {
                        tank.setTankType(Fluids.NONE);
                    }
                    if (this.tileEntity != null) {
                        this.tileEntity.func_70296_d();
                    }
                }
                return new FluidStack(forgeFluid, this.toForgeAmount(drainAmount));
            }
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(fluid);
        if (ntmFluid == Fluids.NONE) {
            return false;
        }
        if (this.fluidUser instanceof IFluidStandardReceiverMK2) {
            IFluidStandardReceiverMK2 receiver = (IFluidStandardReceiverMK2)this.fluidUser;
            FluidTank[] tanks = receiver.getReceivingTanks();
            if (tanks.length == 0) {
                return false;
            }
            for (FluidTank tank : tanks) {
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                int maxFill = tank.getMaxFill();
                if (currentFill >= maxFill || currentFill > 0 && currentType != ntmFluid) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(fluid);
        if (ntmFluid == Fluids.NONE) {
            return false;
        }
        if (this.fluidUser instanceof IFluidStandardSenderMK2) {
            IFluidStandardSenderMK2 sender = (IFluidStandardSenderMK2)this.fluidUser;
            FluidTank[] tanks = sender.getSendingTanks();
            if (tanks.length == 0) {
                return false;
            }
            for (FluidTank tank : tanks) {
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                if (currentFill <= 0 || currentType != ntmFluid) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTank[] tanks = this.fluidUser.getAllTanks();
        FluidTankInfo[] tankInfo = new FluidTankInfo[tanks.length];
        for (int i = 0; i < tanks.length; ++i) {
            Fluid forgeFluid;
            FluidTank tank = tanks[i];
            int currentFill = tank.getFill();
            int maxFill = tank.getMaxFill();
            FluidType currentType = tank.getTankType();
            FluidStack stack = null;
            if (currentFill > 0 && currentType != Fluids.NONE && (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) != null) {
                stack = new FluidStack(forgeFluid, this.toForgeAmount(currentFill));
            }
            tankInfo[i] = new FluidTankInfo(stack, this.toForgeAmount(maxFill));
        }
        return tankInfo;
    }

    static {
        FluidMappingRegistry.initialize();
    }
}

