/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.adapter;

import api.ntm1of90.compat.fluid.adapter.NTMFluidNetworkAdapter;
import api.ntm1of90.compat.fluid.bridge.NTMFluidNetworkBridge;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class NTMFluidTileAdapter {
    public static IFluidHandler createFluidHandler(TileEntity tile, FluidTank tank) {
        return new NTMFluidNetworkAdapter(tank, tile);
    }

    public static boolean isForgeFluidHandler(TileEntity tile) {
        return tile instanceof IFluidHandler;
    }

    public static IFluidHandler getForgeFluidHandler(TileEntity tile) {
        if (tile instanceof IFluidHandler) {
            return (IFluidHandler)tile;
        }
        return null;
    }

    public static int transferToAdjacent(TileEntityMachineBase machine, FluidTank tank, ForgeDirection direction, int maxAmount) {
        if (machine == null || tank == null || maxAmount <= 0) {
            return 0;
        }
        TileEntity adjacent = machine.func_145831_w().func_147438_o(machine.field_145851_c + direction.offsetX, machine.field_145848_d + direction.offsetY, machine.field_145849_e + direction.offsetZ);
        if (!NTMFluidTileAdapter.isForgeFluidHandler(adjacent)) {
            return 0;
        }
        IFluidHandler handler = NTMFluidTileAdapter.getForgeFluidHandler(adjacent);
        return NTMFluidNetworkBridge.transferToForge(tank, handler, direction, maxAmount);
    }

    public static int transferFromAdjacent(TileEntityMachineBase machine, FluidTank tank, ForgeDirection direction, int maxAmount) {
        if (machine == null || tank == null || maxAmount <= 0) {
            return 0;
        }
        TileEntity adjacent = machine.func_145831_w().func_147438_o(machine.field_145851_c + direction.offsetX, machine.field_145848_d + direction.offsetY, machine.field_145849_e + direction.offsetZ);
        if (!NTMFluidTileAdapter.isForgeFluidHandler(adjacent)) {
            return 0;
        }
        IFluidHandler handler = NTMFluidTileAdapter.getForgeFluidHandler(adjacent);
        return NTMFluidNetworkBridge.transferFromForge(handler, tank, direction, maxAmount);
    }
}

