/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.render;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class NTMFluidColorApplier {
    private static float brightnessFactor = 1.0f;

    public static void initialize() {
        System.out.println("[NTM] Fluid color applier initialized");
    }

    public static void setBrightnessFactor(float factor) {
        brightnessFactor = factor;
        System.out.println("[NTM] Fluid color brightness factor set to " + factor);
    }

    public static boolean applyFluidColor(Fluid fluid) {
        if (fluid == null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return false;
        }
        if (fluid instanceof ColoredForgeFluid) {
            int color = ((ColoredForgeFluid)fluid).getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f * brightnessFactor;
            float g = (float)(color >> 8 & 0xFF) / 255.0f * brightnessFactor;
            float b = (float)(color & 0xFF) / 255.0f * brightnessFactor;
            r = Math.min(1.0f, Math.max(0.0f, r));
            g = Math.min(1.0f, Math.max(0.0f, g));
            b = Math.min(1.0f, Math.max(0.0f, b));
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            return true;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return false;
    }

    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int getFluidColorForAE2(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        if (fluid instanceof ColoredForgeFluid) {
            return ((ColoredForgeFluid)fluid).getColorARGB();
        }
        return -1;
    }

    public static int getFluidColorForInventory(Fluid fluid) {
        if (fluid == null) {
            return 0xFFFFFF;
        }
        if (fluid instanceof ColoredForgeFluid) {
            return ((ColoredForgeFluid)fluid).getColor();
        }
        return 0xFFFFFF;
    }
}

