/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.fluid;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.fluid.VolcanicBlock;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class RadBlock
extends VolcanicBlock {
    @SideOnly(value=Side.CLIENT)
    public static IIcon stillIconRad;
    @SideOnly(value=Side.CLIENT)
    public static IIcon flowingIconRad;

    public RadBlock(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        stillIconRad = register.func_94245_a("hbm:rad_lava_still");
        flowingIconRad = register.func_94245_a("hbm:rad_lava_flowing");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? stillIconRad : flowingIconRad;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            ContaminationUtil.contaminate((EntityLivingBase)entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 5.0f);
        }
    }

    @Override
    public void onSolidify(World world, int x, int y, int z, int lavaCount, int basaltCount, Random rand) {
        int r = rand.nextInt(400);
        Block above = world.func_147439_a(x, y + 10, z);
        boolean canMakeGem = lavaCount + basaltCount == 6 && lavaCount < 3 && (above == ModBlocks.sellafield_slaked || above == ModBlocks.rad_lava_block);
        int meta = 5 + rand.nextInt(3);
        if (r < 2) {
            world.func_147465_d(x, y, z, ModBlocks.ore_sellafield_diamond, meta, 3);
        } else if (r == 2) {
            world.func_147465_d(x, y, z, ModBlocks.ore_sellafield_emerald, meta, 3);
        } else if (r < 20 && canMakeGem) {
            world.func_147465_d(x, y, z, ModBlocks.ore_sellafield_radgem, meta, 3);
        } else {
            world.func_147465_d(x, y, z, ModBlocks.sellafield_slaked, meta, 3);
        }
    }

    @Override
    public Block getBasaltForCheck() {
        return ModBlocks.sellafield_slaked;
    }

    @Override
    public Block getReaction(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.func_149688_o() == Material.field_151586_h) {
            return Blocks.field_150348_b;
        }
        if (b == Blocks.field_150364_r || b == Blocks.field_150363_s) {
            return ModBlocks.waste_log;
        }
        if (b == Blocks.field_150344_f) {
            return ModBlocks.waste_planks;
        }
        if (b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
            return Blocks.field_150480_ab;
        }
        if (b == Blocks.field_150482_ag) {
            return ModBlocks.ore_sellafield_radgem;
        }
        if (b == ModBlocks.ore_uranium || b == ModBlocks.ore_gneiss_uranium) {
            return world.field_73012_v.nextInt(5) == 0 ? ModBlocks.ore_sellafield_schrabidium : ModBlocks.ore_sellafield_uranium_scorched;
        }
        return null;
    }
}

