/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.grenade;

import com.hbm.config.GeneralConfig;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class EntityGrenadeBouncyBase
extends Entity
implements IProjectile {
    protected EntityLivingBase thrower;
    protected String throwerName;
    protected int timer = 0;

    public EntityGrenadeBouncyBase(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityGrenadeBouncyBase(World world, EntityLivingBase living) {
        super(world);
        this.thrower = living;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, living.field_70177_z, living.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + this.func_70183_g()) / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.func_70182_d(), 1.0f);
        this.field_70125_A = 0.0f;
        this.field_70127_C = 0.0f;
    }

    public EntityGrenadeBouncyBase(World world, double posX, double posY, double posZ) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(posX, posY, posZ);
        this.field_70129_M = 0.0f;
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    protected float func_70182_d() {
        return 1.5f;
    }

    protected float func_70183_g() {
        return 0.0f;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public void func_70186_c(double motionX, double motionY, double motionZ, float f0, float f1) {
        float f2 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)f2;
        motionY /= (double)f2;
        motionZ /= (double)f2;
        motionX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        motionY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        motionZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        this.field_70159_w = motionX *= (double)f0;
        this.field_70181_x = motionY *= (double)f0;
        this.field_70179_y = motionZ *= (double)f0;
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70125_A = (float)((double)this.field_70125_A - Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72433_c() * 25.0);
        boolean bounce = false;
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(vec3, vec31, false, true, false);
        if (movingobjectposition != null) {
            vec31 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
            this.field_70165_t += (movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t) * 0.6;
            this.field_70163_u += (movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u) * 0.6;
            this.field_70161_v += (movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v) * 0.6;
            switch (movingobjectposition.field_72310_e) {
                case 0: 
                case 1: {
                    this.field_70181_x *= -1.0;
                    break;
                }
                case 2: 
                case 3: {
                    this.field_70179_y *= -1.0;
                    break;
                }
                case 4: 
                case 5: {
                    this.field_70159_w *= -1.0;
                }
            }
            bounce = true;
            Vec3 mot = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
            if (mot.func_72433_c() > 0.05) {
                this.field_70170_p.func_72956_a((Entity)this, "hbm:weapon.gBounce", 2.0f, 1.0f);
            }
            this.field_70159_w *= this.getBounceMod();
            this.field_70181_x *= this.getBounceMod();
            this.field_70179_y *= this.getBounceMod();
        }
        if (!bounce) {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
        }
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = 0.99f;
        float f3 = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            f2 = 0.8f;
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.field_70181_x -= (double)f3;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        ++this.timer;
        if (this.timer >= this.getMaxTimer() && !this.field_70170_p.field_72995_K) {
            this.explode();
            String s = "null";
            if (this.thrower != null && this.thrower instanceof EntityPlayer) {
                s = ((EntityPlayer)this.thrower).getDisplayName();
            }
            if (GeneralConfig.enableExtendedLogging) {
                MainRegistry.logger.log(Level.INFO, "[GREN] Set off grenade at " + (int)this.field_70165_t + " / " + (int)this.field_70163_u + " / " + (int)this.field_70161_v + " by " + s + "!");
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.timer = nbt.func_74762_e("timer");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("timer", this.timer);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    public abstract void explode();

    protected abstract int getMaxTimer();

    protected abstract double getBounceMod();
}

