/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.logic.EntityPlaneBase;
import com.hbm.entity.projectile.EntityBombletZeta;
import com.hbm.entity.projectile.EntityBoxcar;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.interfaces.NotableComments;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@NotableComments
public class EntityBomber
extends EntityPlaneBase {
    int bombStart = 75;
    int bombStop = 125;
    int bombRate = 3;
    public int type = 0;
    protected AudioWrapper audio;

    public EntityBomber(World world) {
        super(world);
        this.field_70158_ak = true;
        this.func_70105_a(8.0f, 4.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70096_w().func_111145_d(17) > 0.0f) {
                if (this.audio == null || !this.audio.isPlaying()) {
                    byte bomberType = this.field_70180_af.func_75683_a(16);
                    this.audio = MainRegistry.proxy.getLoopedSound(bomberType <= 4 ? "hbm:entity.bomberSmallLoop" : "hbm:entity.bomberLoop", (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 2.0f, 250.0f, 1.0f, 20);
                    this.audio.startSound();
                }
                this.audio.keepAlive();
                this.audio.updatePosition((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
            } else if (this.audio != null && this.audio.isPlaying()) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.health > 0.0f && this.field_70173_aa > this.bombStart && this.field_70173_aa < this.bombStop && this.field_70173_aa % this.bombRate == 0) {
            if (this.type == 3) {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "random.fizz", 5.0f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f);
                ExplosionChaos.spawnPoisonCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, 10, 0.5, 3);
            } else if (this.type != 5) {
                if (this.type == 6) {
                    this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hbm:weapon.missileTakeOff", 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                    EntityBoxcar rocket = new EntityBoxcar(this.field_70170_p);
                    rocket.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    rocket.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                    rocket.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    this.field_70170_p.func_72838_d((Entity)rocket);
                } else if (this.type == 7) {
                    this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "random.fizz", 5.0f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f);
                    ExplosionChaos.spawnPoisonCloud(this.field_70170_p, this.field_70165_t, this.field_70170_p.func_72976_f((int)this.field_70165_t, (int)this.field_70161_v) + 2, this.field_70161_v, 10, 1.0, 2);
                } else {
                    this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hbm:entity.bombWhistle", 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                    EntityBombletZeta zeta = new EntityBombletZeta(this.field_70170_p);
                    zeta.rotation();
                    zeta.type = this.type;
                    zeta.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    zeta.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                    zeta.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    if (this.type == 0) {
                        zeta.field_70159_w = this.field_70159_w + this.field_70146_Z.nextGaussian() * 0.15;
                        zeta.field_70179_y = this.field_70179_y + this.field_70146_Z.nextGaussian() * 0.15;
                    } else {
                        zeta.field_70159_w = this.field_70159_w;
                        zeta.field_70179_y = this.field_70179_y;
                    }
                    this.field_70170_p.func_72838_d((Entity)zeta);
                }
            }
        }
    }

    public void fac(World world, double x, double y, double z) {
        Vec3 vector = Vec3.func_72443_a((double)(world.field_73012_v.nextDouble() - 0.5), (double)0.0, (double)(world.field_73012_v.nextDouble() - 0.5));
        vector = vector.func_72432_b();
        vector.field_72450_a = vector.field_72450_a * (GeneralConfig.enableBomberShortMode ? 1.0 : 2.0);
        vector.field_72449_c = vector.field_72449_c * (GeneralConfig.enableBomberShortMode ? 1.0 : 2.0);
        this.func_70012_b(x - vector.field_72450_a * 100.0, y + 50.0, z - vector.field_72449_c * 100.0, 0.0f, 0.0f);
        this.loadNeighboringChunks((int)(x / 16.0), (int)(z / 16.0));
        this.field_70159_w = vector.field_72450_a;
        this.field_70179_y = vector.field_72449_c;
        this.field_70181_x = 0.0;
        this.rotation();
        int i = 1;
        int rand = world.field_73012_v.nextInt(7);
        switch (rand) {
            case 0: 
            case 1: {
                i = 1;
                break;
            }
            case 2: 
            case 3: {
                i = 2;
                break;
            }
            case 4: {
                i = 5;
                break;
            }
            case 5: {
                i = 6;
                break;
            }
            case 6: {
                i = 7;
            }
        }
        if (world.field_73012_v.nextInt(100) == 0) {
            rand = world.field_73012_v.nextInt(4);
            switch (rand) {
                case 0: {
                    i = 0;
                    break;
                }
                case 1: {
                    i = 3;
                    break;
                }
                case 2: {
                    i = 4;
                    break;
                }
                case 3: {
                    i = 8;
                }
            }
        }
        this.func_70096_w().func_75692_b(16, (Object)((byte)i));
        this.func_70105_a(8.0f, 4.0f);
    }

    public static EntityBomber statFacCarpet(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 2;
        bomber.fac(world, x, y, z);
        bomber.type = 0;
        return bomber;
    }

    public static EntityBomber statFacNapalm(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 5;
        bomber.fac(world, x, y, z);
        bomber.type = 1;
        return bomber;
    }

    public static EntityBomber statFacChlorine(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 4;
        bomber.fac(world, x, y, z);
        bomber.type = 2;
        return bomber;
    }

    public static EntityBomber statFacOrange(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 75;
        bomber.bombStop = 125;
        bomber.bombRate = 1;
        bomber.fac(world, x, y, z);
        bomber.type = 3;
        return bomber;
    }

    public static EntityBomber statFacABomb(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 60;
        bomber.bombStop = 70;
        bomber.bombRate = 65;
        bomber.fac(world, x, y, z);
        int i = 1;
        int rand = world.field_73012_v.nextInt(3);
        switch (rand) {
            case 0: {
                i = 5;
                break;
            }
            case 1: {
                i = 6;
                break;
            }
            case 2: {
                i = 7;
            }
        }
        if (world.field_73012_v.nextInt(100) == 0) {
            i = 8;
        }
        bomber.func_70096_w().func_75692_b(16, (Object)((byte)i));
        bomber.type = 4;
        return bomber;
    }

    public static EntityBomber statFacStinger(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 150;
        bomber.bombRate = 10;
        bomber.fac(world, x, y, z);
        bomber.func_70096_w().func_75692_b(16, (Object)4);
        bomber.type = 5;
        return bomber;
    }

    public static EntityBomber statFacBoxcar(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 150;
        bomber.bombRate = 10;
        bomber.fac(world, x, y, z);
        bomber.func_70096_w().func_75692_b(16, (Object)6);
        bomber.type = 6;
        return bomber;
    }

    public static EntityBomber statFacPC(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 75;
        bomber.bombStop = 125;
        bomber.bombRate = 1;
        bomber.fac(world, x, y, z);
        bomber.func_70096_w().func_75692_b(16, (Object)6);
        bomber.type = 7;
        return bomber;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.bombStart = nbt.func_74762_e("bombStart");
        this.bombStop = nbt.func_74762_e("bombStop");
        this.bombRate = nbt.func_74762_e("bombRate");
        this.type = nbt.func_74762_e("type");
        this.func_70096_w().func_75692_b(16, (Object)nbt.func_74771_c("style"));
        this.func_70105_a(8.0f, 4.0f);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("bombStart", this.bombStart);
        nbt.func_74768_a("bombStop", this.bombStop);
        nbt.func_74768_a("bombRate", this.bombRate);
        nbt.func_74768_a("type", this.type);
        nbt.func_74774_a("style", this.func_70096_w().func_75683_a(16));
    }
}

