/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.handler.BulletConfiguration;
import com.hbm.util.BobMathUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Vec3;

public class BulletConfigFactory {
    public static final float defaultSpread = 0.005f;

    public static BulletConfiguration standardBulletConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 5.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 5.0;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = true;
        bullet.destroysBlocks = false;
        bullet.style = 0;
        bullet.plink = 1;
        bullet.leadChance = 5;
        return bullet;
    }

    public static BulletConfiguration standardRocketConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 2.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.005;
        bullet.maxAge = 300;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 10.0;
        bullet.HBRC = 2;
        bullet.LBRC = 100;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.explosive = 5.0f;
        bullet.style = 6;
        bullet.plink = 2;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration standardGrenadeConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 2.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.035;
        bullet.maxAge = 300;
        bullet.doesRicochet = false;
        bullet.ricochetAngle = 0.0;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.bounceMod = 1.0;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.explosive = 2.5f;
        bullet.style = 10;
        bullet.plink = 2;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static EntityBulletBaseNT.IBulletUpdateBehaviorNT getHomingBehavior(final double range, final double angle) {
        EntityBulletBaseNT.IBulletUpdateBehaviorNT onUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                Entity target;
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget")) == null) {
                    this.chooseTarget(bullet);
                }
                if ((target = bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget"))) != null) {
                    Vec3 delta = Vec3.func_72443_a((double)(target.field_70165_t - bullet.field_70165_t), (double)(target.field_70163_u + (double)(target.field_70131_O / 2.0f) - bullet.field_70163_u), (double)(target.field_70161_v - bullet.field_70161_v));
                    delta = delta.func_72432_b();
                    double vel = Vec3.func_72443_a((double)bullet.field_70159_w, (double)bullet.field_70181_x, (double)bullet.field_70179_y).func_72433_c();
                    bullet.field_70159_w = delta.field_72450_a * vel;
                    bullet.field_70181_x = delta.field_72448_b * vel;
                    bullet.field_70179_y = delta.field_72449_c * vel;
                }
            }

            private void chooseTarget(EntityBulletBaseNT bullet) {
                List entities = bullet.field_70170_p.func_72872_a(EntityLivingBase.class, bullet.field_70121_D.func_72314_b(range, range, range));
                Vec3 mot = Vec3.func_72443_a((double)bullet.field_70159_w, (double)bullet.field_70181_x, (double)bullet.field_70179_y);
                EntityLivingBase target = null;
                double targetAngle = angle;
                for (EntityLivingBase e : entities) {
                    double deltaAngle;
                    double dist;
                    if (!e.func_70089_S() || e == bullet.getThrower()) continue;
                    Vec3 delta = Vec3.func_72443_a((double)(e.field_70165_t - bullet.field_70165_t), (double)(e.field_70163_u + (double)(e.field_70131_O / 2.0f) - bullet.field_70163_u), (double)(e.field_70161_v - bullet.field_70161_v));
                    if (bullet.field_70170_p.func_147447_a(Vec3.func_72443_a((double)bullet.field_70165_t, (double)bullet.field_70163_u, (double)bullet.field_70161_v), Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)(e.field_70131_O / 2.0f)), (double)e.field_70161_v), false, true, false) != null || !((dist = e.func_70068_e((Entity)bullet)) < range * range) || !((deltaAngle = BobMathUtil.getCrossAngle(mot, delta)) < targetAngle) || bullet.getConfig().doesPenetrate && bullet.field_70170_p.func_72872_a(EntityLivingBase.class, bullet.field_70121_D.func_72314_b(2.0, 2.0, 2.0)) == null) continue;
                    target = e;
                    targetAngle = deltaAngle;
                }
                if (target != null) {
                    bullet.getEntityData().func_74768_a("homingTarget", target.func_145782_y());
                }
            }
        };
        return onUpdate;
    }

    public static EntityBulletBaseNT.IBulletHurtBehaviorNT getPenHomingBehavior() {
        return (bullet, hit) -> bullet.getEntityData().func_74768_a("homingTarget", 0);
    }
}

