/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.main.MainRegistry;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GUIScreenWikiRender
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/nei/gui_nei.png");
    protected ItemStack[] preview;
    protected int index = 0;
    protected int scale = 1;
    protected String saveLocation = "wiki-screenshots";
    protected String prefix = "";
    protected Function<ItemStack, String> getStackName = stack -> stack.func_82833_r();
    private static IntBuffer pixelBuffer;
    private static int[] pixelValues;

    public GUIScreenWikiRender(ItemStack[] stacks, String prefix, String directory, int scale) {
        this.preview = stacks;
        this.prefix = prefix;
        this.saveLocation = directory;
        this.scale = scale;
    }

    public GUIScreenWikiRender(ItemStack[] stacks, String prefix, String directory, int scale, Function<ItemStack, String> getStackName) {
        this(stacks, prefix, directory, scale);
        this.getStackName = getStackName;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (this.field_146297_k.field_71441_e != null) {
            GuiScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-3750202);
        } else {
            this.func_146278_c(0);
        }
        if (this.index >= this.preview.length) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.drawGuiContainerBackgroundLayer();
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(this.preview[this.index]);
        GL11.glEnable((int)2896);
        ScaledResolution res = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int zoom = this.scale * res.func_78325_e();
        try {
            String slotName = this.getStackName.apply(this.preview[this.index]).replaceAll("\u00a7.", "").replaceAll("[^\\w ().-]+", "");
            if (!slotName.endsWith(".name")) {
                GUIScreenWikiRender.saveScreenshot(Minecraft.func_71410_x().field_71412_D, this.saveLocation, this.prefix + slotName + ".png", zoom, zoom, zoom * 16, zoom * 16, -7631989);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.index;
    }

    protected void drawGuiContainerBackgroundLayer() {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        ScaledResolution res = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
        this.drawTexturedModalRect(0.0, res.func_78324_d() / (double)this.scale - 18.0, 5, 87, 18, 18);
        GL11.glPopMatrix();
    }

    public void drawTexturedModalRect(double x, double y, int sourceX, int sourceY, int sizeX, int sizeY) {
        double f = 0.00390625;
        double f1 = 0.00390625;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + (double)sizeY, (double)this.field_73735_i, (double)(sourceX + 0) * f, (double)(sourceY + sizeY) * f1);
        tessellator.func_78374_a(x + (double)sizeX, y + (double)sizeY, (double)this.field_73735_i, (double)(sourceX + sizeX) * f, (double)(sourceY + sizeY) * f1);
        tessellator.func_78374_a(x + (double)sizeX, y + 0.0, (double)this.field_73735_i, (double)(sourceX + sizeX) * f, (double)(sourceY + 0) * f1);
        tessellator.func_78374_a(x + 0.0, y + 0.0, (double)this.field_73735_i, (double)(sourceX + 0) * f, (double)(sourceY + 0) * f1);
        tessellator.func_78381_a();
    }

    protected void drawGuiContainerForegroundLayer(ItemStack preview) {
        if (preview == null) {
            return;
        }
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
        ScaledResolution res = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        GL11.glTranslated((double)9.0, (double)(res.func_78324_d() / (double)this.scale - 9.0), (double)-200.0);
        this.field_73735_i = 200.0f;
        GUIScreenWikiRender.field_146296_j.field_77023_b = 200.0f;
        GL11.glEnable((int)2929);
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), preview, -8, -8);
        field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.func_110434_K(), preview, -8, -8, null);
        GUIScreenWikiRender.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        GL11.glPopMatrix();
    }

    private static void saveScreenshot(File dataDir, String ssDir, String fileName, int x, int y, int width, int height, int transparentColor) {
        try {
            File screenshotDirectory = new File(dataDir, ssDir);
            screenshotDirectory.mkdir();
            int bufferSize = width * height;
            if (pixelBuffer == null || pixelBuffer.capacity() < bufferSize) {
                pixelBuffer = BufferUtils.createIntBuffer((int)bufferSize);
                pixelValues = new int[bufferSize];
            }
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            pixelBuffer.clear();
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
            pixelBuffer.get(pixelValues);
            TextureUtil.func_147953_a((int[])pixelValues, (int)width, (int)height);
            BufferedImage imageBuffer = new BufferedImage(width, height, 2);
            imageBuffer.setRGB(0, 0, width, height, pixelValues, 0, width);
            if (transparentColor != 0) {
                for (int iy = 0; iy < imageBuffer.getHeight(); ++iy) {
                    for (int ix = 0; ix < imageBuffer.getWidth(); ++ix) {
                        if (imageBuffer.getRGB(ix, iy) != transparentColor) continue;
                        imageBuffer.setRGB(ix, iy, 0);
                    }
                }
            }
            if (fileName == null) {
                throw new IllegalArgumentException("fileName must not be null");
            }
            File imageFile = new File(screenshotDirectory, fileName);
            ImageIO.write((RenderedImage)imageBuffer, "png", imageFile);
        }
        catch (Exception ex) {
            MainRegistry.logger.warn("Failed to save NTM screenshot", (Throwable)ex);
        }
    }
}

