/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.factory;

import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.entity.projectile.EntityBulletBaseMK4CL;
import com.hbm.entity.projectile.EntityBulletBeamBase;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.EntityProcessorCrossSmooth;
import com.hbm.explosion.vanillant.standard.ExplosionEffectTiny;
import com.hbm.explosion.vanillant.standard.ExplosionEffectWeapon;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.interfaces.NotableComments;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.main.MainRegistry;
import com.hbm.particle.helper.BlackPowderCreator;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

@NotableComments
public class Lego {
    public static final Random ANIM_RAND = new Random();
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STANDARD_RELOAD = (stack, ctx) -> {
        EntityPlayer player = ctx.getPlayer();
        Receiver rec = ctx.config.getReceivers((ItemStack)stack)[0];
        ItemGunBaseNT.GunState state = ItemGunBaseNT.getState(stack, ctx.configIndex);
        if (state == ItemGunBaseNT.GunState.IDLE) {
            ItemGunBaseNT.setIsAiming(stack, false);
            IMagazine mag = rec.getMagazine((ItemStack)stack);
            if (mag.canReload((ItemStack)stack, ctx.inventory)) {
                int loaded = mag.getAmount((ItemStack)stack, ctx.inventory);
                mag.setAmountBeforeReload((ItemStack)stack, loaded);
                ItemGunBaseNT.setState(stack, ctx.configIndex, ItemGunBaseNT.GunState.RELOADING);
                ItemGunBaseNT.setTimer(stack, ctx.configIndex, rec.getReloadBeginDuration((ItemStack)stack) + (loaded <= 0 ? rec.getReloadCockOnEmptyPre((ItemStack)stack) : 0));
                ItemGunBaseNT.playAnimation(player, stack, HbmAnimations.AnimType.RELOAD, ctx.configIndex);
                if (ctx.config.getReloadChangesType((ItemStack)stack)) {
                    mag.initNewType((ItemStack)stack, ctx.inventory);
                }
            } else {
                ItemGunBaseNT.playAnimation(player, stack, HbmAnimations.AnimType.INSPECT, ctx.configIndex);
                if (!ctx.config.getInspectCancel((ItemStack)stack)) {
                    ItemGunBaseNT.setState(stack, ctx.configIndex, ItemGunBaseNT.GunState.DRAWING);
                    ItemGunBaseNT.setTimer(stack, ctx.configIndex, ctx.config.getInspectDuration((ItemStack)stack));
                }
            }
        }
    };
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STANDARD_CLICK_PRIMARY = (stack, ctx) -> Lego.clickReceiver(stack, ctx, 0);
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STANDARD_CLICK_SECONDARY = (stack, ctx) -> {
        EntityLivingBase entity = ctx.entity;
        int index = ctx.configIndex;
        ItemGunBaseNT.GunState state = ItemGunBaseNT.getState(stack, index);
        if (state == ItemGunBaseNT.GunState.IDLE) {
            int mode = ItemGunBaseNT.getMode(stack, 0);
            ItemGunBaseNT.setMode(stack, index, 1 - mode);
            if (mode == 0) {
                entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "hbm:weapon.switchmode1", 1.0f, 1.0f);
            } else {
                entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "hbm:weapon.switchmode2", 1.0f, 1.0f);
            }
        }
    };
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STANDARD_SMOKE = (stack, ctx) -> Lego.handleStandardSmoke(ctx.entity, stack, 2000, 0.025, 1.15, ctx.configIndex);
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_TOGGLE_AIM = (stack, ctx) -> ItemGunBaseNT.setIsAiming(stack, !ItemGunBaseNT.getIsAiming(stack));
    public static BiFunction<ItemStack, ItemGunBaseNT.LambdaContext, Boolean> LAMBDA_STANDARD_CAN_FIRE = (stack, ctx) -> ctx.config.getReceivers((ItemStack)stack)[0].getMagazine((ItemStack)stack).getAmount((ItemStack)stack, ctx.inventory) > 0;
    public static BiFunction<ItemStack, ItemGunBaseNT.LambdaContext, Boolean> LAMBDA_LOCKON_CAN_FIRE = (stack, ctx) -> ctx.config.getReceivers((ItemStack)stack)[0].getMagazine((ItemStack)stack).getAmount((ItemStack)stack, ctx.inventory) > 0 && ItemGunBaseNT.getIsLockedOn(stack);
    public static BiFunction<ItemStack, ItemGunBaseNT.LambdaContext, Boolean> LAMBDA_DEBUG_CAN_FIRE = (stack, ctx) -> true;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STANDARD_FIRE = (stack, ctx) -> Lego.doStandardFire(stack, ctx, HbmAnimations.AnimType.CYCLE, true);
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_NOWEAR_FIRE = (stack, ctx) -> Lego.doStandardFire(stack, ctx, HbmAnimations.AnimType.CYCLE, false);
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_LOCKON_FIRE = (stack, ctx) -> {
        Lego.doStandardFire(stack, ctx, HbmAnimations.AnimType.CYCLE, true);
        ItemGunBaseNT.setIsLockedOn(stack, false);
    };
    public static BiFunction<ItemStack, HbmAnimations.AnimType, BusAnimation> LAMBDA_DEBUG_ANIMS = (stack, type) -> {
        switch (type) {
            case CYCLE: {
                return new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 50).addPos(0.0, 0.0, -3.0, 50).addPos(0.0, 0.0, 0.0, 250)).addBus("HAMMER", new BusAnimationSequence().addPos(0.0, 0.0, 1.0, 50).addPos(0.0, 0.0, 1.0, 400).addPos(0.0, 0.0, 0.0, 200)).addBus("DRUM", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 450).addPos(0.0, 0.0, 1.0, 200));
            }
            case CYCLE_DRY: {
                return new BusAnimation().addBus("HAMMER", new BusAnimationSequence().addPos(0.0, 0.0, 1.0, 50).addPos(0.0, 0.0, 1.0, 400).addPos(0.0, 0.0, 0.0, 200)).addBus("DRUM", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 450).addPos(0.0, 0.0, 1.0, 200));
            }
            case EQUIP: {
                return new BusAnimation().addBus("ROTATE", new BusAnimationSequence().addPos(-360.0, 0.0, 0.0, 350));
            }
            case RELOAD: {
                return new BusAnimation().addBus("RELAOD_TILT", new BusAnimationSequence().addPos(-15.0, 0.0, 0.0, 100).addPos(65.0, 0.0, 0.0, 100).addPos(45.0, 0.0, 0.0, 50).addPos(0.0, 0.0, 0.0, 200).addPos(0.0, 0.0, 0.0, 1450).addPos(-80.0, 0.0, 0.0, 100).addPos(-80.0, 0.0, 0.0, 100).addPos(0.0, 0.0, 0.0, 200)).addBus("RELOAD_CYLINDER", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 200).addPos(90.0, 0.0, 0.0, 100).addPos(90.0, 0.0, 0.0, 1700).addPos(0.0, 0.0, 0.0, 70)).addBus("RELOAD_LIFT", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 350).addPos(-45.0, 0.0, 0.0, 250).addPos(-45.0, 0.0, 0.0, 350).addPos(-15.0, 0.0, 0.0, 200).addPos(-15.0, 0.0, 0.0, 1050).addPos(0.0, 0.0, 0.0, 100)).addBus("RELOAD_JOLT", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 600).addPos(2.0, 0.0, 0.0, 50).addPos(0.0, 0.0, 0.0, 100)).addBus("RELOAD_BULLETS", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 650).addPos(10.0, 0.0, 0.0, 300).addPos(10.0, 0.0, 0.0, 200).addPos(0.0, 0.0, 0.0, 700)).addBus("RELOAD_BULLETS_CON", new BusAnimationSequence().addPos(1.0, 0.0, 0.0, 0).addPos(1.0, 0.0, 0.0, 950).addPos(0.0, 0.0, 0.0, 1));
            }
            case INSPECT: 
            case JAMMED: {
                return new BusAnimation().addBus("RELAOD_TILT", new BusAnimationSequence().addPos(-15.0, 0.0, 0.0, 100).addPos(65.0, 0.0, 0.0, 100).addPos(45.0, 0.0, 0.0, 50).addPos(0.0, 0.0, 0.0, 200).addPos(0.0, 0.0, 0.0, 200).addPos(-80.0, 0.0, 0.0, 100).addPos(-80.0, 0.0, 0.0, 100).addPos(0.0, 0.0, 0.0, 200)).addBus("RELOAD_CYLINDER", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 200).addPos(90.0, 0.0, 0.0, 100).addPos(90.0, 0.0, 0.0, 450).addPos(0.0, 0.0, 0.0, 70));
            }
        }
        return null;
    };

    public static void clickReceiver(ItemStack stack, ItemGunBaseNT.LambdaContext ctx, int receiver) {
        EntityLivingBase entity = ctx.entity;
        EntityPlayer player = ctx.getPlayer();
        Receiver rec = ctx.config.getReceivers(stack)[receiver];
        int index = ctx.configIndex;
        ItemGunBaseNT.GunState state = ItemGunBaseNT.getState(stack, index);
        if (state == ItemGunBaseNT.GunState.IDLE) {
            if (rec.getCanFire(stack).apply(stack, ctx).booleanValue()) {
                rec.getOnFire(stack).accept(stack, ctx);
                if (rec.getFireSound(stack) != null) {
                    entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, rec.getFireSound(stack), rec.getFireVolume(stack), rec.getFirePitch(stack));
                }
                int remaining = rec.getRoundsPerCycle(stack) - 1;
                for (int i = 0; i < remaining; ++i) {
                    if (!rec.getCanFire(stack).apply(stack, ctx).booleanValue()) continue;
                    rec.getOnFire(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setState(stack, index, ItemGunBaseNT.GunState.COOLDOWN);
                ItemGunBaseNT.setTimer(stack, index, rec.getDelayAfterFire(stack));
            } else if (rec.getDoesDryFire(stack)) {
                ItemGunBaseNT.playAnimation(player, stack, HbmAnimations.AnimType.CYCLE_DRY, index);
                ItemGunBaseNT.setState(stack, index, rec.getRefireAfterDry(stack) ? ItemGunBaseNT.GunState.COOLDOWN : ItemGunBaseNT.GunState.DRAWING);
                ItemGunBaseNT.setTimer(stack, index, rec.getDelayAfterDryFire(stack));
            }
        }
        if (state == ItemGunBaseNT.GunState.RELOADING) {
            ItemGunBaseNT.setReloadCancel(stack, true);
        }
    }

    public static void handleStandardSmoke(EntityLivingBase entity, ItemStack stack, int smokeDuration, double alphaDecay, double widthGrowth, int index) {
        boolean smoking;
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        long lastShot = gun.lastShot[index];
        List<ItemGunBaseNT.SmokeNode> smokeNodes = gun.getConfig((ItemStack)stack, (int)index).smokeNodes;
        boolean bl = smoking = lastShot + (long)smokeDuration > System.currentTimeMillis();
        if (!smoking && !smokeNodes.isEmpty()) {
            smokeNodes.clear();
        }
        if (smoking) {
            Vec3 prev = Vec3.func_72443_a((double)(-entity.field_70159_w), (double)(-entity.field_70181_x), (double)(-entity.field_70179_y));
            prev.func_72442_b((float)((double)entity.field_70177_z * Math.PI / 180.0));
            double accel = 15.0;
            double side = (double)(entity.field_70177_z - entity.field_70758_at) * 0.1;
            double waggle = 0.025;
            for (ItemGunBaseNT.SmokeNode node : smokeNodes) {
                node.forward += -prev.field_72449_c * accel + entity.field_70170_p.field_73012_v.nextGaussian() * waggle;
                node.lift += prev.field_72448_b + 1.5;
                node.side += prev.field_72450_a * accel + entity.field_70170_p.field_73012_v.nextGaussian() * waggle + side;
                if (node.alpha > 0.0) {
                    node.alpha -= alphaDecay;
                }
                node.width *= widthGrowth;
            }
            double alpha = (double)(System.currentTimeMillis() - lastShot) / (double)smokeDuration;
            alpha = (1.0 - alpha) * 0.5;
            if (ItemGunBaseNT.getState(stack, index) == ItemGunBaseNT.GunState.RELOADING || smokeNodes.size() == 0) {
                alpha = 0.0;
            }
            smokeNodes.add(new ItemGunBaseNT.SmokeNode(alpha));
        }
    }

    public static void doStandardFire(ItemStack stack, ItemGunBaseNT.LambdaContext ctx, HbmAnimations.AnimType anim, boolean calcWear) {
        EntityLivingBase entity = ctx.entity;
        EntityPlayer player = ctx.getPlayer();
        int index = ctx.configIndex;
        if (anim != null) {
            ItemGunBaseNT.playAnimation(player, stack, anim, ctx.configIndex);
        }
        boolean aim = ItemGunBaseNT.getIsAiming(stack);
        Receiver primary = ctx.config.getReceivers(stack)[0];
        IMagazine mag = primary.getMagazine(stack);
        BulletConfig config = (BulletConfig)mag.getType(stack, ctx.inventory);
        Vec3 offset = ItemGunBaseNT.getIsAiming(stack) ? primary.getProjectileOffsetScoped(stack) : primary.getProjectileOffset(stack);
        double forwardOffset = offset.field_72450_a;
        double heightOffset = offset.field_72448_b;
        double sideOffset = offset.field_72449_c;
        int projectiles = config.projectilesMin;
        if (config.projectilesMax > config.projectilesMin) {
            projectiles += entity.func_70681_au().nextInt(config.projectilesMax - config.projectilesMin + 1);
        }
        projectiles = (int)((float)projectiles * primary.getSplitProjectiles(stack));
        for (int i = 0; i < projectiles; ++i) {
            Entity mk4;
            float damage = Lego.calcDamage(ctx, stack, primary, calcWear, index);
            float spread = Lego.calcSpread(ctx, stack, primary, config, calcWear, index, aim);
            if (config.pType == BulletConfig.ProjectileType.BULLET) {
                mk4 = new EntityBulletBaseMK4(entity, config, damage, spread, sideOffset, heightOffset, forwardOffset);
                if (ItemGunBaseNT.getIsLockedOn(stack)) {
                    mk4.lockonTarget = entity.field_70170_p.func_73045_a(ItemGunBaseNT.getLockonTarget(stack));
                }
                if (i == 0 && config.blackPowder) {
                    BlackPowderCreator.composeEffect(entity.field_70170_p, mk4.field_70165_t, mk4.field_70163_u, mk4.field_70161_v, mk4.field_70159_w, mk4.field_70181_x, mk4.field_70179_y, 10, 0.25f, 0.5f, 10, 0.25f);
                }
                entity.field_70170_p.func_72838_d(mk4);
                continue;
            }
            if (config.pType == BulletConfig.ProjectileType.BULLET_CHUNKLOADING) {
                mk4 = new EntityBulletBaseMK4CL(entity, config, damage, spread, sideOffset, heightOffset, forwardOffset);
                if (ItemGunBaseNT.getIsLockedOn(stack)) {
                    ((EntityBulletBaseMK4CL)mk4).lockonTarget = entity.field_70170_p.func_73045_a(ItemGunBaseNT.getLockonTarget(stack));
                }
                if (i == 0 && config.blackPowder) {
                    BlackPowderCreator.composeEffect(entity.field_70170_p, ((EntityBulletBaseMK4CL)mk4).field_70165_t, ((EntityBulletBaseMK4CL)mk4).field_70163_u, ((EntityBulletBaseMK4CL)mk4).field_70161_v, ((EntityBulletBaseMK4CL)mk4).field_70159_w, ((EntityBulletBaseMK4CL)mk4).field_70181_x, ((EntityBulletBaseMK4CL)mk4).field_70179_y, 10, 0.25f, 0.5f, 10, 0.25f);
                }
                entity.field_70170_p.func_72838_d(mk4);
                continue;
            }
            if (config.pType != BulletConfig.ProjectileType.BEAM) continue;
            mk4 = new EntityBulletBeamBase(entity, config, damage, spread, sideOffset, heightOffset, forwardOffset);
            entity.field_70170_p.func_72838_d(mk4);
        }
        if (player != null) {
            player.func_71064_a(MainRegistry.statBullets, 1);
        }
        mag.useUpAmmo(stack, ctx.inventory, 1);
        if (calcWear) {
            ItemGunBaseNT.setWear(stack, index, Math.min(ItemGunBaseNT.getWear(stack, index) + config.wear, ctx.config.getDurability(stack)));
        }
    }

    public static float getStandardWearSpread(ItemStack stack, GunConfig config, int index) {
        float percent = ItemGunBaseNT.getWear(stack, index) / config.getDurability(stack);
        if (percent < 0.5f) {
            return 0.0f;
        }
        return (percent - 0.5f) * 2.0f;
    }

    public static float getStandardWearDamage(ItemStack stack, GunConfig config, int index) {
        float percent = ItemGunBaseNT.getWear(stack, index) / config.getDurability(stack);
        if (percent < 0.75f) {
            return 1.0f;
        }
        return 1.0f - (percent - 0.75f) * 2.0f;
    }

    public static float calcDamage(ItemGunBaseNT.LambdaContext ctx, ItemStack stack, Receiver primary, boolean calcWear, int index) {
        return primary.getBaseDamage(stack) * (calcWear ? Lego.getStandardWearDamage(stack, ctx.config, index) : 1.0f);
    }

    public static float calcSpread(ItemGunBaseNT.LambdaContext ctx, ItemStack stack, Receiver primary, BulletConfig config, boolean calcWear, int index, boolean aim) {
        float spreadInnate = primary.getInnateSpread(stack);
        float spreadAmmo = config.spread * primary.getAmmoSpread(stack);
        float spreadHipfire = aim ? 0.0f : primary.getHipfireSpread(stack);
        float spreadWear = !calcWear ? 0.0f : Lego.getStandardWearSpread(stack, ctx.config, index) * primary.getDurabilitySpread(stack);
        return spreadInnate + spreadAmmo + spreadHipfire + spreadWear;
    }

    public static void standardExplode(EntityBulletBaseMK4 bullet, MovingObjectPosition mop, float range) {
        Lego.standardExplode(bullet, mop, range, 1.0f);
    }

    public static void standardExplode(EntityBulletBaseMK4 bullet, MovingObjectPosition mop, float range, float damageMod) {
        ExplosionVNT vnt = new ExplosionVNT(bullet.field_70170_p, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, range, (Entity)bullet.getThrower());
        vnt.setEntityProcessor(new EntityProcessorCrossSmooth(1.0, bullet.damage * damageMod).setupPiercing(bullet.config.armorThresholdNegation, bullet.config.armorPiercingPercent));
        vnt.setPlayerProcessor(new PlayerProcessorStandard());
        vnt.setSFX(new ExplosionEffectWeapon(10, 2.5f, 1.0f));
        vnt.explode();
    }

    public static void tinyExplode(EntityBulletBaseMK4 bullet, MovingObjectPosition mop, float range) {
        Lego.tinyExplode(bullet, mop, range, 1.0f);
    }

    public static void tinyExplode(EntityBulletBaseMK4 bullet, MovingObjectPosition mop, float range, float damageMod) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
        double x = mop.field_72307_f.field_72450_a + (double)dir.offsetX * 0.25;
        double y = mop.field_72307_f.field_72448_b + (double)dir.offsetY * 0.25;
        double z = mop.field_72307_f.field_72449_c + (double)dir.offsetZ * 0.25;
        ExplosionVNT vnt = new ExplosionVNT(bullet.field_70170_p, x, y, z, range, (Entity)bullet.getThrower());
        vnt.setEntityProcessor(new EntityProcessorCrossSmooth(1.0, bullet.damage * damageMod).setupPiercing(bullet.config.armorThresholdNegation, bullet.config.armorPiercingPercent).setKnockback(0.25));
        vnt.setPlayerProcessor(new PlayerProcessorStandard());
        vnt.setSFX(new ExplosionEffectTiny());
        vnt.explode();
    }
}

