/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.mods;

import com.google.common.collect.HashBiMap;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.items.weapon.sedna.factory.XFactory22lr;
import com.hbm.items.weapon.sedna.factory.XFactory357;
import com.hbm.items.weapon.sedna.factory.XFactory44;
import com.hbm.items.weapon.sedna.factory.XFactory45;
import com.hbm.items.weapon.sedna.factory.XFactory50;
import com.hbm.items.weapon.sedna.factory.XFactory556mm;
import com.hbm.items.weapon.sedna.factory.XFactory762mm;
import com.hbm.items.weapon.sedna.factory.XFactory9mm;
import com.hbm.items.weapon.sedna.mods.IWeaponMod;
import com.hbm.items.weapon.sedna.mods.WeapnModG3SawedOff;
import com.hbm.items.weapon.sedna.mods.WeaponModCaliber;
import com.hbm.items.weapon.sedna.mods.WeaponModCarbineBayonet;
import com.hbm.items.weapon.sedna.mods.WeaponModChoke;
import com.hbm.items.weapon.sedna.mods.WeaponModGenericDamage;
import com.hbm.items.weapon.sedna.mods.WeaponModGenericDurability;
import com.hbm.items.weapon.sedna.mods.WeaponModGreasegun;
import com.hbm.items.weapon.sedna.mods.WeaponModLasAuto;
import com.hbm.items.weapon.sedna.mods.WeaponModLasCapacitor;
import com.hbm.items.weapon.sedna.mods.WeaponModLasShotgun;
import com.hbm.items.weapon.sedna.mods.WeaponModLiberatorSpeedloader;
import com.hbm.items.weapon.sedna.mods.WeaponModMASBayonet;
import com.hbm.items.weapon.sedna.mods.WeaponModMinigunSpeedup;
import com.hbm.items.weapon.sedna.mods.WeaponModOverride;
import com.hbm.items.weapon.sedna.mods.WeaponModPanzerschreckSawedOff;
import com.hbm.items.weapon.sedna.mods.WeaponModPolymerFurniture;
import com.hbm.items.weapon.sedna.mods.WeaponModSawedOff;
import com.hbm.items.weapon.sedna.mods.WeaponModScope;
import com.hbm.items.weapon.sedna.mods.WeaponModShredderSpeedup;
import com.hbm.items.weapon.sedna.mods.WeaponModSilencer;
import com.hbm.items.weapon.sedna.mods.WeaponModSlowdown;
import com.hbm.items.weapon.sedna.mods.WeaponModStackMag;
import com.hbm.items.weapon.sedna.mods.WeaponModTestDamage;
import com.hbm.items.weapon.sedna.mods.WeaponModTestFirerate;
import com.hbm.items.weapon.sedna.mods.WeaponModTestMulti;
import com.hbm.items.weapon.sedna.mods.WeaponModUziSaturnite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WeaponModManager {
    public static final String KEY_MOD_LIST = "KEY_MOD_LIST_";
    public static HashBiMap<Integer, IWeaponMod> idToMod = HashBiMap.create();
    public static HashMap<RecipesCommon.ComparableStack, WeaponModDefinition> stackToMod = new HashMap();
    public static HashMap<IWeaponMod, ItemStack> modToStack = new HashMap();
    public static final int ID_SILENCER = 201;
    public static final int ID_SCOPE = 202;
    public static final int ID_SAWED_OFF = 203;
    public static final int ID_NO_SHIELD = 204;
    public static final int ID_NO_STOCK = 205;
    public static final int ID_GREASEGUN_CLEAN = 206;
    public static final int ID_MINIGUN_SPEED = 208;
    public static final int ID_FURNITURE_GREEN = 211;
    public static final int ID_FURNITURE_BLACK = 212;
    public static final int ID_MAS_BAYONET = 213;
    public static final int ID_UZI_SATURN = 215;
    public static final int ID_LAS_SHOTGUN = 216;
    public static final int ID_LAS_CAPACITOR = 217;
    public static final int ID_LAS_AUTO = 218;
    public static final int ID_CARBINE_BAYONET = 219;
    public static Comparator<IWeaponMod> modSorter = new Comparator<IWeaponMod>(){

        @Override
        public int compare(IWeaponMod o1, IWeaponMod o2) {
            return o2.getModPriority() - o1.getModPriority();
        }
    };

    public static void init() {
        WeaponModTestFirerate TEST_FIRERATE = new WeaponModTestFirerate(0, "FIRERATE");
        WeaponModTestDamage TEST_DAMAGE = new WeaponModTestDamage(1, "DAMAGE");
        WeaponModTestMulti TEST_MULTI = new WeaponModTestMulti(2, "MULTI");
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.FIRERATE.ordinal())).addDefault(TEST_FIRERATE);
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.DAMAGE.ordinal())).addDefault(TEST_DAMAGE);
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.MULTI.ordinal())).addDefault(TEST_MULTI);
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.OVERRIDE_2_5.ordinal())).addDefault(new WeaponModOverride(3, 2.5f, "OVERRIDE"));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.OVERRIDE_5.ordinal())).addDefault(new WeaponModOverride(4, 5.0f, "OVERRIDE"));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.OVERRIDE_7_5.ordinal())).addDefault(new WeaponModOverride(5, 7.5f, "OVERRIDE"));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.OVERRIDE_10.ordinal())).addDefault(new WeaponModOverride(6, 10.0f, "OVERRIDE"));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.OVERRIDE_12_5.ordinal())).addDefault(new WeaponModOverride(7, 125.0f, "OVERRIDE"));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.OVERRIDE_15.ordinal())).addDefault(new WeaponModOverride(8, 15.0f, "OVERRIDE"));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_test, 1, GunFactory.EnumModTest.OVERRIDE_20.ordinal())).addDefault(new WeaponModOverride(9, 20.0f, "OVERRIDE"));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_generic, 1, GunFactory.EnumModGeneric.IRON_DAMAGE.ordinal())).addMod(ModItems.gun_pepperbox, (IWeaponMod)new WeaponModGenericDamage(100));
        new WeaponModDefinition(new ItemStack(ModItems.weapon_mod_generic, 1, GunFactory.EnumModGeneric.IRON_DURA.ordinal())).addMod(ModItems.gun_pepperbox, (IWeaponMod)new WeaponModGenericDurability(101));
        Item[] steelGuns = new Item[]{ModItems.gun_light_revolver, ModItems.gun_light_revolver_atlas, ModItems.gun_henry, ModItems.gun_henry_lincoln, ModItems.gun_greasegun, ModItems.gun_maresleg, ModItems.gun_maresleg_akimbo, ModItems.gun_flaregun};
        Item[] duraGuns = new Item[]{ModItems.gun_am180, ModItems.gun_liberator, ModItems.gun_congolake, ModItems.gun_flamer, ModItems.gun_flamer_topaz};
        Item[] deshGuns = new Item[]{ModItems.gun_heavy_revolver, ModItems.gun_carbine, ModItems.gun_uzi, ModItems.gun_uzi_akimbo, ModItems.gun_spas12, ModItems.gun_panzerschreck};
        Item[] wsteelGuns = new Item[]{ModItems.gun_g3, ModItems.gun_g3_zebra, ModItems.gun_stinger, ModItems.gun_chemthrower};
        Item[] ferroGuns = new Item[]{ModItems.gun_amat, ModItems.gun_m2, ModItems.gun_autoshotgun, ModItems.gun_autoshotgun_shredder, ModItems.gun_quadro};
        Item[] tcalloyGuns = new Item[]{ModItems.gun_lag, ModItems.gun_minigun, ModItems.gun_missile_launcher, ModItems.gun_tesla_cannon};
        Item[] bigmtGuns = new Item[]{ModItems.gun_laser_pistol, ModItems.gun_laser_pistol_pew_pew, ModItems.gun_stg77, ModItems.gun_fatman, ModItems.gun_tau};
        Item[] bronzeGuns = new Item[]{ModItems.gun_lasrifle};
        new WeaponModDefinition(GunFactory.EnumModGeneric.STEEL_DAMAGE).addMod(steelGuns, (IWeaponMod)new WeaponModGenericDamage(102));
        new WeaponModDefinition(GunFactory.EnumModGeneric.STEEL_DURA).addMod(steelGuns, (IWeaponMod)new WeaponModGenericDurability(103));
        new WeaponModDefinition(GunFactory.EnumModGeneric.DURA_DAMAGE).addMod(duraGuns, (IWeaponMod)new WeaponModGenericDamage(104));
        new WeaponModDefinition(GunFactory.EnumModGeneric.DURA_DURA).addMod(duraGuns, (IWeaponMod)new WeaponModGenericDurability(105));
        new WeaponModDefinition(GunFactory.EnumModGeneric.DESH_DAMAGE).addMod(deshGuns, (IWeaponMod)new WeaponModGenericDamage(106));
        new WeaponModDefinition(GunFactory.EnumModGeneric.DESH_DURA).addMod(deshGuns, (IWeaponMod)new WeaponModGenericDurability(107));
        new WeaponModDefinition(GunFactory.EnumModGeneric.WSTEEL_DAMAGE).addMod(wsteelGuns, (IWeaponMod)new WeaponModGenericDamage(108));
        new WeaponModDefinition(GunFactory.EnumModGeneric.WSTEEL_DURA).addMod(wsteelGuns, (IWeaponMod)new WeaponModGenericDurability(109));
        new WeaponModDefinition(GunFactory.EnumModGeneric.FERRO_DAMAGE).addMod(ferroGuns, (IWeaponMod)new WeaponModGenericDamage(110));
        new WeaponModDefinition(GunFactory.EnumModGeneric.FERRO_DURA).addMod(ferroGuns, (IWeaponMod)new WeaponModGenericDurability(111));
        new WeaponModDefinition(GunFactory.EnumModGeneric.TCALLOY_DAMAGE).addMod(tcalloyGuns, (IWeaponMod)new WeaponModGenericDamage(112));
        new WeaponModDefinition(GunFactory.EnumModGeneric.TCALLOY_DURA).addMod(tcalloyGuns, (IWeaponMod)new WeaponModGenericDurability(113));
        new WeaponModDefinition(GunFactory.EnumModGeneric.BIGMT_DAMAGE).addMod(bigmtGuns, (IWeaponMod)new WeaponModGenericDamage(114));
        new WeaponModDefinition(GunFactory.EnumModGeneric.BIGMT_DURA).addMod(bigmtGuns, (IWeaponMod)new WeaponModGenericDurability(115));
        new WeaponModDefinition(GunFactory.EnumModGeneric.BRONZE_DAMAGE).addMod(bronzeGuns, (IWeaponMod)new WeaponModGenericDamage(116));
        new WeaponModDefinition(GunFactory.EnumModGeneric.BRONZE_DURA).addMod(bronzeGuns, (IWeaponMod)new WeaponModGenericDurability(117));
        new WeaponModDefinition(GunFactory.EnumModSpecial.SPEEDLOADER).addMod(ModItems.gun_liberator, (IWeaponMod)new WeaponModLiberatorSpeedloader(200));
        new WeaponModDefinition(GunFactory.EnumModSpecial.SILENCER).addMod(new Item[]{ModItems.gun_am180, ModItems.gun_uzi, ModItems.gun_uzi_akimbo, ModItems.gun_g3, ModItems.gun_amat}, (IWeaponMod)new WeaponModSilencer(201));
        new WeaponModDefinition(GunFactory.EnumModSpecial.SCOPE).addMod(new Item[]{ModItems.gun_heavy_revolver, ModItems.gun_g3, ModItems.gun_mas36, ModItems.gun_charge_thrower}, (IWeaponMod)new WeaponModScope(202));
        new WeaponModDefinition(GunFactory.EnumModSpecial.SAW).addMod(new Item[]{ModItems.gun_maresleg, ModItems.gun_double_barrel}, (IWeaponMod)new WeaponModSawedOff(203)).addMod(ModItems.gun_panzerschreck, (IWeaponMod)new WeaponModPanzerschreckSawedOff(204)).addMod(new Item[]{ModItems.gun_g3, ModItems.gun_g3_zebra}, (IWeaponMod)new WeapnModG3SawedOff(205));
        new WeaponModDefinition(GunFactory.EnumModSpecial.GREASEGUN).addMod(ModItems.gun_greasegun, (IWeaponMod)new WeaponModGreasegun(206));
        new WeaponModDefinition(GunFactory.EnumModSpecial.SLOWDOWN).addMod(new Item[]{ModItems.gun_minigun, ModItems.gun_minigun_dual}, (IWeaponMod)new WeaponModSlowdown(207));
        new WeaponModDefinition(GunFactory.EnumModSpecial.SPEEDUP).addMod(new Item[]{ModItems.gun_minigun, ModItems.gun_minigun_dual}, (IWeaponMod)new WeaponModMinigunSpeedup(208)).addMod(new Item[]{ModItems.gun_autoshotgun, ModItems.gun_autoshotgun_shredder}, (IWeaponMod)new WeaponModShredderSpeedup(209));
        new WeaponModDefinition(GunFactory.EnumModSpecial.CHOKE).addMod(new Item[]{ModItems.gun_pepperbox, ModItems.gun_maresleg, ModItems.gun_double_barrel, ModItems.gun_liberator, ModItems.gun_spas12, ModItems.gun_autoshotgun_sexy, ModItems.gun_autoshotgun_heretic}, (IWeaponMod)new WeaponModChoke(210));
        new WeaponModDefinition(GunFactory.EnumModSpecial.FURNITURE_GREEN).addMod(ModItems.gun_g3, (IWeaponMod)new WeaponModPolymerFurniture(211));
        new WeaponModDefinition(GunFactory.EnumModSpecial.FURNITURE_BLACK).addMod(ModItems.gun_g3, (IWeaponMod)new WeaponModPolymerFurniture(212));
        new WeaponModDefinition(GunFactory.EnumModSpecial.BAYONET).addMod(ModItems.gun_mas36, (IWeaponMod)new WeaponModMASBayonet(213)).addMod(ModItems.gun_carbine, (IWeaponMod)new WeaponModCarbineBayonet(219));
        new WeaponModDefinition(GunFactory.EnumModSpecial.STACK_MAG).addMod(new Item[]{ModItems.gun_greasegun, ModItems.gun_uzi, ModItems.gun_uzi_akimbo, ModItems.gun_aberrator, ModItems.gun_aberrator_eott}, (IWeaponMod)new WeaponModStackMag(214));
        new WeaponModDefinition(GunFactory.EnumModSpecial.SKIN_SATURNITE).addMod(new Item[]{ModItems.gun_uzi, ModItems.gun_uzi_akimbo}, (IWeaponMod)new WeaponModUziSaturnite(215));
        new WeaponModDefinition(GunFactory.EnumModSpecial.LAS_SHOTGUN).addMod(new Item[]{ModItems.gun_lasrifle}, (IWeaponMod)new WeaponModLasShotgun(216));
        new WeaponModDefinition(GunFactory.EnumModSpecial.LAS_CAPACITOR).addMod(new Item[]{ModItems.gun_lasrifle}, (IWeaponMod)new WeaponModLasCapacitor(217));
        new WeaponModDefinition(GunFactory.EnumModSpecial.LAS_AUTO).addMod(new Item[]{ModItems.gun_lasrifle}, (IWeaponMod)new WeaponModLasAuto(218));
        BulletConfig[] p9 = new BulletConfig[]{XFactory9mm.p9_sp, XFactory9mm.p9_fmj, XFactory9mm.p9_jhp, XFactory9mm.p9_ap};
        BulletConfig[] p45 = new BulletConfig[]{XFactory45.p45_sp, XFactory45.p45_fmj, XFactory45.p45_jhp, XFactory45.p45_ap, XFactory45.p45_du};
        BulletConfig[] p22 = new BulletConfig[]{XFactory22lr.p22_sp, XFactory22lr.p22_fmj, XFactory22lr.p22_jhp, XFactory22lr.p22_ap};
        BulletConfig[] m357 = new BulletConfig[]{XFactory357.m357_sp, XFactory357.m357_fmj, XFactory357.m357_jhp, XFactory357.m357_ap, XFactory357.m357_express};
        BulletConfig[] m44 = new BulletConfig[]{XFactory44.m44_sp, XFactory44.m44_fmj, XFactory44.m44_jhp, XFactory44.m44_ap, XFactory44.m44_express};
        BulletConfig[] r556 = new BulletConfig[]{XFactory556mm.r556_sp, XFactory556mm.r556_fmj, XFactory556mm.r556_jhp, XFactory556mm.r556_ap};
        BulletConfig[] r762 = new BulletConfig[]{XFactory762mm.r762_sp, XFactory762mm.r762_fmj, XFactory762mm.r762_jhp, XFactory762mm.r762_ap, XFactory762mm.r762_du, XFactory762mm.r762_he};
        BulletConfig[] bmg50 = new BulletConfig[]{XFactory50.bmg50_sp, XFactory50.bmg50_fmj, XFactory50.bmg50_jhp, XFactory50.bmg50_ap, XFactory50.bmg50_du, XFactory50.bmg50_he};
        new WeaponModDefinition(GunFactory.EnumModCaliber.P9).addMod(ModItems.gun_henry, (IWeaponMod)new WeaponModCaliber(300, 28, 10.0f, p9));
        new WeaponModDefinition(GunFactory.EnumModCaliber.P45).addMod(ModItems.gun_henry, (IWeaponMod)new WeaponModCaliber(310, 28, 10.0f, p45)).addMod(ModItems.gun_greasegun, (IWeaponMod)new WeaponModCaliber(311, 24, 3.0f, p45)).addMod(ModItems.gun_uzi, (IWeaponMod)new WeaponModCaliber(312, 24, 3.0f, p45)).addMod(ModItems.gun_uzi_akimbo, (IWeaponMod)new WeaponModCaliber(313, 24, 3.0f, p45)).addMod(ModItems.gun_lag, (IWeaponMod)new WeaponModCaliber(314, 15, 25.0f, p45));
        new WeaponModDefinition(GunFactory.EnumModCaliber.P22).addMod(ModItems.gun_henry, (IWeaponMod)new WeaponModCaliber(320, 28, 10.0f, p22)).addMod(ModItems.gun_uzi, (IWeaponMod)new WeaponModCaliber(321, 40, 3.0f, p22)).addMod(ModItems.gun_uzi_akimbo, (IWeaponMod)new WeaponModCaliber(322, 40, 3.0f, p22));
        new WeaponModDefinition(GunFactory.EnumModCaliber.M357).addMod(ModItems.gun_henry, (IWeaponMod)new WeaponModCaliber(330, 20, 10.0f, m357)).addMod(ModItems.gun_lag, (IWeaponMod)new WeaponModCaliber(331, 15, 25.0f, m357));
        new WeaponModDefinition(GunFactory.EnumModCaliber.M44).addMod(ModItems.gun_lag, (IWeaponMod)new WeaponModCaliber(340, 13, 25.0f, m44));
        new WeaponModDefinition(GunFactory.EnumModCaliber.R556).addMod(ModItems.gun_henry, (IWeaponMod)new WeaponModCaliber(350, 10, 10.0f, r556)).addMod(ModItems.gun_carbine, (IWeaponMod)new WeaponModCaliber(351, 20, 15.0f, r556)).addMod(new Item[]{ModItems.gun_minigun, ModItems.gun_minigun_dual}, (IWeaponMod)new WeaponModCaliber(352, 0, 6.0f, r556));
        new WeaponModDefinition(GunFactory.EnumModCaliber.R762).addMod(ModItems.gun_henry, (IWeaponMod)new WeaponModCaliber(360, 8, 10.0f, r762)).addMod(ModItems.gun_g3, (IWeaponMod)new WeaponModCaliber(361, 24, 5.0f, r762));
        new WeaponModDefinition(GunFactory.EnumModCaliber.BMG50).addMod(ModItems.gun_henry, (IWeaponMod)new WeaponModCaliber(370, 5, 10.0f, bmg50)).addMod(new Item[]{ModItems.gun_minigun, ModItems.gun_minigun_dual}, (IWeaponMod)new WeaponModCaliber(371, 0, 6.0f, bmg50));
    }

    public static ItemStack[] getUpgradeItems(ItemStack stack, int cfg) {
        if (!stack.func_77942_o()) {
            return new ItemStack[0];
        }
        int[] modIds = stack.field_77990_d.func_74759_k(KEY_MOD_LIST + cfg);
        if (modIds.length == 0) {
            return new ItemStack[0];
        }
        ItemStack[] mods = new ItemStack[modIds.length];
        for (int i = 0; i < mods.length; ++i) {
            IWeaponMod mod = (IWeaponMod)idToMod.get((Object)modIds[i]);
            if (mod == null) continue;
            ItemStack itemStack = mods[i] = mod != null ? modToStack.get(mod) : null;
            if (mods[i] == null) continue;
            mods[i] = mods[i].func_77946_l();
        }
        return mods;
    }

    public static boolean hasUpgrade(ItemStack stack, int cfg, int id) {
        if (!stack.func_77942_o()) {
            return false;
        }
        int[] modIds = stack.field_77990_d.func_74759_k(KEY_MOD_LIST + cfg);
        for (int i = 0; i < modIds.length; ++i) {
            if (modIds[i] != id) continue;
            return true;
        }
        return false;
    }

    public static void install(ItemStack stack, int cfg, ItemStack ... mods) {
        ArrayList<IWeaponMod> toInstall = new ArrayList<IWeaponMod>();
        RecipesCommon.ComparableStack gun = new RecipesCommon.ComparableStack(stack);
        for (ItemStack mod : mods) {
            RecipesCommon.ComparableStack comp;
            WeaponModDefinition def;
            if (mod == null || (def = stackToMod.get(comp = new RecipesCommon.ComparableStack(mod))) == null) continue;
            IWeaponMod forGun = def.modByGun.get(gun);
            if (forGun != null) {
                toInstall.add(forGun);
                continue;
            }
            forGun = def.modByGun.get(null);
            if (forGun == null) continue;
            toInstall.add(forGun);
        }
        if (toInstall.isEmpty()) {
            return;
        }
        toInstall.sort(modSorter);
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        int[] modIds = new int[toInstall.size()];
        for (int i = 0; i < modIds.length; ++i) {
            modIds[i] = (Integer)idToMod.inverse().get(toInstall.get(i));
        }
        stack.field_77990_d.func_74783_a(KEY_MOD_LIST + cfg, modIds);
    }

    public static void uninstall(ItemStack stack, int cfg) {
        if (stack.func_77942_o()) {
            stack.field_77990_d.func_82580_o(KEY_MOD_LIST + cfg);
        }
    }

    public static void onInstallStack(ItemStack gun, ItemStack mod, int cfg) {
        IWeaponMod newMod = WeaponModManager.modFromStack(gun, mod, cfg);
        if (newMod == null) {
            return;
        }
        newMod.onInstall(gun, mod, cfg);
    }

    public static void onUninstallStack(ItemStack gun, ItemStack mod, int cfg) {
        IWeaponMod newMod = WeaponModManager.modFromStack(gun, mod, cfg);
        if (newMod == null) {
            return;
        }
        newMod.onUninstall(gun, mod, cfg);
    }

    public static IWeaponMod modFromStack(ItemStack gun, ItemStack mod, int cfg) {
        if (gun == null || mod == null) {
            return null;
        }
        WeaponModDefinition def = stackToMod.get(new RecipesCommon.ComparableStack(mod));
        if (def == null) {
            return null;
        }
        IWeaponMod newMod = def.modByGun.get(new RecipesCommon.ComparableStack(gun).makeSingular());
        if (newMod == null) {
            newMod = def.modByGun.get(null);
        }
        return newMod;
    }

    public static boolean isApplicable(ItemStack gun, ItemStack mod, int cfg, boolean checkMutex) {
        IWeaponMod newMod = WeaponModManager.modFromStack(gun, mod, cfg);
        if (newMod == null) {
            return false;
        }
        if (checkMutex) {
            for (int i : gun.field_77990_d.func_74759_k(KEY_MOD_LIST + cfg)) {
                IWeaponMod iMod = (IWeaponMod)idToMod.get((Object)i);
                if (iMod == null) continue;
                for (String mutex0 : newMod.getSlots()) {
                    for (String mutex1 : iMod.getSlots()) {
                        if (!mutex0.equals(mutex1)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static <T> T eval(T base, ItemStack stack, String key, Object parent, int cfg) {
        if (stack == null) {
            return base;
        }
        if (!stack.func_77942_o()) {
            return base;
        }
        for (int i : stack.field_77990_d.func_74759_k(KEY_MOD_LIST + cfg)) {
            IWeaponMod mod = (IWeaponMod)idToMod.get((Object)i);
            if (mod == null) continue;
            base = mod.eval(base, stack, key, parent);
        }
        return base;
    }

    public static class WeaponModDefinition {
        public HashMap<RecipesCommon.ComparableStack, IWeaponMod> modByGun = new HashMap();
        public ItemStack stack;

        public WeaponModDefinition(ItemStack stack) {
            this.stack = stack;
            stackToMod.put(new RecipesCommon.ComparableStack(stack), this);
        }

        public WeaponModDefinition(GunFactory.EnumModGeneric num) {
            this(new ItemStack(ModItems.weapon_mod_generic, 1, num.ordinal()));
        }

        public WeaponModDefinition(GunFactory.EnumModSpecial num) {
            this(new ItemStack(ModItems.weapon_mod_special, 1, num.ordinal()));
        }

        public WeaponModDefinition(GunFactory.EnumModCaliber num) {
            this(new ItemStack(ModItems.weapon_mod_caliber, 1, num.ordinal()));
        }

        public WeaponModDefinition addMod(ItemStack gun, IWeaponMod mod) {
            return this.addMod(new RecipesCommon.ComparableStack(gun), mod);
        }

        public WeaponModDefinition addMod(Item gun, IWeaponMod mod) {
            return this.addMod(new RecipesCommon.ComparableStack(gun), mod);
        }

        public WeaponModDefinition addMod(Item[] gun, IWeaponMod mod) {
            for (Item item : gun) {
                this.addMod(new RecipesCommon.ComparableStack(item), mod);
            }
            return this;
        }

        public WeaponModDefinition addMod(RecipesCommon.ComparableStack gun, IWeaponMod mod) {
            this.modByGun.put(gun, mod);
            modToStack.put(mod, this.stack);
            if (gun != null) {
                ItemGunBaseNT nt = (ItemGunBaseNT)gun.item;
                RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(this.stack);
                if (!nt.recognizedMods.contains(comp)) {
                    nt.recognizedMods.add(comp);
                }
            }
            return this;
        }

        public WeaponModDefinition addDefault(IWeaponMod mod) {
            return this.addMod((RecipesCommon.ComparableStack)null, mod);
        }
    }
}

