/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyConnectorBlock;
import api.hbm.energymk2.IEnergyConnectorMK2;
import api.hbm.fluidmk2.IFluidConnectorBlockMK2;
import api.hbm.fluidmk2.IFluidConnectorMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.mob.EntityHunterChopper;
import com.hbm.entity.projectile.EntityChopperMine;
import com.hbm.interfaces.Spaghetti;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Spaghetti(value="this whole class")
public class Library {
    static Random rand = new Random();
    public static final ForgeDirection POS_X = ForgeDirection.EAST;
    public static final ForgeDirection NEG_X = ForgeDirection.WEST;
    public static final ForgeDirection POS_Y = ForgeDirection.UP;
    public static final ForgeDirection NEG_Y = ForgeDirection.DOWN;
    public static final ForgeDirection POS_Z = ForgeDirection.SOUTH;
    public static final ForgeDirection NEG_Z = ForgeDirection.NORTH;

    public static boolean checkForHeld(EntityPlayer player, Item item) {
        if (player.func_70694_bm() == null) {
            return false;
        }
        return player.func_70694_bm().func_77973_b() == item;
    }

    public static boolean canConnect(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        IEnergyConnectorMK2 con;
        IEnergyConnectorBlock con2;
        if (y > 255 || y < 0) {
            return false;
        }
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof IEnergyConnectorBlock && (con2 = (IEnergyConnectorBlock)b).canConnect(world, x, y, z, dir.getOpposite())) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IEnergyConnectorMK2 && (con = (IEnergyConnectorMK2)te).canConnect(dir.getOpposite());
    }

    public static boolean canConnectFluid(IBlockAccess world, int x, int y, int z, ForgeDirection dir, FluidType type) {
        IFluidConnectorMK2 con;
        IFluidConnectorBlockMK2 con2;
        if (y > 255 || y < 0) {
            return false;
        }
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof IFluidConnectorBlockMK2 && (con2 = (IFluidConnectorBlockMK2)b).canConnect(type, world, x, y, z, dir.getOpposite())) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IFluidConnectorMK2 && (con = (IFluidConnectorMK2)te).canConnect(type, dir.getOpposite());
    }

    public static EntityLivingBase getClosestEntityForChopper(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityLivingBase entityplayer = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            EntityLivingBase entityplayer1;
            if (!(world.field_72996_f.get(i) instanceof EntityLivingBase) || world.field_72996_f.get(i) instanceof EntityHunterChopper || !(entityplayer1 = (EntityLivingBase)world.field_72996_f.get(i)).func_70089_S() || entityplayer1 instanceof EntityPlayer && ((EntityPlayer)entityplayer1).field_71075_bZ.field_75102_a) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            double d6 = radius;
            if (entityplayer1.func_70093_af()) {
                d6 = radius * (double)0.8f;
            }
            if (!(radius < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static EntityPlayer getClosestPlayerForSound(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityPlayer entity = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entityplayer1 = (Entity)world.field_72996_f.get(i);
            if (!entityplayer1.func_70089_S() || !(entityplayer1 instanceof EntityPlayer)) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            double d6 = radius;
            if (!(radius < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entity = (EntityPlayer)entityplayer1;
        }
        return entity;
    }

    public static EntityHunterChopper getClosestChopperForSound(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityHunterChopper entity = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entityplayer1 = (Entity)world.field_72996_f.get(i);
            if (!entityplayer1.func_70089_S() || !(entityplayer1 instanceof EntityHunterChopper)) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            double d6 = radius;
            if (!(radius < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entity = (EntityHunterChopper)entityplayer1;
        }
        return entity;
    }

    public static EntityChopperMine getClosestMineForSound(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityChopperMine entity = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entityplayer1 = (Entity)world.field_72996_f.get(i);
            if (!entityplayer1.func_70089_S() || !(entityplayer1 instanceof EntityChopperMine)) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            double d6 = radius;
            if (!(radius < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entity = (EntityChopperMine)entityplayer1;
        }
        return entity;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, double length, float interpolation) {
        Vec3 vec3 = Library.getPosition(interpolation, player);
        vec3.field_72448_b += (double)player.eyeHeight;
        Vec3 vec31 = player.func_70676_i(interpolation);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * length, vec31.field_72448_b * length, vec31.field_72449_c * length);
        return player.field_70170_p.func_147447_a(vec3, vec32, false, false, true);
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, double length, float interpolation, boolean allowLiquids, boolean disallowNonCollidingBlocks, boolean mopOnMiss) {
        Vec3 vec3 = Library.getPosition(interpolation, player);
        vec3.field_72448_b += (double)player.eyeHeight;
        Vec3 vec31 = player.func_70676_i(interpolation);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * length, vec31.field_72448_b * length, vec31.field_72449_c * length);
        return player.field_70170_p.func_147447_a(vec3, vec32, allowLiquids, disallowNonCollidingBlocks, mopOnMiss);
    }

    public static Vec3 getPosition(float interpolation, EntityPlayer player) {
        if (interpolation == 1.0f) {
            return Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight())), (double)player.field_70161_v);
        }
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)interpolation;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)interpolation + (double)(player.func_70047_e() - player.getDefaultEyeHeight());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)interpolation;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public static List<int[]> getBlockPosInPath(int x, int y, int z, int length, Vec3 vec0) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        int i = 0;
        while (i <= length) {
            list.add(new int[]{(int)((double)x + vec0.field_72450_a * (double)i), y, (int)((double)z + vec0.field_72449_c * (double)i), i++});
        }
        return list;
    }

    public static long chargeItemsFromTE(ItemStack[] slots, int index, long power, long maxPower) {
        if (power < 0L) {
            return 0L;
        }
        if (power > maxPower) {
            return maxPower;
        }
        if (slots[index] != null && slots[index].func_77973_b() == ModItems.battery_creative) {
            return 0L;
        }
        if (slots[index] != null && slots[index].func_77973_b() == ModItems.fusion_core_infinite) {
            return 0L;
        }
        if (slots[index] != null && slots[index].func_77973_b() instanceof IBatteryItem) {
            IBatteryItem battery = (IBatteryItem)slots[index].func_77973_b();
            long batMax = battery.getMaxCharge(slots[index]);
            long batCharge = battery.getCharge(slots[index]);
            long batRate = battery.getChargeRate();
            long toCharge = Math.min(Math.min(power, batRate), batMax - batCharge);
            power -= toCharge;
            battery.chargeBattery(slots[index], toCharge);
        }
        return power;
    }

    public static long chargeTEFromItems(ItemStack[] slots, int index, long power, long maxPower) {
        if (slots[index] != null && slots[index].func_77973_b() == ModItems.battery_creative) {
            return maxPower;
        }
        if (slots[index] != null && slots[index].func_77973_b() == ModItems.fusion_core_infinite) {
            return maxPower;
        }
        if (slots[index] != null && slots[index].func_77973_b() instanceof IBatteryItem) {
            IBatteryItem battery = (IBatteryItem)slots[index].func_77973_b();
            long batCharge = battery.getCharge(slots[index]);
            long batRate = battery.getDischargeRate();
            long toDischarge = Math.min(Math.min(maxPower - power, batRate), batCharge);
            battery.dischargeBattery(slots[index], toDischarge);
            power += toDischarge;
        }
        return power;
    }

    public static void ffgeua(int x, int y, int z, boolean newTact, Object that, World worldObj) {
    }

    public static double smoothstep(double t, double edge0, double edge1) {
        t = MathHelper.func_151237_a((double)((t - edge0) / (edge1 - edge0)), (double)0.0, (double)1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    public static float smoothstep(float t, float edge0, float edge1) {
        t = MathHelper.func_76131_a((float)((t - edge0) / (edge1 - edge0)), (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    public static boolean isObstructed(World world, double x, double y, double z, double a, double b, double c) {
        MovingObjectPosition pos = world.func_72933_a(Vec3.func_72443_a((double)x, (double)y, (double)z), Vec3.func_72443_a((double)a, (double)b, (double)c));
        return pos != null;
    }

    public static boolean isObstructedOpaque(World world, double x, double y, double z, double a, double b, double c) {
        MovingObjectPosition pos = world.func_147447_a(Vec3.func_72443_a((double)x, (double)y, (double)z), Vec3.func_72443_a((double)a, (double)b, (double)c), false, true, false);
        return pos != null;
    }

    public static Block getRandomConcrete() {
        int i = rand.nextInt(20);
        if (i <= 1) {
            return ModBlocks.brick_concrete_broken;
        }
        if (i <= 4) {
            return ModBlocks.brick_concrete_cracked;
        }
        if (i <= 10) {
            return ModBlocks.brick_concrete_mossy;
        }
        return ModBlocks.brick_concrete;
    }
}

