/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.main;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.handler.ImpactWorldHandler;
import com.hbm.saveddata.TomSaveData;
import com.hbm.world.WorldProviderNTM;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ModEventHandlerImpact {
    private static Random rand = new Random();

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.world != null && !event.world.field_72995_K && event.phase == TickEvent.Phase.START) {
            float settle = 6.944445E-8f;
            float cool = 4.1666666E-5f;
            ImpactWorldHandler.impactEffects(event.world);
            TomSaveData data = TomSaveData.forWorld(event.world);
            if (data.dust > 0.0f && data.fire == 0.0f) {
                data.dust = Math.max(0.0f, data.dust - settle);
                data.func_76185_a();
            }
            if (data.fire > 0.0f) {
                data.fire = Math.max(0.0f, data.fire - cool);
                data.dust = Math.min(1.0f, data.dust + cool);
                data.func_76185_a();
            }
            if (!event.world.field_72996_f.isEmpty()) {
                ArrayList oList = new ArrayList();
                oList.addAll(event.world.field_72996_f);
                for (Object e : oList) {
                    if (!(e instanceof EntityLivingBase)) continue;
                    EntityLivingBase entity = (EntityLivingBase)e;
                    if (entity.field_70170_p.field_73011_w.field_76574_g != 0 || !(data.fire > 0.0f) || !(data.dust < 0.75f) || event.world.func_72972_b(EnumSkyBlock.Sky, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v) <= 7) continue;
                    entity.func_70015_d(5);
                    entity.func_70097_a(DamageSource.field_76370_b, 2.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void extinction(LivingSpawnEvent.CheckSpawn event) {
        TomSaveData data = TomSaveData.forWorld(event.world);
        if (data.impact && !(event.entityLiving instanceof EntityPlayer) && event.entityLiving instanceof EntityLivingBase) {
            Random rand;
            if (event.world.field_73011_w.field_76574_g == 0 && (event.entityLiving.field_70131_O >= 0.85f || event.entityLiving.field_70130_N >= 0.85f && !(event.entity instanceof EntityWaterMob) && !event.entityLiving.func_70631_g_())) {
                event.setResult(Event.Result.DENY);
                event.entityLiving.func_70106_y();
            }
            if (event.entityLiving instanceof EntityWaterMob && (rand = new Random()).nextInt(5) != 0) {
                event.setResult(Event.Result.DENY);
                event.entityLiving.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onPopulate(PopulateChunkEvent.Populate event) {
        if (event.type == PopulateChunkEvent.Populate.EventType.ANIMALS) {
            TomSaveData data = TomSaveData.forWorld(event.world);
            if (data.impact) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLoad(WorldEvent.Load event) {
        TomSaveData.resetLastCached();
        if (GeneralConfig.enableImpactWorldProvider) {
            DimensionManager.unregisterProviderType((int)0);
            DimensionManager.registerProviderType((int)0, WorldProviderNTM.class, (boolean)true);
        }
    }

    @SubscribeEvent
    public void modifyVillageGen(BiomeEvent.GetVillageBlockID event) {
        Block b = event.original;
        Material mat = event.original.func_149688_o();
        TomSaveData data = TomSaveData.getLastCachedOrNull();
        if (data == null || event.biome == null) {
            return;
        }
        if (data.impact) {
            if (mat == Material.field_151575_d || mat == Material.field_151592_s || b == Blocks.field_150468_ap || b instanceof BlockCrops || b == Blocks.field_150486_ae || b instanceof BlockDoor || mat == Material.field_151580_n || mat == Material.field_151586_h || b == Blocks.field_150333_U) {
                event.replacement = Blocks.field_150350_a;
            } else if (b == Blocks.field_150347_e || b == Blocks.field_150417_aV) {
                if (rand.nextInt(3) == 1) {
                    event.replacement = Blocks.field_150351_n;
                }
            } else if (b == Blocks.field_150322_A) {
                if (rand.nextInt(3) == 1) {
                    event.replacement = Blocks.field_150354_m;
                }
            } else if (b == Blocks.field_150458_ak) {
                event.replacement = Blocks.field_150346_d;
            }
        }
        if (event.replacement != null) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void postImpactGeneration(BiomeEvent event) {
        TomSaveData data = TomSaveData.getLastCachedOrNull();
        if (data != null && event.biome != null && event.biome.field_76752_A != null && event.biome.field_76752_A == Blocks.field_150349_c) {
            event.biome.field_76752_A = data.impact && (data.dust > 0.0f || data.fire > 0.0f) ? ModBlocks.impact_dirt : Blocks.field_150349_c;
        }
    }

    @SubscribeEvent
    public void postImpactDecoration(DecorateBiomeEvent.Decorate event) {
        block13: {
            block10: {
                block16: {
                    DecorateBiomeEvent.Decorate.EventType type;
                    block15: {
                        block14: {
                            TomSaveData data;
                            block11: {
                                block12: {
                                    data = TomSaveData.forWorld(event.world);
                                    if (!data.impact) break block10;
                                    type = event.type;
                                    if (!(data.dust > 0.0f) && !(data.fire > 0.0f)) break block11;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_0 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.TREE) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_1 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_2 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.GRASS) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_3 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.REED) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_4 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.FLOWERS) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_5 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_6 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.CACTUS) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_7 = event.type;
                                    if (type == DecorateBiomeEvent.Decorate.EventType.PUMPKIN) break block12;
                                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_8 = event.type;
                                    if (type != DecorateBiomeEvent.Decorate.EventType.LILYPAD) break block13;
                                }
                                event.setResult(Event.Result.DENY);
                                break block13;
                            }
                            if (data.dust != 0.0f || data.fire != 0.0f) break block13;
                            DecorateBiomeEvent.Decorate.EventType cfr_ignored_9 = event.type;
                            if (type == DecorateBiomeEvent.Decorate.EventType.TREE) break block14;
                            DecorateBiomeEvent.Decorate.EventType cfr_ignored_10 = event.type;
                            if (type == DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM) break block14;
                            DecorateBiomeEvent.Decorate.EventType cfr_ignored_11 = event.type;
                            if (type != DecorateBiomeEvent.Decorate.EventType.CACTUS) break block15;
                        }
                        if (event.world.field_73012_v.nextInt(9) == 0) {
                            event.setResult(Event.Result.DEFAULT);
                        } else {
                            event.setResult(Event.Result.DENY);
                        }
                    }
                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_12 = event.type;
                    if (type == DecorateBiomeEvent.Decorate.EventType.GRASS) break block16;
                    DecorateBiomeEvent.Decorate.EventType cfr_ignored_13 = event.type;
                    if (type != DecorateBiomeEvent.Decorate.EventType.REED) break block13;
                }
                event.setResult(Event.Result.DEFAULT);
                break block13;
            }
            event.setResult(Event.Result.DEFAULT);
        }
    }

    @SubscribeEvent
    public void populateChunkPre(PopulateChunkEvent.Pre event) {
        TomSaveData.forWorld(event.world);
    }

    @SubscribeEvent
    public void populateChunkPost(PopulateChunkEvent.Post event) {
        TomSaveData data = TomSaveData.forWorld(event.world);
        if (data.impact) {
            Chunk chunk = event.world.func_72964_e(event.chunkX, event.chunkZ);
            for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
                if (storage == null) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            if (!((double)data.dust > 0.25) && !(data.fire > 0.0f)) continue;
                            if (storage.func_150819_a(x, y, z) == Blocks.field_150349_c) {
                                storage.func_150818_a(x, y, z, ModBlocks.impact_dirt);
                                continue;
                            }
                            if (storage.func_150819_a(x, y, z) instanceof BlockLog) {
                                storage.func_150818_a(x, y, z, Blocks.field_150350_a);
                                continue;
                            }
                            if (storage.func_150819_a(x, y, z) instanceof BlockLeaves) {
                                storage.func_150818_a(x, y, z, Blocks.field_150350_a);
                                continue;
                            }
                            if (storage.func_150819_a(x, y, z).func_149688_o() == Material.field_151584_j) {
                                storage.func_150818_a(x, y, z, Blocks.field_150350_a);
                                continue;
                            }
                            if (storage.func_150819_a(x, y, z).func_149688_o() == Material.field_151585_k) {
                                storage.func_150818_a(x, y, z, Blocks.field_150350_a);
                                continue;
                            }
                            if (!(storage.func_150819_a(x, y, z) instanceof BlockBush)) continue;
                            storage.func_150818_a(x, y, z, Blocks.field_150350_a);
                        }
                    }
                }
            }
        }
    }
}

