/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.module.machine;

import api.hbm.energymk2.IEnergyHandlerMK2;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ModuleMachineBase {
    public int index;
    public IEnergyHandlerMK2 battery;
    public ItemStack[] slots;
    public int[] inputSlots;
    public int[] outputSlots;
    public FluidTank[] inputTanks;
    public FluidTank[] outputTanks;
    public String recipe = "null";
    public double progress;
    public boolean didProcess = false;
    public boolean markDirty = false;

    public ModuleMachineBase(int index, IEnergyHandlerMK2 battery, ItemStack[] slots) {
        this.index = index;
        this.battery = battery;
        this.slots = slots;
    }

    public void setupTanks(GenericRecipe recipe) {
        int i;
        if (recipe == null) {
            return;
        }
        for (i = 0; i < this.inputTanks.length; ++i) {
            if (recipe.inputFluid != null && recipe.inputFluid.length > i) {
                this.inputTanks[i].conform(recipe.inputFluid[i]);
                continue;
            }
            this.inputTanks[i].resetTank();
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            if (recipe.outputFluid != null && recipe.outputFluid.length > i) {
                this.outputTanks[i].conform(recipe.outputFluid[i]);
                continue;
            }
            this.outputTanks[i].resetTank();
        }
    }

    public boolean canProcess(GenericRecipe recipe, double speed, double power) {
        if (recipe == null) {
            return false;
        }
        if (recipe.autoSwitchGroup != null && this.slots[this.inputSlots[0]] != null) {
            ItemStack itemToSwitchBy = this.slots[this.inputSlots[0]];
            List<GenericRecipe> recipes = this.getRecipeSet().autoSwitchGroups.get(recipe.autoSwitchGroup);
            if (recipes != null) {
                for (GenericRecipe nextRec : recipes) {
                    if (nextRec.getInternalName().equals(this.recipe) || nextRec.inputItem == null || !nextRec.inputItem[0].matchesRecipe(itemToSwitchBy, true)) continue;
                    this.recipe = nextRec.getInternalName();
                    return false;
                }
            }
        }
        if (power != 1.0 && (double)this.battery.getPower() < (double)recipe.power * power) {
            return false;
        }
        if (power == 1.0 && this.battery.getPower() < recipe.power) {
            return false;
        }
        if (recipe.inputItem != null) {
            for (int i = 0; i < Math.min(recipe.inputItem.length, this.inputSlots.length); ++i) {
                if (recipe.inputItem[i].matchesRecipe(this.slots[this.inputSlots[i]], false)) continue;
                return false;
            }
        }
        if (recipe.inputFluid != null) {
            for (int i = 0; i < Math.min(recipe.inputFluid.length, this.inputTanks.length); ++i) {
                if (this.inputTanks[i].getFill() >= recipe.inputFluid[i].fill) continue;
                return false;
            }
        }
        if (recipe.outputItem != null) {
            for (int i = 0; i < Math.min(recipe.outputItem.length, this.outputSlots.length); ++i) {
                ItemStack stack = this.slots[this.outputSlots[i]];
                if (stack == null) continue;
                GenericRecipes.IOutput output = recipe.outputItem[i];
                if (output.possibleMultiOutput()) {
                    return false;
                }
                ItemStack single = output.getSingle();
                if (single == null) {
                    return false;
                }
                if (stack.func_77973_b() != single.func_77973_b()) {
                    return false;
                }
                if (stack.func_77960_j() != single.func_77960_j()) {
                    return false;
                }
                if (stack.field_77994_a + single.field_77994_a <= stack.func_77976_d()) continue;
                return false;
            }
        }
        if (recipe.outputFluid != null) {
            for (int i = 0; i < Math.min(recipe.outputFluid.length, this.outputTanks.length); ++i) {
                if (recipe.outputFluid[i].fill + this.outputTanks[i].getFill() <= this.outputTanks[i].getMaxFill()) continue;
                return false;
            }
        }
        return true;
    }

    public void process(GenericRecipe recipe, double speed, double power) {
        this.battery.setPower(this.battery.getPower() - (power == 1.0 ? recipe.power : (long)((double)recipe.power * power)));
        double step = Math.min(speed / (double)recipe.duration, 1.0);
        this.progress += step;
        if (this.progress >= 1.0) {
            int i;
            if (recipe.inputItem != null) {
                for (i = 0; i < Math.min(recipe.inputItem.length, this.inputSlots.length); ++i) {
                    this.slots[this.inputSlots[i]].field_77994_a -= recipe.inputItem[i].stacksize;
                    if (this.slots[this.inputSlots[i]].field_77994_a > 0) continue;
                    this.slots[this.inputSlots[i]] = null;
                }
            }
            if (recipe.inputFluid != null) {
                for (i = 0; i < Math.min(recipe.inputFluid.length, this.inputTanks.length); ++i) {
                    this.inputTanks[i].setFill(this.inputTanks[i].getFill() - recipe.inputFluid[i].fill);
                }
            }
            if (recipe.outputItem != null) {
                for (i = 0; i < Math.min(recipe.outputItem.length, this.outputSlots.length); ++i) {
                    ItemStack collapse = recipe.outputItem[i].collapse();
                    if (this.slots[this.outputSlots[i]] == null) {
                        this.slots[this.outputSlots[i]] = collapse;
                        continue;
                    }
                    if (collapse == null) continue;
                    this.slots[this.outputSlots[i]].field_77994_a += collapse.field_77994_a;
                }
            }
            if (recipe.outputFluid != null) {
                for (i = 0; i < Math.min(recipe.outputFluid.length, this.outputTanks.length); ++i) {
                    this.outputTanks[i].setFill(this.outputTanks[i].getFill() + recipe.outputFluid[i].fill);
                }
            }
            this.markDirty = true;
            this.progress = this.canProcess(recipe, speed, power) ? (this.progress -= 1.0) : 0.0;
        }
    }

    public GenericRecipe getRecipe() {
        return (GenericRecipe)this.getRecipeSet().recipeNameMap.get(this.recipe);
    }

    public abstract GenericRecipes getRecipeSet();

    public void update(double speed, double power, boolean extraCondition) {
        GenericRecipe recipe = this.getRecipe();
        this.setupTanks(recipe);
        this.didProcess = false;
        this.markDirty = false;
        if (extraCondition && this.canProcess(recipe, speed, power)) {
            this.process(recipe, speed, power);
            this.didProcess = true;
        } else {
            this.progress = 0.0;
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        List<GenericRecipe> recipes;
        GenericRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return false;
        }
        if (recipe.inputItem == null) {
            return false;
        }
        for (int i = 0; i < Math.min(this.inputSlots.length, recipe.inputItem.length); ++i) {
            if (this.inputSlots[i] != slot || !recipe.inputItem[i].matchesRecipe(stack, true)) continue;
            return true;
        }
        if (recipe.autoSwitchGroup != null && (recipes = this.getRecipeSet().autoSwitchGroups.get(recipe.autoSwitchGroup)) != null) {
            for (GenericRecipe newRec : recipes) {
                if (newRec.inputItem == null || this.inputSlots[0] != slot || !newRec.inputItem[0].matchesRecipe(stack, true)) continue;
                return true;
            }
        }
        return false;
    }

    public void serialize(ByteBuf buf) {
        buf.writeDouble(this.progress);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.recipe);
    }

    public void deserialize(ByteBuf buf) {
        this.progress = buf.readDouble();
        this.recipe = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.progress = nbt.func_74769_h("progress" + this.index);
        this.recipe = nbt.func_74779_i("recipe" + this.index);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("progress" + this.index, this.progress);
        nbt.func_74778_a("recipe" + this.index, this.recipe);
    }
}

