/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.qmaw;

import com.hbm.qmaw.ManualElement;
import com.hbm.qmaw.QMAWLoader;
import com.hbm.qmaw.QuickManualAndWiki;
import com.hbm.qmaw.components.QComponentLink;
import com.hbm.qmaw.components.QComponentText;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiQMAW
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_wiki.png");
    public String title;
    public String qmawID;
    public ItemStack icon;
    public List<List<ManualElement>> lines = new ArrayList<List<ManualElement>>();
    public List<String> back = new ArrayList<String>();
    public List<String> forward = new ArrayList<String>();
    protected int xSize = 340;
    protected int ySize = 224;
    protected int guiLeft;
    protected int guiTop;
    protected boolean isDragging = false;
    protected int scrollProgress = 0;
    protected int lastClickX = 0;
    protected int lastClickY = 0;
    public static final String EN_US = "en_US";

    public GuiQMAW(QuickManualAndWiki qmaw) {
        this.qmawID = qmaw.name;
        this.parseQMAW(qmaw);
    }

    protected void parseQMAW(QuickManualAndWiki qmaw) {
        LanguageManager lang = Minecraft.func_71410_x().func_135016_M();
        this.title = qmaw.title.get(lang.func_135041_c());
        if (this.title == null) {
            this.title = qmaw.title.get(EN_US);
        }
        if (this.title == null) {
            this.title = "Missing Localization!";
        }
        this.icon = qmaw.icon;
        String toParse = qmaw.contents.get(lang.func_135041_c());
        if (toParse == null) {
            toParse = qmaw.contents.get(EN_US);
        }
        if (toParse == null) {
            toParse = "Missing Localization!";
        }
        toParse = "" + toParse;
        int maxLineLength = this.xSize - 29;
        String prevToParse = "" + toParse;
        int maxIterations = 1000;
        int currentLineWidth = 0;
        while (!toParse.isEmpty() && maxIterations > 0) {
            int brIndex;
            int linkIndex;
            int width;
            int end;
            if (this.lines.isEmpty()) {
                this.lines.add(new ArrayList());
            }
            List<ManualElement> currentLine = this.lines.get(this.lines.size() - 1);
            toParse = toParse.trim();
            --maxIterations;
            if (toParse.startsWith("<br>")) {
                toParse = toParse.substring(4);
                currentLine = new ArrayList<ManualElement>();
                this.lines.add(currentLine);
                currentLineWidth = 0;
                continue;
            }
            if (toParse.startsWith("[[") && (end = toParse.indexOf("]]")) != -1) {
                String link = toParse.substring(2, end);
                toParse = toParse.substring(end + 2);
                int pipe = link.indexOf("|");
                String suffix = toParse.startsWith(" ") ? " " : "";
                QComponentLink linkComponent = pipe == -1 ? new QComponentLink(link, link + suffix) : new QComponentLink(link.substring(pipe + 1, link.length()), link.substring(0, pipe) + suffix);
                width = linkComponent.getWidth();
                if (width + currentLineWidth <= maxLineLength) {
                    currentLine.add(linkComponent);
                    currentLineWidth += width;
                } else {
                    currentLine = new ArrayList<ManualElement>();
                    this.lines.add(currentLine);
                    currentLine.add(linkComponent);
                    currentLineWidth = width;
                }
                prevToParse = "" + toParse;
                continue;
            }
            int delimit = toParse.length();
            int spaceIndex = toParse.indexOf(" ");
            if (spaceIndex != -1) {
                delimit = Math.min(delimit, spaceIndex);
            }
            if ((linkIndex = toParse.indexOf("[[")) != -1) {
                delimit = Math.min(delimit, linkIndex);
            }
            if ((brIndex = toParse.indexOf("<br>")) != -1) {
                delimit = Math.min(delimit, brIndex);
            }
            if (delimit > 0) {
                QComponentText textComponent = new QComponentText(toParse.substring(0, delimit) + (spaceIndex == delimit ? " " : ""));
                toParse = toParse.substring(delimit);
                width = textComponent.getWidth();
                if (width + currentLineWidth <= maxLineLength) {
                    currentLine.add(textComponent);
                    currentLineWidth += width;
                } else {
                    currentLine = new ArrayList<ManualElement>();
                    this.lines.add(currentLine);
                    currentLine.add(textComponent);
                    currentLineWidth = width;
                }
                prevToParse = "" + toParse;
                continue;
            }
            if (toParse.equals(prevToParse)) break;
            prevToParse = "" + toParse;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    protected void func_73864_a(int x, int y, int key) {
        super.func_73864_a(x, y, key);
        if (key == 0) {
            this.lastClickX = x;
            this.lastClickY = y;
        }
        if (this.guiLeft + 3 <= x && this.guiLeft + 3 + 18 > x && this.guiTop + 3 < y && this.guiTop + 3 + 18 >= y) {
            this.back();
        }
        if (this.guiLeft + 21 <= x && this.guiLeft + 21 + 18 > x && this.guiTop + 3 < y && this.guiTop + 3 + 18 >= y) {
            this.forward();
        }
    }

    public void back() {
        if (this.back.isEmpty()) {
            return;
        }
        String prev = this.back.get(this.back.size() - 1);
        QuickManualAndWiki qmaw = QMAWLoader.qmaw.get(prev);
        if (qmaw != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            GuiQMAW screen = new GuiQMAW(qmaw);
            screen.back.addAll(this.back);
            screen.back.remove(screen.back.size() - 1);
            screen.forward.addAll(this.forward);
            screen.forward.add(this.qmawID);
            FMLCommonHandler.instance().showGuiScreen((Object)screen);
        }
    }

    public void forward() {
        if (this.forward.isEmpty()) {
            return;
        }
        String next = this.forward.get(this.forward.size() - 1);
        QuickManualAndWiki qmaw = QMAWLoader.qmaw.get(next);
        if (qmaw != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            GuiQMAW screen = new GuiQMAW(qmaw);
            screen.back.addAll(this.back);
            screen.back.add(this.qmawID);
            screen.forward.addAll(this.forward);
            screen.forward.remove(screen.forward.size() - 1);
            FMLCommonHandler.instance().showGuiScreen((Object)screen);
        }
    }

    public int getSliderPosition() {
        double progress = (double)this.scrollProgress / (double)(this.lines.size() - 1);
        return 25 + (int)(progress * 180.0);
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (Mouse.isButtonDown((int)0) && this.guiLeft + this.xSize - 15 <= mouseX && this.guiLeft + this.xSize - 15 + 12 > mouseX && this.guiTop + 25 < mouseY && this.guiTop + 25 + 191 >= mouseY) {
            this.isDragging = true;
        }
        if (!Mouse.isButtonDown((int)0)) {
            this.isDragging = false;
        }
        if (this.isDragging) {
            int min = this.guiTop + 25 + 8;
            int max = this.guiTop + 25 + 191 - 8;
            int span = max - min;
            double progress = MathHelper.func_151237_a((double)((double)(mouseY - min) / (double)span), (double)0.0, (double)1.0);
            this.scrollProgress = MathHelper.func_76125_a((int)((int)Math.round((double)(this.lines.size() - 1) * progress)), (int)0, (int)(this.lines.size() - 1));
        }
        this.handleScroll();
        GuiQMAW.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-536870912);
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
        this.lastClickX = 0;
        this.lastClickY = 0;
    }

    protected void handleScroll() {
        if (!Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1) && Mouse.next()) {
            int scroll = Mouse.getEventDWheel();
            if (scroll > 0 && this.scrollProgress > 0) {
                --this.scrollProgress;
            }
            if (scroll < 0 && this.scrollProgress < this.lines.size() - 1) {
                ++this.scrollProgress;
            }
        }
    }

    private void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int x = 43;
        int y = 4;
        if (this.icon != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            Minecraft mc = Minecraft.func_71410_x();
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            RenderHelper.func_74519_b();
            GL11.glRotated((double)-180.0, (double)1.0, (double)0.0, (double)0.0);
            field_146296_j.func_82406_b(this.field_146289_q, mc.field_71446_o, this.icon, this.guiLeft + x, this.guiTop + y);
            field_146296_j.func_94148_a(this.field_146289_q, mc.field_71446_o, this.icon, this.guiLeft + x, this.guiTop + y, null);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2929);
            GL11.glPopMatrix();
            x += 18;
            y += (16 - this.field_146289_q.field_78288_b) / 2;
        }
        this.field_146289_q.func_78276_b(this.title, this.guiLeft + x, this.guiTop + ++y, 0xFFFFFF);
    }

    private void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 170, this.ySize);
        this.func_73729_b(this.guiLeft + 170, this.guiTop, 52, 0, 30, this.ySize);
        this.func_73729_b(this.guiLeft + 200, this.guiTop, 52, 0, 140, this.ySize);
        if (!this.back.isEmpty()) {
            this.func_73729_b(this.guiLeft + 3, this.guiTop + 3, 204, 0, 18, 18);
        }
        if (!this.forward.isEmpty()) {
            this.func_73729_b(this.guiLeft + 21, this.guiTop + 3, 222, 0, 18, 18);
        }
        this.func_73729_b(this.guiLeft + this.xSize - 15, this.guiTop + this.getSliderPosition(), 192, 0, 12, 16);
        int x = this.guiLeft + 7;
        int y = this.guiTop + 30;
        int lineNum = 0;
        for (List<ManualElement> line : this.lines) {
            if (++lineNum <= this.scrollProgress) continue;
            int maxHeight = 0;
            int inset = 0;
            for (ManualElement element : line) {
                maxHeight = Math.max(maxHeight, element.getHeight());
            }
            if (y + maxHeight > this.guiTop + 219) break;
            if (line.isEmpty()) {
                y += this.field_146289_q.field_78288_b;
            }
            for (ManualElement element : line) {
                int elementX = x + inset;
                int elementY = y + (maxHeight - element.getHeight()) / 2;
                boolean mouseOver = elementX <= mouseX && elementX + element.getWidth() > mouseX && elementY < mouseY && elementY + element.getHeight() >= mouseY;
                element.render(mouseOver, elementX, elementY, mouseX, mouseY);
                if (elementX <= this.lastClickX && elementX + element.getWidth() > this.lastClickX && elementY < this.lastClickY && elementY + element.getHeight() >= this.lastClickY) {
                    element.onClick(this);
                }
                inset += element.getWidth();
            }
            y += maxHeight + 2;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 203) {
            this.back();
        }
        if (keyCode == 205) {
            this.forward();
        }
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
    }
}

