/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.config.ClientConfig;
import com.hbm.main.ResourceManager;
import com.hbm.tileentity.network.TileEntityPylonBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class RenderPylonBase
extends TileEntitySpecialRenderer {
    public static final int LINE_COLOR = 0xBB3311;

    public void renderLinesGeneric(TileEntityPylonBase pyl, double x, double y, double z) {
        this.func_147499_a(pyl.color == 0 ? ResourceManager.wire_tex : ResourceManager.wire_greyscale_tex);
        pyl.getConnected().forEach(wire -> {
            TileEntity tile = pyl.func_145831_w().func_147438_o(wire[0], wire[1], wire[2]);
            if (tile instanceof TileEntityPylonBase) {
                TileEntityPylonBase pylon = (TileEntityPylonBase)tile;
                Vec3[] m1 = pyl.getMountPos();
                Vec3[] m2 = pylon.getMountPos();
                int lineCount = Math.min(m1.length, m2.length);
                for (int line = 0; line < lineCount; ++line) {
                    Vec3 first = m1[line % m1.length];
                    int secondIndex = line % m2.length;
                    if (lineCount == 4 && (pyl.func_145832_p() - 10 == 5 && pylon.func_145832_p() - 10 == 2 || pyl.func_145832_p() - 10 == 2 && pylon.func_145832_p() - 10 == 5)) {
                        secondIndex += 2;
                        secondIndex %= m2.length;
                    }
                    Vec3 second = m2[secondIndex];
                    double sX = second.field_72450_a + (double)pylon.field_145851_c - (double)pyl.field_145851_c;
                    double sY = second.field_72448_b + (double)pylon.field_145848_d - (double)pyl.field_145848_d;
                    double sZ = second.field_72449_c + (double)pylon.field_145849_e - (double)pyl.field_145849_e;
                    this.renderLine(pyl.func_145831_w(), pyl, x, y, z, first.field_72450_a, first.field_72448_b, first.field_72449_c, first.field_72450_a + (sX - first.field_72450_a) * 0.5, first.field_72448_b + (sY - first.field_72448_b) * 0.5, first.field_72449_c + (sZ - first.field_72449_c) * 0.5);
                }
            }
        });
    }

    public void renderLine(World world, TileEntityPylonBase pyl, double x, double y, double z, double x0, double y0, double z0, double x1, double y1, double z1) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        float count = 10.0f;
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        tess.func_78382_b();
        Vec3 delta = Vec3.func_72443_a((double)(x0 - x1), (double)(y0 - y1), (double)(z0 - z1));
        double girth = 0.03125;
        double hyp = Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c);
        double yaw = Math.atan2(delta.field_72450_a, delta.field_72449_c);
        double pitch = Math.atan2(delta.field_72448_b, hyp);
        double rotator = 1.5707963267948966;
        double newPitch = pitch + rotator;
        double newYaw = yaw + rotator;
        double iZ = Math.cos(yaw) * Math.cos(newPitch) * girth;
        double iX = Math.sin(yaw) * Math.cos(newPitch) * girth;
        double iY = Math.sin(newPitch) * girth;
        double jZ = Math.cos(newYaw) * girth;
        double jX = Math.sin(newYaw) * girth;
        if (!ClientConfig.RENDER_CABLE_HANG.get().booleanValue()) {
            tess.func_78378_d(pyl.color == 0 ? 0xFFFFFF : pyl.color);
            this.drawLineSegment(tess, x0, y0, z0, x1, y1, z1, iX, iY, iZ, jX, jZ);
        } else {
            double hang = Math.min(delta.func_72433_c() / 15.0, 2.5);
            for (float j = 0.0f; j < count; j += 1.0f) {
                float k = j + 1.0f;
                double sagJ = Math.sin((double)(j / count) * Math.PI * 0.5) * hang;
                double sagK = Math.sin((double)(k / count) * Math.PI * 0.5) * hang;
                double sagMean = (sagJ + sagK) / 2.0;
                double deltaX = x1 - x0;
                double deltaY = y1 - y0;
                double deltaZ = z1 - z0;
                double ja = (double)j + 0.5;
                double ix = (double)pyl.field_145851_c + x0 + deltaX / (double)count * ja;
                double iy = (double)pyl.field_145848_d + y0 + deltaY / (double)count * ja - sagMean;
                double iz = (double)pyl.field_145849_e + z0 + deltaZ / (double)count * ja;
                int brightness = world.func_72802_i(MathHelper.func_76128_c((double)ix), MathHelper.func_76128_c((double)iy), MathHelper.func_76128_c((double)iz), 0);
                tess.func_78380_c(brightness);
                tess.func_78378_d(pyl.color == 0 ? 0xFFFFFF : pyl.color);
                this.drawLineSegment(tess, x0 + deltaX * (double)j / (double)count, y0 + deltaY * (double)j / (double)count - sagJ, z0 + deltaZ * (double)j / (double)count, x0 + deltaX * (double)k / (double)count, y0 + deltaY * (double)k / (double)count - sagK, z0 + deltaZ * (double)k / (double)count, iX, iY, iZ, jX, jZ);
            }
        }
        tess.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public void drawLineSegment(Tessellator tessellator, double x, double y, double z, double a, double b, double c, double iX, double iY, double iZ, double jX, double jZ) {
        double deltaX = a - x;
        double deltaY = b - y;
        double deltaZ = c - z;
        double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        int wrap = (int)Math.ceil(length * 8.0);
        if (deltaX + deltaZ < 0.0) {
            wrap *= -1;
            jZ *= -1.0;
            jX *= -1.0;
        }
        tessellator.func_78374_a(x + iX, y + iY, z + iZ, 0.0, 0.0);
        tessellator.func_78374_a(x - iX, y - iY, z - iZ, 0.0, 1.0);
        tessellator.func_78374_a(a - iX, b - iY, c - iZ, (double)wrap, 1.0);
        tessellator.func_78374_a(a + iX, b + iY, c + iZ, (double)wrap, 0.0);
        tessellator.func_78374_a(x + jX, y, z + jZ, 0.0, 0.0);
        tessellator.func_78374_a(x - jX, y, z - jZ, 0.0, 1.0);
        tessellator.func_78374_a(a - jX, b, c - jZ, (double)wrap, 1.0);
        tessellator.func_78374_a(a + jX, b, c + jZ, (double)wrap, 0.0);
    }
}

