/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityMachineBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDeuteriumExtractor
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IFluidCopiable {
    public long power = 0L;
    public FluidTank[] tanks = new FluidTank[2];

    public TileEntityDeuteriumExtractor() {
        super(0);
        this.tanks[0] = new FluidTank(Fluids.WATER, 1000);
        this.tanks[1] = new FluidTank(Fluids.HEAVYWATER, 100);
    }

    @Override
    public String getName() {
        return "container.deuterium";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            if (this.hasPower() && this.hasEnoughWater() && this.tanks[1].getMaxFill() > this.tanks[1].getFill()) {
                int convert = Math.min(this.tanks[1].getMaxFill(), this.tanks[0].getFill()) / 50;
                convert = Math.min(convert, this.tanks[1].getMaxFill() - this.tanks[1].getFill());
                this.tanks[0].setFill(this.tanks[0].getFill() - convert * 50);
                this.tanks[1].setFill(this.tanks[1].getFill() + convert);
                this.power -= this.getMaxPower() / 20L;
            }
            this.subscribeToAllAround(this.tanks[0].getTankType(), this);
            this.sendFluidToAll(this.tanks[1], this);
            this.networkPackNT(50);
        }
    }

    protected void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    public boolean hasPower() {
        return this.power >= this.getMaxPower() / 20L;
    }

    public boolean hasEnoughWater() {
        return this.tanks[0].getFill() >= 100;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "heavyWater");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "heavyWater");
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

