/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineAssemblyMachine;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineAssemblyMachine;
import com.hbm.inventory.recipes.AssemblyMachineRecipes;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.module.machine.ModuleMachineAssembler;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityMachineAssemblyMachine
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IUpgradeInfoProvider,
IControlReceiver,
IGUIProvider {
    public FluidTank inputTank;
    public FluidTank outputTank;
    public long power;
    public long maxPower = 100000L;
    public boolean didProcess = false;
    public boolean frame = false;
    private AudioWrapper audio;
    public ModuleMachineAssembler assemblerModule;
    public AssemblerArm[] arms = new AssemblerArm[2];
    public double prevRing;
    public double ring;
    public double ringSpeed;
    public double ringTarget;
    public int ringDelay;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT(this);
    AxisAlignedBB bb = null;

    public TileEntityMachineAssemblyMachine() {
        super(17);
        this.inputTank = new FluidTank(Fluids.NONE, 4000);
        this.outputTank = new FluidTank(Fluids.NONE, 4000);
        for (int i = 0; i < this.arms.length; ++i) {
            this.arms[i] = new AssemblerArm();
        }
        this.assemblerModule = new ModuleMachineAssembler(0, this, this.slots).itemInput(4).itemOutput(16).fluidInput(this.inputTank).fluidOutput(this.outputTank);
    }

    @Override
    public String getName() {
        return "container.machineAssemblyMachine";
    }

    @Override
    public void func_145845_h() {
        if (this.maxPower <= 0L) {
            this.maxPower = 1000000L;
        }
        if (!this.field_145850_b.field_72995_K) {
            GenericRecipe recipe = (GenericRecipe)AssemblyMachineRecipes.INSTANCE.recipeNameMap.get(this.assemblerModule.recipe);
            if (recipe != null) {
                this.maxPower = recipe.power * 100L;
            }
            this.maxPower = BobMathUtil.max(this.power, this.maxPower, 100000L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            this.upgradeManager.checkSlots(this.slots, 2, 3);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                if (this.inputTank.getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.inputTank.getTankType(), this.field_145850_b, pos);
                }
                if (this.outputTank.getFill() <= 0) continue;
                this.tryProvide(this.outputTank, this.field_145850_b, pos);
            }
            double speed = 1.0;
            double pow = 1.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) / 3.0;
            pow -= (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3) * 0.25;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) * 1.0;
            this.assemblerModule.update(speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3), pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 10.0 / 3.0, true);
            this.didProcess = this.assemblerModule.didProcess;
            if (this.assemblerModule.markDirty) {
                this.func_70296_d();
            }
            if (this.didProcess && this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.meteorite_sword_alloyed) {
                this.slots[0] = new ItemStack(ModItems.meteorite_sword_machined);
            }
            this.networkPackNT(100);
        } else {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                boolean bl = this.frame = !this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
            }
            if (this.didProcess && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 50.0) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updateVolume(this.getVolume(1.0f));
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            for (AssemblerArm arm : this.arms) {
                arm.updateInterp();
                if (this.didProcess) {
                    arm.updateArm();
                    continue;
                }
                arm.returnToNullPos();
            }
            this.prevRing = this.ring;
            if (this.didProcess) {
                if (this.ring != this.ringTarget) {
                    double ringDelta = Math.abs(this.ringTarget - this.ring);
                    if (ringDelta <= this.ringSpeed) {
                        this.ring = this.ringTarget;
                    }
                    if (this.ringTarget > this.ring) {
                        this.ring += this.ringSpeed;
                    }
                    if (this.ringTarget < this.ring) {
                        this.ring -= this.ringSpeed;
                    }
                    if (this.ringTarget == this.ring) {
                        if (this.ringTarget >= 360.0) {
                            this.ringTarget -= 360.0;
                            this.ring -= 360.0;
                            this.prevRing -= 360.0;
                        }
                        if (this.ringTarget <= -360.0) {
                            this.ringTarget += 360.0;
                            this.ring += 360.0;
                            this.prevRing += 360.0;
                        }
                        this.ringDelay = 20 + this.field_145850_b.field_73012_v.nextInt(21);
                    }
                } else {
                    if (this.ringDelay > 0) {
                        --this.ringDelay;
                    }
                    if (this.ringDelay <= 0) {
                        this.ringTarget += (this.field_145850_b.field_73012_v.nextDouble() * 2.0 - 1.0) * 135.0;
                        this.ringSpeed = 10.0 + this.field_145850_b.field_73012_v.nextDouble() * 5.0;
                    }
                }
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.chemicalPlant", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 15.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 0, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 0, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.inputTank.serialize(buf);
        this.outputTank.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        buf.writeBoolean(this.didProcess);
        this.assemblerModule.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.inputTank.deserialize(buf);
        this.outputTank.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        this.didProcess = buf.readBoolean();
        this.assemblerModule.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTank.readFromNBT(nbt, "i");
        this.outputTank.readFromNBT(nbt, "o");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.assemblerModule.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inputTank.writeToNBT(nbt, "i");
        this.outputTank.writeToNBT(nbt, "o");
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        this.assemblerModule.writeToNBT(nbt);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        if (slot >= 2 && slot <= 3 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            return true;
        }
        return this.assemblerModule.isItemValid(slot, stack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 16;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.inputTank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.outputTank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.inputTank, this.outputTank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineAssemblyMachine(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineAssemblyMachine(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("index") && data.func_74764_b("selection")) {
            int index = data.func_74762_e("index");
            String selection = data.func_74779_i("selection");
            if (index == 0) {
                this.assemblerModule.recipe = selection;
                this.markChanged();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_assembly_machine));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.speed", "+" + level * 100 / 3 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }

    public static class AssemblerArm {
        public double[] angles = new double[4];
        public double[] prevAngles = new double[4];
        public double[] targetAngles = new double[4];
        public double[] speed = new double[4];
        Random rand = new Random();
        ArmActionState state = ArmActionState.ASSUME_POSITION;
        int actionDelay = 0;
        private double[][] pos = new double[][]{{45.0, -15.0, -5.0}, {15.0, 15.0, -15.0}, {25.0, 10.0, -15.0}, {30.0, 0.0, -10.0}, {70.0, -10.0, -25.0}};

        public AssemblerArm() {
            this.resetSpeed();
        }

        private void updateInterp() {
            for (int i = 0; i < this.angles.length; ++i) {
                this.prevAngles[i] = this.angles[i];
            }
        }

        private void returnToNullPos() {
            int i;
            for (i = 0; i < 4; ++i) {
                this.targetAngles[i] = 0.0;
            }
            for (i = 0; i < 3; ++i) {
                this.speed[i] = 3.0;
            }
            this.speed[3] = 0.25;
            this.state = ArmActionState.RETRACT_STRIKER;
            this.move();
        }

        private void resetSpeed() {
            this.speed[0] = 15.0;
            this.speed[1] = 15.0;
            this.speed[2] = 15.0;
            this.speed[3] = 0.5;
        }

        public void updateArm() {
            this.resetSpeed();
            if (this.actionDelay > 0) {
                --this.actionDelay;
                return;
            }
            switch (this.state) {
                case ASSUME_POSITION: {
                    if (!this.move()) break;
                    this.actionDelay = 2;
                    this.state = ArmActionState.EXTEND_STRIKER;
                    this.targetAngles[3] = -0.75;
                    break;
                }
                case EXTEND_STRIKER: {
                    if (!this.move()) break;
                    this.state = ArmActionState.RETRACT_STRIKER;
                    this.targetAngles[3] = 0.0;
                    break;
                }
                case RETRACT_STRIKER: {
                    if (!this.move()) break;
                    this.actionDelay = 2 + this.rand.nextInt(5);
                    this.chooseNewArmPoistion();
                    this.state = ArmActionState.ASSUME_POSITION;
                }
            }
        }

        public void chooseNewArmPoistion() {
            int chosen = this.rand.nextInt(this.pos.length);
            this.targetAngles[0] = this.pos[chosen][0];
            this.targetAngles[1] = this.pos[chosen][1];
            this.targetAngles[2] = this.pos[chosen][2];
        }

        private boolean move() {
            boolean didMove = false;
            for (int i = 0; i < this.angles.length; ++i) {
                if (this.angles[i] == this.targetAngles[i]) continue;
                didMove = true;
                double angle = this.angles[i];
                double target = this.targetAngles[i];
                double turn = this.speed[i];
                double delta = Math.abs(angle - target);
                if (delta <= turn) {
                    this.angles[i] = this.targetAngles[i];
                    continue;
                }
                if (angle < target) {
                    int n = i;
                    this.angles[n] = this.angles[n] + turn;
                    continue;
                }
                int n = i;
                this.angles[n] = this.angles[n] - turn;
            }
            return !didMove;
        }

        public double[] getPositions(float interp) {
            return new double[]{BobMathUtil.interp(this.prevAngles[0], this.angles[0], interp), BobMathUtil.interp(this.prevAngles[1], this.angles[1], interp), BobMathUtil.interp(this.prevAngles[2], this.angles[2], interp), BobMathUtil.interp(this.prevAngles[3], this.angles[3], interp)};
        }

        public static enum ArmActionState {
            ASSUME_POSITION,
            EXTEND_STRIKER,
            RETRACT_STRIKER;

        }
    }
}

