/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.inventory.container.ContainerMachineGasCent;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineGasCent;
import com.hbm.inventory.recipes.GasCentrifugeRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineGasCent
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiver,
IGUIProvider,
IInfoProviderEC {
    public long power;
    public int progress;
    public boolean isProgressing;
    public static final int maxPower = 100000;
    public static final int processingSpeed = 150;
    public FluidTank tank = new FluidTank(Fluids.UF6, 2000);
    public PseudoFluidTank inputTank = new PseudoFluidTank(GasCentrifugeRecipes.PseudoFluidType.NUF6, 8000);
    public PseudoFluidTank outputTank = new PseudoFluidTank(GasCentrifugeRecipes.PseudoFluidType.LEUF6, 8000);
    private int audioDuration = 0;
    private AudioWrapper audio;
    private static final int[] slots_io = new int[]{0, 1, 2, 3};
    AxisAlignedBB bb = null;

    public TileEntityMachineGasCent() {
        super(7);
    }

    @Override
    public String getName() {
        return "container.gasCentrifuge";
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i < 4;
    }

    @Override
    public int[] func_94128_d(int side) {
        return slots_io;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74765_d("progress");
        this.tank.readFromNBT(nbt, "tank");
        this.inputTank.readFromNBT(nbt, "inputTank");
        this.outputTank.readFromNBT(nbt, "outputTank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74777_a("progress", (short)this.progress);
        this.tank.writeToNBT(nbt, "tank");
        this.inputTank.writeToNBT(nbt, "inputTank");
        this.outputTank.writeToNBT(nbt, "outputTank");
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / this.getProcessingSpeed();
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 100000L;
    }

    private boolean canEnrich() {
        if (this.power > 0L && this.inputTank.getFill() >= this.inputTank.getTankType().getFluidConsumed() && this.outputTank.getFill() + this.inputTank.getTankType().getFluidProduced() <= this.outputTank.getMaxFill()) {
            ItemStack[] list = this.inputTank.getTankType().getOutput();
            if (this.inputTank.getTankType().getIfHighSpeed() && (this.slots[6] == null || this.slots[6].func_77973_b() != ModItems.upgrade_gc_speed)) {
                return false;
            }
            if (list == null) {
                return false;
            }
            if (list.length < 1) {
                return false;
            }
            if (InventoryUtil.doesArrayHaveSpace(this.slots, 0, 3, list)) {
                return true;
            }
        }
        return false;
    }

    private void enrich() {
        ItemStack[] output = this.inputTank.getTankType().getOutput();
        this.progress = 0;
        this.inputTank.setFill(this.inputTank.getFill() - this.inputTank.getTankType().getFluidConsumed());
        this.outputTank.setFill(this.outputTank.getFill() + this.inputTank.getTankType().getFluidProduced());
        for (int i = 0; i < output.length; i = (int)((byte)(i + 1))) {
            InventoryUtil.tryAddItemToInventory(this.slots, 0, 3, output[i].func_77946_l());
        }
    }

    private void attemptConversion() {
        if (this.inputTank.getFill() < this.inputTank.getMaxFill() && this.tank.getFill() > 0) {
            int fill = Math.min(this.inputTank.getMaxFill() - this.inputTank.getFill(), this.tank.getFill());
            this.tank.setFill(this.tank.getFill() - fill);
            this.inputTank.setFill(this.inputTank.getFill() + fill);
        }
    }

    private boolean attemptTransfer(TileEntity te) {
        if (te instanceof TileEntityMachineGasCent) {
            TileEntityMachineGasCent cent = (TileEntityMachineGasCent)te;
            if (cent.tank.getFill() == 0 && cent.tank.getTankType() == this.tank.getTankType()) {
                if (cent.inputTank.getTankType() != this.outputTank.getTankType() && this.outputTank.getTankType() != GasCentrifugeRecipes.PseudoFluidType.NONE) {
                    cent.inputTank.setTankType(this.outputTank.getTankType());
                    cent.outputTank.setTankType(this.outputTank.getTankType().getOutputType());
                }
                if (cent.inputTank.getFill() < cent.inputTank.getMaxFill() && this.outputTank.getFill() > 0) {
                    int fill = Math.min(cent.inputTank.getMaxFill() - cent.inputTank.getFill(), this.outputTank.getFill());
                    this.outputTank.setFill(this.outputTank.getFill() - fill);
                    cent.inputTank.setFill(cent.inputTank.getFill() + fill);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 4, this.power, 100000L);
            this.setTankType(5);
            if (GasCentrifugeRecipes.fluidConversions.containsValue(this.inputTank.getTankType())) {
                this.attemptConversion();
            }
            if (this.canEnrich()) {
                this.isProgressing = true;
                ++this.progress;
                this.power = this.slots[6] != null && this.slots[6].func_77973_b() == ModItems.upgrade_gc_speed ? (this.power -= 300L) : (this.power -= 200L);
                if (this.power < 0L) {
                    this.power = 0L;
                    this.progress = 0;
                }
                if (this.progress >= this.getProcessingSpeed()) {
                    this.enrich();
                }
            } else {
                this.isProgressing = false;
                this.progress = 0;
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ);
                if (!this.attemptTransfer(te) && this.inputTank.getTankType() == GasCentrifugeRecipes.PseudoFluidType.LEUF6) {
                    ItemStack[] converted = new ItemStack[]{new ItemStack(ModItems.nugget_uranium_fuel, 6), new ItemStack(ModItems.fluorite)};
                    if (this.outputTank.getFill() >= 600 && InventoryUtil.doesArrayHaveSpace(this.slots, 0, 3, converted)) {
                        this.outputTank.setFill(this.outputTank.getFill() - 600);
                        for (ItemStack stack : converted) {
                            InventoryUtil.tryAddItemToInventory(this.slots, 0, 3, stack);
                        }
                    }
                }
            }
            this.networkPackNT(50);
        } else {
            this.audioDuration = this.isProgressing ? (this.audioDuration += 2) : (this.audioDuration -= 3);
            this.audioDuration = MathHelper.func_76125_a((int)this.audioDuration, (int)0, (int)60);
            if (this.audioDuration > 10) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updateVolume(this.getVolume(1.0f));
                this.audio.updatePitch((float)(this.audioDuration - 10) / 100.0f + 0.5f);
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.centrifugeOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.progress);
        buf.writeBoolean(this.isProgressing);
        buf.writeInt(this.inputTank.getFill());
        buf.writeInt(this.outputTank.getFill());
        BufferUtil.writeString(buf, this.inputTank.getTankType().name);
        BufferUtil.writeString(buf, this.outputTank.getTankType().name);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.progress = buf.readInt();
        this.isProgressing = buf.readBoolean();
        this.inputTank.setFill(buf.readInt());
        this.outputTank.setFill(buf.readInt());
        this.inputTank.setTankType(GasCentrifugeRecipes.PseudoFluidType.types.get(BufferUtil.readString(buf)));
        this.outputTank.setTankType(GasCentrifugeRecipes.PseudoFluidType.types.get(BufferUtil.readString(buf)));
        this.tank.deserialize(buf);
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            if (!GasCentrifugeRecipes.fluidConversions.containsValue(this.inputTank.getTankType())) continue;
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public int getProcessingSpeed() {
        if (this.slots[6] != null && this.slots[6].func_77973_b() == ModItems.upgrade_gc_speed) {
            return 80;
        }
        return 150;
    }

    public void setTankType(int in) {
        if (this.slots[in] != null && this.slots[in].func_77973_b() instanceof IItemFluidIdentifier) {
            GasCentrifugeRecipes.PseudoFluidType pseudo;
            IItemFluidIdentifier id = (IItemFluidIdentifier)this.slots[in].func_77973_b();
            FluidType newType = id.getType(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots[in]);
            if (this.tank.getTankType() != newType && (pseudo = GasCentrifugeRecipes.fluidConversions.get(newType)) != null) {
                this.inputTank.setTankType(pseudo);
                this.outputTank.setTankType(pseudo.getOutputType());
                this.tank.setTankType(newType);
            }
        }
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineGasCent(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineGasCent(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.progress > 0);
        data.func_74768_a("progress", this.progress);
    }

    public class PseudoFluidTank {
        GasCentrifugeRecipes.PseudoFluidType type;
        int fluid;
        int maxFluid;

        public PseudoFluidTank(GasCentrifugeRecipes.PseudoFluidType type, int maxFluid) {
            this.type = type;
            this.maxFluid = maxFluid;
        }

        public void setFill(int i) {
            this.fluid = i;
        }

        public void setTankType(GasCentrifugeRecipes.PseudoFluidType type) {
            if (this.type.equals(type)) {
                return;
            }
            this.type = type == null ? GasCentrifugeRecipes.PseudoFluidType.NONE : type;
            this.setFill(0);
        }

        public GasCentrifugeRecipes.PseudoFluidType getTankType() {
            return this.type;
        }

        public int getFill() {
            return this.fluid;
        }

        public int getMaxFill() {
            return this.maxFluid;
        }

        public void writeToNBT(NBTTagCompound nbt, String s) {
            nbt.func_74768_a(s, this.fluid);
            nbt.func_74768_a(s + "_max", this.maxFluid);
            nbt.func_74778_a(s + "_type", this.type.name);
        }

        public void readFromNBT(NBTTagCompound nbt, String s) {
            this.fluid = nbt.func_74762_e(s);
            int max = nbt.func_74762_e(s + "_max");
            if (max > 0) {
                this.maxFluid = nbt.func_74762_e(s + "_max");
            }
            this.type = GasCentrifugeRecipes.PseudoFluidType.types.get(nbt.func_74779_i(s + "_type"));
            if (this.type == null) {
                this.type = GasCentrifugeRecipes.PseudoFluidType.NONE;
            }
        }
    }
}

