/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerSILEX;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUISILEX;
import com.hbm.inventory.recipes.SILEXRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFELCrystal;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.WeightedRandomObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySILEX
extends TileEntityMachineBase
implements IFluidStandardReceiver,
IGUIProvider,
IInfoProviderEC {
    public ItemFELCrystal.EnumWavelengths mode = ItemFELCrystal.EnumWavelengths.NULL;
    public boolean hasLaser;
    public FluidTank tank = new FluidTank(Fluids.PEROXIDE, 16000);
    public RecipesCommon.ComparableStack current;
    public int currentFill;
    public static final int maxFill = 16000;
    public int progress;
    public final int processTime = 100;
    public static final HashMap<FluidType, RecipesCommon.ComparableStack> fluidConversion = new HashMap();
    int loadDelay;
    public static final int PRIME = 137;
    public int recipeIndex = 0;

    public TileEntitySILEX() {
        super(11);
    }

    @Override
    public String getName() {
        return "container.machineSILEX";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.setType(1, 1, this.slots);
            this.tank.loadTank(2, 3, this.slots);
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 2, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ * 2, dir);
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c - dir.offsetX * 2, this.field_145848_d + 1, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite());
            this.loadFluid();
            if (!this.process()) {
                this.progress = 0;
            }
            this.dequeue();
            if (this.currentFill <= 0) {
                this.current = null;
            }
            this.networkPackNT(50);
            this.mode = ItemFELCrystal.EnumWavelengths.NULL;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.currentFill);
        buf.writeInt(this.progress);
        BufferUtil.writeString(buf, this.mode.toString());
        this.tank.serialize(buf);
        if (this.current != null) {
            buf.writeInt(Item.func_150891_b((Item)this.current.item));
            buf.writeInt(this.current.meta);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.currentFill = buf.readInt();
        this.progress = buf.readInt();
        this.mode = ItemFELCrystal.EnumWavelengths.valueOf(BufferUtil.readString(buf));
        this.tank.deserialize(buf);
        this.current = this.currentFill > 0 ? new RecipesCommon.ComparableStack(Item.func_150899_d((int)buf.readInt()), 1, buf.readInt()) : null;
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        this.currentFill = 0;
        this.current = null;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public int getFluidScaled(int i) {
        return this.tank.getFill() * i / this.tank.getMaxFill();
    }

    public int getFillScaled(int i) {
        return this.currentFill * i / 16000;
    }

    private static void putFluid(FluidType fluid) {
        fluidConversion.put(fluid, new RecipesCommon.ComparableStack(ModItems.fluid_icon, 1, fluid.getID()));
    }

    public void loadFluid() {
        RecipesCommon.ComparableStack conv = fluidConversion.get(this.tank.getTankType());
        if (conv != null) {
            if (this.currentFill == 0) {
                this.current = (RecipesCommon.ComparableStack)conv.copy();
            }
            if (this.current != null && this.current.equals(conv)) {
                int toFill = Math.min(50, Math.min(16000 - this.currentFill, this.tank.getFill()));
                this.currentFill += toFill;
                this.tank.setFill(this.tank.getFill() - toFill);
            }
        } else {
            RecipesCommon.ComparableStack direct = new RecipesCommon.ComparableStack(ModItems.fluid_icon, 1, this.tank.getTankType().getID());
            if (SILEXRecipes.getOutput(direct.toStack()) != null) {
                if (this.currentFill == 0) {
                    this.current = (RecipesCommon.ComparableStack)direct.copy();
                }
                if (this.current != null && this.current.equals(direct)) {
                    int toFill = Math.min(50, Math.min(16000 - this.currentFill, this.tank.getFill()));
                    this.currentFill += toFill;
                    this.tank.setFill(this.tank.getFill() - toFill);
                }
            }
        }
        ++this.loadDelay;
        if (this.loadDelay > 20) {
            this.loadDelay = 0;
        }
        if (this.loadDelay == 0 && this.slots[0] != null && this.tank.getTankType() == Fluids.PEROXIDE && (this.current == null || this.current.equals(new RecipesCommon.ComparableStack(this.slots[0]).makeSingular()))) {
            SILEXRecipes.SILEXRecipe recipe = SILEXRecipes.getOutput(this.slots[0]);
            if (recipe == null) {
                return;
            }
            int load = recipe.fluidProduced;
            if (load <= 16000 - this.currentFill && load <= this.tank.getFill()) {
                this.currentFill += load;
                this.current = new RecipesCommon.ComparableStack(this.slots[0]).makeSingular();
                this.tank.setFill(this.tank.getFill() - load);
                this.func_70298_a(0, 1);
            }
        }
    }

    private boolean process() {
        if (this.current == null || this.currentFill <= 0) {
            return false;
        }
        SILEXRecipes.SILEXRecipe recipe = SILEXRecipes.getOutput(this.current.toStack());
        if (recipe == null) {
            return false;
        }
        if (recipe.laserStrength.ordinal() > this.mode.ordinal()) {
            return false;
        }
        if (this.currentFill < recipe.fluidConsumed) {
            return false;
        }
        if (this.slots[4] != null) {
            return false;
        }
        int progressSpeed = (int)Math.pow(2.0, this.mode.ordinal() - recipe.laserStrength.ordinal() + 1) / 2;
        this.progress += progressSpeed;
        if (this.progress >= 100) {
            this.currentFill -= recipe.fluidConsumed;
            int totalWeight = 0;
            for (WeightedRandomObject weighted : recipe.outputs) {
                totalWeight += weighted.field_76292_a;
            }
            this.recipeIndex %= Math.max(totalWeight, 1);
            int weight = 0;
            for (WeightedRandomObject weighted : recipe.outputs) {
                if (this.recipeIndex >= (weight += weighted.field_76292_a)) continue;
                this.slots[4] = weighted.asStack().func_77946_l();
                break;
            }
            this.progress = 0;
            this.func_70296_d();
            this.recipeIndex += 137;
        }
        return true;
    }

    private void dequeue() {
        if (this.slots[4] != null) {
            int i;
            for (i = 5; i < 11; ++i) {
                if (this.slots[i] == null || this.slots[i].field_77994_a >= this.slots[i].func_77976_d() || !InventoryUtil.doesStackDataMatch(this.slots[4], this.slots[i])) continue;
                ++this.slots[i].field_77994_a;
                this.func_70298_a(4, 1);
                return;
            }
            for (i = 5; i < 11; ++i) {
                if (this.slots[i] != null) continue;
                this.slots[i] = this.slots[4].func_77946_l();
                this.slots[4] = null;
                return;
            }
        }
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 5, 6, 7, 8, 9, 10};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0) {
            return SILEXRecipes.getOutput(itemStack) != null;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot >= 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "tank");
        this.currentFill = nbt.func_74762_e("fill");
        this.recipeIndex = nbt.func_74762_e("recipeIndex");
        this.mode = ItemFELCrystal.EnumWavelengths.valueOf(nbt.func_74779_i("mode"));
        if (this.currentFill > 0) {
            this.current = new RecipesCommon.ComparableStack(Item.func_150899_d((int)nbt.func_74762_e("item")), 1, nbt.func_74762_e("meta"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74768_a("fill", this.currentFill);
        nbt.func_74768_a("recipeIndex", this.recipeIndex);
        nbt.func_74778_a("mode", this.mode.toString());
        if (this.current != null) {
            nbt.func_74768_a("item", Item.func_150891_b((Item)this.current.item));
            nbt.func_74768_a("meta", this.current.meta);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerSILEX(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUISILEX(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.progress > 0);
        if (this.current == null) {
            data.func_74778_a("tank2", "N/A");
        } else {
            data.func_74778_a("tank2", String.format("%s: %s mB", this.current.toStack().func_82833_r(), this.currentFill));
        }
    }

    static {
        TileEntitySILEX.putFluid(Fluids.UF6);
        TileEntitySILEX.putFluid(Fluids.PUF6);
        TileEntitySILEX.putFluid(Fluids.DEATH);
    }
}

