/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerRBMKControlAuto;
import com.hbm.inventory.gui.GUIRBMKControlAuto;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControl;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControlManual;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityRBMKControlAuto
extends TileEntityRBMKControl
implements IControlReceiver {
    public RBMKFunction function = RBMKFunction.LINEAR;
    public double levelLower;
    public double levelUpper;
    public double heatLower;
    public double heatUpper;

    @Override
    public String getName() {
        return "container.rbmkControlAuto";
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            double fauxLevel = 0.0;
            double lowerBound = Math.min(this.heatLower, this.heatUpper);
            double upperBound = Math.max(this.heatLower, this.heatUpper);
            if (this.heat < lowerBound) {
                fauxLevel = this.levelLower;
            } else if (this.heat > upperBound) {
                fauxLevel = this.levelUpper;
            } else {
                switch (this.function) {
                    case LINEAR: {
                        fauxLevel = (this.heat - this.heatLower) * ((this.levelUpper - this.levelLower) / (this.heatUpper - this.heatLower)) + this.levelLower;
                        break;
                    }
                    case QUAD_UP: {
                        fauxLevel = Math.pow((this.heat - this.heatLower) / (this.heatUpper - this.heatLower), 2.0) * (this.levelUpper - this.levelLower) + this.levelLower;
                        break;
                    }
                    case QUAD_DOWN: {
                        fauxLevel = Math.pow((this.heat - this.heatUpper) / (this.heatLower - this.heatUpper), 2.0) * (this.levelLower - this.levelUpper) + this.levelUpper;
                    }
                }
            }
            this.targetLevel = fauxLevel * 0.01;
            this.targetLevel = MathHelper.func_151237_a((double)this.targetLevel, (double)0.0, (double)1.0);
        }
        super.func_145845_h();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.levelLower = nbt.func_74769_h("levelLower");
        this.levelUpper = nbt.func_74769_h("levelUpper");
        this.heatLower = nbt.func_74769_h("heatLower");
        this.heatUpper = nbt.func_74769_h("heatUpper");
        this.function = nbt.func_74764_b("function") ? RBMKFunction.values()[nbt.func_74762_e("function")] : null;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("levelLower", this.levelLower);
        nbt.func_74780_a("levelUpper", this.levelUpper);
        nbt.func_74780_a("heatLower", this.heatLower);
        nbt.func_74780_a("heatUpper", this.heatUpper);
        if (this.function != null) {
            nbt.func_74768_a("function", this.function.ordinal());
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.levelLower);
        buf.writeDouble(this.levelUpper);
        buf.writeDouble(this.heatLower);
        buf.writeDouble(this.heatUpper);
        if (this.function != null) {
            buf.writeInt(this.function.ordinal());
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.levelLower = buf.readDouble();
        this.levelUpper = buf.readDouble();
        this.heatLower = buf.readDouble();
        this.heatUpper = buf.readDouble();
        this.function = RBMKFunction.values()[buf.readInt()];
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("function")) {
            int c = Math.abs(data.func_74762_e("function")) % TileEntityRBMKControlManual.RBMKColor.values().length;
            this.function = RBMKFunction.values()[c];
        } else {
            this.levelLower = data.func_74769_h("levelLower");
            this.levelUpper = data.func_74769_h("levelUpper");
            this.heatLower = data.func_74769_h("heatLower");
            this.heatUpper = data.func_74769_h("heatUpper");
        }
        this.func_70296_d();
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.CONTROL_AUTO;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKControlAuto(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKControlAuto(player.field_71071_by, this);
    }

    public static enum RBMKFunction {
        LINEAR,
        QUAD_UP,
        QUAD_DOWN;

    }
}

