/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.tileentity.IRadarCommandReceiver;
import com.hbm.tileentity.turret.TileEntityTurretBaseNT;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityTurretBaseArtillery
extends TileEntityTurretBaseNT
implements IRadarCommandReceiver {
    protected List<Vec3> targetQueue = new ArrayList<Vec3>();

    @Override
    public boolean sendCommandPosition(int x, int y, int z) {
        this.enqueueTarget((double)x + 0.5, y, (double)z + 0.5);
        return true;
    }

    @Override
    public boolean sendCommandEntity(Entity target) {
        this.enqueueTarget(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        return true;
    }

    public void enqueueTarget(double x, double y, double z) {
        Vec3 pos = this.getTurretPos();
        Vec3 delta = Vec3.func_72443_a((double)(x - pos.field_72450_a), (double)(y - pos.field_72448_b), (double)(z - pos.field_72449_c));
        if (delta.func_72433_c() <= this.getDecetorRange()) {
            this.targetQueue.add(Vec3.func_72443_a((double)x, (double)y, (double)z));
        }
    }

    public abstract boolean doLOSCheck();

    @Override
    public boolean entityInLOS(Entity e) {
        if (this.doLOSCheck()) {
            return super.entityInLOS(e);
        }
        Vec3 pos = this.getTurretPos();
        Vec3 ent = this.getEntityPos(e);
        Vec3 delta = Vec3.func_72443_a((double)(ent.field_72450_a - pos.field_72450_a), (double)(ent.field_72448_b - pos.field_72448_b), (double)(ent.field_72449_c - pos.field_72449_c));
        double length = delta.func_72433_c();
        if (length < this.getDecetorGrace() || length > this.getDecetorRange() * 1.1) {
            return false;
        }
        int height = this.field_145850_b.func_72976_f((int)Math.floor(e.field_70165_t), (int)Math.floor(e.field_70161_v));
        return (double)height < e.field_70163_u + (double)e.field_70131_O;
    }

    @Override
    protected void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * (-1 + j) + rot.offsetX * -3, this.field_145848_d + i, this.field_145849_e + dir.offsetZ * (-1 + j) + rot.offsetZ * -3, ForgeDirection.SOUTH);
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * (-1 + j) + rot.offsetX * 2, this.field_145848_d + i, this.field_145849_e + dir.offsetZ * (-1 + j) + rot.offsetZ * 2, ForgeDirection.NORTH);
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * -2 + rot.offsetX * (1 - j), this.field_145848_d + i, this.field_145849_e + dir.offsetZ * -2 + rot.offsetZ * (1 - j), ForgeDirection.EAST);
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 3 + rot.offsetX * (1 - j), this.field_145848_d + i, this.field_145849_e + dir.offsetZ * 3 + rot.offsetZ * (1 - j), ForgeDirection.WEST);
            }
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_artillery";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCurrentTarget(Context context, Arguments args) {
        return new Object[]{this.targetQueue.get((int)0).field_72450_a, this.targetQueue.get((int)0).field_72448_b, this.targetQueue.get((int)0).field_72449_c};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTargetDistance(Context context, Arguments args) {
        return new Object[]{Math.sqrt(Math.pow((double)this.field_145851_c - args.checkDouble(0), 2.0) + Math.pow((double)this.field_145848_d - args.checkDouble(1), 2.0) + Math.pow((double)this.field_145849_e - args.checkDouble(2), 2.0))};
    }
}

