/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.entity.mob.ai.EntityAIFireGun;
import com.hbm.items.ModItems;
import com.hbm.util.ArmorUtil;
import com.hbm.util.WeightedRandomObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class MobUtil {
    public static Map<Integer, List<WeightedRandomObject>> slotPoolCommon = new HashMap<Integer, List<WeightedRandomObject>>();
    public static Map<Integer, List<WeightedRandomObject>> slotPoolRanged = new HashMap<Integer, List<WeightedRandomObject>>();
    public static Map<Integer, List<WeightedRandomObject>> slotPoolAdv = new HashMap<Integer, List<WeightedRandomObject>>();
    public static Map<Integer, List<WeightedRandomObject>> slotPoolAdvRanged;
    public static HashMap<Double, List<WeightedRandomObject>> slotPoolGuns;

    public static void intializeMobPools() {
        slotPoolCommon.put(4, MobUtil.createSlotPool(8000, new Object[][]{{ModItems.gas_mask_m65, 16}, {ModItems.gas_mask_olde, 12}, {ModItems.mask_of_infamy, 8}, {ModItems.gas_mask_mono, 8}, {ModItems.robes_helmet, 32}, {ModItems.no9, 16}, {ModItems.cobalt_helmet, 2}, {ModItems.rag_piss, 1}, {ModItems.hat, 1}, {ModItems.alloy_helmet, 2}, {ModItems.titanium_helmet, 4}, {ModItems.steel_helmet, 8}}));
        slotPoolCommon.put(3, MobUtil.createSlotPool(7000, new Object[][]{{ModItems.starmetal_plate, 1}, {ModItems.cobalt_plate, 2}, {ModItems.robes_plate, 32}, {ModItems.jackt, 32}, {ModItems.jackt2, 32}, {ModItems.alloy_plate, 2}, {ModItems.steel_plate, 2}}));
        slotPoolCommon.put(2, MobUtil.createSlotPool(7000, new Object[][]{{ModItems.zirconium_legs, 1}, {ModItems.cobalt_legs, 2}, {ModItems.steel_legs, 16}, {ModItems.titanium_legs, 8}, {ModItems.robes_legs, 32}, {ModItems.alloy_legs, 2}}));
        slotPoolCommon.put(1, MobUtil.createSlotPool(7000, new Object[][]{{ModItems.robes_boots, 32}, {ModItems.steel_boots, 16}, {ModItems.cobalt_boots, 2}, {ModItems.alloy_boots, 2}}));
        slotPoolCommon.put(0, MobUtil.createSlotPool(10000, new Object[][]{{ModItems.pipe_lead, 30}, {ModItems.crowbar, 25}, {ModItems.geiger_counter, 20}, {ModItems.reer_graar, 16}, {ModItems.steel_pickaxe, 12}, {ModItems.stopsign, 10}, {ModItems.sopsign, 8}, {ModItems.chernobylsign, 6}, {ModItems.steel_sword, 15}, {ModItems.titanium_sword, 8}, {ModItems.lead_gavel, 4}, {ModItems.wrench_flipped, 2}, {ModItems.wrench, 20}}));
        slotPoolRanged.put(4, MobUtil.createSlotPool(12000, new Object[][]{{ModItems.gas_mask_m65, 16}, {ModItems.gas_mask_olde, 12}, {ModItems.mask_of_infamy, 8}, {ModItems.gas_mask_mono, 8}, {ModItems.robes_helmet, 32}, {ModItems.no9, 16}, {ModItems.rag_piss, 1}, {ModItems.goggles, 1}, {ModItems.alloy_helmet, 2}, {ModItems.titanium_helmet, 4}, {ModItems.steel_helmet, 8}}));
        slotPoolRanged.put(3, MobUtil.createSlotPool(10000, new Object[][]{{ModItems.starmetal_plate, 1}, {ModItems.cobalt_plate, 2}, {ModItems.alloy_plate, 2}, {ModItems.steel_plate, 8}, {ModItems.titanium_plate, 4}}));
        slotPoolRanged.put(2, MobUtil.createSlotPool(10000, new Object[][]{{ModItems.zirconium_legs, 1}, {ModItems.cobalt_legs, 2}, {ModItems.steel_legs, 16}, {ModItems.titanium_legs, 8}, {ModItems.robes_legs, 32}, {ModItems.alloy_legs, 2}}));
        slotPoolRanged.put(1, MobUtil.createSlotPool(10000, new Object[][]{{ModItems.robes_boots, 32}, {ModItems.steel_boots, 16}, {ModItems.cobalt_boots, 2}, {ModItems.alloy_boots, 2}, {ModItems.titanium_boots, 6}}));
        slotPoolGuns.put(0.3, MobUtil.createSlotPool(new Object[][]{{ModItems.gun_light_revolver, 16}, {ModItems.gun_greasegun, 8}, {ModItems.gun_maresleg, 2}}));
        slotPoolGuns.put(1.0, MobUtil.createSlotPool(new Object[][]{{ModItems.gun_light_revolver, 6}, {ModItems.gun_greasegun, 8}, {ModItems.gun_maresleg, 4}, {ModItems.gun_henry, 6}}));
        slotPoolGuns.put(3.0, MobUtil.createSlotPool(new Object[][]{{ModItems.gun_uzi, 10}, {ModItems.gun_maresleg, 8}, {ModItems.gun_henry, 12}, {ModItems.gun_heavy_revolver, 4}, {ModItems.gun_flaregun, 2}}));
        slotPoolGuns.put(5.0, MobUtil.createSlotPool(new Object[][]{{ModItems.gun_am180, 6}, {ModItems.gun_uzi, 10}, {ModItems.gun_spas12, 8}, {ModItems.gun_henry_lincoln, 2}, {ModItems.gun_heavy_revolver, 12}, {ModItems.gun_flaregun, 4}, {ModItems.gun_flamer, 2}}));
        slotPoolAdv.put(4, MobUtil.createSlotPool(new Object[][]{{ModItems.security_helmet, 10}, {ModItems.t45_helmet, 4}, {ModItems.asbestos_helmet, 12}, {ModItems.liquidator_helmet, 4}, {ModItems.no9, 12}, {ModItems.hazmat_helmet, 6}}));
        slotPoolAdv.put(3, MobUtil.createSlotPool(new Object[][]{{ModItems.liquidator_plate, 4}, {ModItems.security_plate, 8}, {ModItems.asbestos_plate, 12}, {ModItems.t45_plate, 4}, {ModItems.hazmat_plate, 6}, {ModItems.steel_plate, 8}}));
        slotPoolAdv.put(2, MobUtil.createSlotPool(new Object[][]{{ModItems.liquidator_legs, 4}, {ModItems.security_legs, 8}, {ModItems.asbestos_legs, 12}, {ModItems.t45_legs, 4}, {ModItems.hazmat_legs, 6}, {ModItems.steel_legs, 8}}));
        slotPoolAdv.put(1, MobUtil.createSlotPool(new Object[][]{{ModItems.liquidator_boots, 4}, {ModItems.security_boots, 8}, {ModItems.asbestos_boots, 12}, {ModItems.t45_boots, 4}, {ModItems.hazmat_boots, 6}, {ModItems.robes_boots, 8}}));
        slotPoolAdv.put(0, MobUtil.createSlotPool(new Object[][]{{ModItems.pipe_lead, 20}, {ModItems.crowbar, 30}, {ModItems.geiger_counter, 20}, {ModItems.reer_graar, 20}, {ModItems.wrench_flipped, 12}, {ModItems.stopsign, 16}, {ModItems.sopsign, 4}, {ModItems.chernobylsign, 16}, {ModItems.titanium_sword, 18}, {ModItems.lead_gavel, 8}, {ModItems.wrench, 20}}));
        slotPoolAdvRanged = new HashMap<Integer, List<WeightedRandomObject>>(slotPoolAdv);
        slotPoolAdvRanged.remove(0);
    }

    public static List<WeightedRandomObject> createSlotPool(int nullWeight, Object[][] items) {
        ArrayList<WeightedRandomObject> pool = new ArrayList<WeightedRandomObject>();
        pool.add(new WeightedRandomObject(null, nullWeight));
        for (Object[] item : items) {
            Object obj = item[0];
            int weight = (Integer)item[1];
            if (obj instanceof Item) {
                pool.add(new WeightedRandomObject(new ItemStack((Item)obj), weight));
                continue;
            }
            if (!(obj instanceof ItemStack)) continue;
            pool.add(new WeightedRandomObject(obj, weight));
        }
        return pool;
    }

    public static List<WeightedRandomObject> createSlotPool(Object[][] items) {
        ArrayList<WeightedRandomObject> pool = new ArrayList<WeightedRandomObject>();
        for (Object[] item : items) {
            Object obj = item[0];
            int weight = (Integer)item[1];
            if (obj instanceof Item) {
                pool.add(new WeightedRandomObject(new ItemStack((Item)obj), weight));
                continue;
            }
            if (!(obj instanceof ItemStack)) continue;
            pool.add(new WeightedRandomObject(obj, weight));
        }
        return pool;
    }

    public static void equipFullSet(EntityLivingBase entity, Item helmet, Item chest, Item legs, Item boots) {
        entity.func_70062_b(4, new ItemStack(helmet));
        entity.func_70062_b(3, new ItemStack(chest));
        entity.func_70062_b(2, new ItemStack(legs));
        entity.func_70062_b(1, new ItemStack(boots));
    }

    public static void assignItemsToEntity(EntityLivingBase entity, Map<Integer, List<WeightedRandomObject>> slotPools, Random rand) {
        for (Map.Entry<Integer, List<WeightedRandomObject>> entry : slotPools.entrySet()) {
            ItemStack stack;
            int slot = entry.getKey();
            List<WeightedRandomObject> pool = entry.getValue();
            WeightedRandomObject choice = (WeightedRandomObject)WeightedRandom.func_76271_a((Random)rand, pool);
            if (choice == null || (stack = choice.asStack()) == null || stack.func_77973_b() == null) continue;
            if (stack.func_77973_b() == ModItems.gas_mask_m65 || stack.func_77973_b() == ModItems.gas_mask_olde || stack.func_77973_b() == ModItems.gas_mask_mono) {
                ArmorUtil.installGasMaskFilter(stack, new ItemStack(ModItems.gas_mask_filter));
            }
            entity.func_70062_b(slot, stack);
            if (slot != 0 || !(entity instanceof EntitySkeleton) || pool != slotPools.get(0)) continue;
            MobUtil.addFireTask((EntityLiving)entity);
        }
    }

    public static void addFireTask(EntityLiving entity) {
        entity.func_96120_a(0, 0.0f);
        for (Object entry : entity.field_70714_bg.field_75782_a) {
            EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)entry;
            if (!(task.field_75733_a instanceof EntityAIFireGun)) continue;
            return;
        }
        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFireGun(entity));
    }

    static {
        slotPoolGuns = new HashMap();
    }
}

