/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.util;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockSkeletonHolder;
import com.hbm.blocks.generic.LogicBlock;
import com.hbm.entity.item.EntityFallingBlockNT;
import com.hbm.entity.missile.EntityMissileTier2;
import com.hbm.entity.mob.EntityUndeadSoldier;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.tileentity.TileEntityDoorGeneric;
import com.hbm.tileentity.machine.storage.TileEntityCrateBase;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.MobUtil;
import com.hbm.util.Vec3NT;
import com.hbm.world.WorldUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LogicBlockActions {
    public static LinkedHashMap<String, Consumer<LogicBlock.TileEntityLogicBlock>> actions = new LinkedHashMap();
    public static Consumer<LogicBlock.TileEntityLogicBlock> PHASE_ABERRATOR = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase == 1 || tile.phase == 2) {
            tile.player = world.func_72977_a((double)x, (double)y, (double)z, 25.0);
            if (tile.timer == 0) {
                Vec3NT vec = new Vec3NT(20.0, 0.0, 0.0);
                for (int i = 0; i < 10; ++i) {
                    if (vec.field_72450_a > 8.0) {
                        vec.field_72450_a += (double)(world.field_73012_v.nextInt(10) - 5);
                    }
                    EntityUndeadSoldier mob = new EntityUndeadSoldier(world);
                    for (int j = 0; j < 7; ++j) {
                        mob.func_70080_a((double)x + 0.5 + vec.field_72450_a, world.func_72976_f((int)((double)x + 0.5 + vec.field_72450_a), (int)((double)z + 0.5 + vec.field_72449_c)), (double)z + 0.5 + vec.field_72449_c, (float)i * 36.0f, 0.0f);
                        if (!mob.func_70601_bi()) continue;
                        mob.func_110161_a(null);
                        if (tile.player != null) {
                            mob.func_70784_b((Entity)tile.player);
                        }
                        world.func_72838_d((Entity)mob);
                        break;
                    }
                    vec.rotateAroundYDeg(36.0);
                }
            }
        }
        if (tile.phase > 2) {
            TileEntity te = world.func_147438_o(x, y + 18, z);
            if (te instanceof BlockSkeletonHolder.TileEntitySkeletonHolder) {
                BlockSkeletonHolder.TileEntitySkeletonHolder skeleton = (BlockSkeletonHolder.TileEntitySkeletonHolder)te;
                skeleton.item = world.field_73012_v.nextInt(5) == 0 ? new ItemStack(ModItems.item_secret, 1, ItemEnums.EnumSecretType.ABERRATOR.ordinal()) : new ItemStack(ModItems.clay_tablet, 1, 1);
                skeleton.func_70296_d();
                world.func_147471_g(x, y + 18, z);
            }
            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
        }
    };
    public static Consumer<LogicBlock.TileEntityLogicBlock> COLLAPSE_ROOF_RAD_5 = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase == 0) {
            return;
        }
        int r = 4;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || !(world.func_147439_a(X, Y, Z).func_149638_a(null) <= 70.0f)) continue;
                    EntityFallingBlockNT entityfallingblock = new EntityFallingBlockNT(world, (double)X + 0.5, (double)Y + 0.5, (double)Z + 0.5, world.func_147439_a(X, Y, Z), world.func_72805_g(X, Y, Z));
                    world.func_72838_d((Entity)entityfallingblock);
                }
            }
        }
        world.func_147449_b(x, y, z, ModBlocks.block_steel);
    };
    public static Consumer<LogicBlock.TileEntityLogicBlock> FODDER_WAVE = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase == 1) {
            Vec3NT vec = new Vec3NT(5.0, 0.0, 0.0);
            for (int i = 0; i < 10; ++i) {
                EntityZombie mob = new EntityZombie(world);
                mob.func_70080_a((double)x + 0.5 + vec.field_72450_a, (double)world.func_72976_f(x, z), (double)z + 0.5 + vec.field_72449_c, (float)i * 36.0f, 0.0f);
                MobUtil.assignItemsToEntity((EntityLivingBase)mob, MobUtil.slotPoolAdv, new Random());
                world.func_72838_d((Entity)mob);
                vec.rotateAroundYDeg(36.0);
            }
            world.func_147449_b(x, y, z, ModBlocks.block_steel);
        }
    };
    public static Consumer<LogicBlock.TileEntityLogicBlock> PUZZLE_TEST = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase == 2) {
            world.func_147449_b(x, y, z, ModBlocks.crate_steel);
            EntityLightningBolt blitz = new EntityLightningBolt(world, (double)x, (double)(world.func_72976_f(x, z) + 2), (double)z);
            world.func_72838_d((Entity)blitz);
            TileEntityCrateBase crate = (TileEntityCrateBase)world.func_147438_o(x, y, z);
            crate.func_70299_a(15, new ItemStack(ModItems.gun_bolter));
        }
    };
    public static Consumer<LogicBlock.TileEntityLogicBlock> MISSILE_STRIKE = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase != 1) {
            return;
        }
        world.func_72977_a((double)x, (double)y, (double)z, 25.0).func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.LIGHT_PURPLE + "[COMMAND UNIT]" + EnumChatFormatting.RESET + " Missile Fired"));
        ForgeDirection parallel = tile.direction.getRotation(ForgeDirection.UP);
        EntityMissileTier2.EntityMissileStrong missile = new EntityMissileTier2.EntityMissileStrong(world, x + tile.direction.offsetX * 300, 200.0f, z + tile.direction.offsetZ * 300, x + parallel.offsetX * 30 + tile.direction.offsetX * 30, z + parallel.offsetZ * 30 + tile.direction.offsetZ * 30);
        WorldUtil.loadAndSpawnEntityInWorld(missile);
        world.func_147449_b(x, y, z, ModBlocks.block_electrical_scrap);
    };
    public static Consumer<LogicBlock.TileEntityLogicBlock> RAD_CONTAINMENT_SYSTEM = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        ForgeDirection direction = tile.direction.getOpposite();
        ForgeDirection rot = direction.getRotation(ForgeDirection.UP);
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(x - rot.offsetX), (double)(y - 1), (double)(z - rot.offsetZ), (double)(x + rot.offsetX + direction.offsetX * 15), (double)(y + 1), (double)(z + rot.offsetZ + direction.offsetZ * 15)).func_72314_b(2.0, 2.0, 2.0);
        List entities = world.func_72872_a(EntityLivingBase.class, bb);
        for (EntityLivingBase e : entities) {
            Vec3 vec = Vec3.func_72443_a((double)(e.field_70165_t - ((double)x + 0.5)), (double)(e.field_70163_u + (double)e.func_70047_e() - ((double)y + 0.5)), (double)(e.field_70161_v - ((double)z + 0.5)));
            double len = vec.func_72433_c();
            vec = vec.func_72432_b();
            len = Math.max(len, 1.0);
            float res = 0.0f;
            int i = 1;
            while ((double)i < len) {
                int ix = (int)Math.floor((double)x + 0.5 + vec.field_72450_a * (double)i);
                int iy = (int)Math.floor((double)y + 0.5 + vec.field_72448_b * (double)i);
                int iz = (int)Math.floor((double)z + 0.5 + vec.field_72449_c * (double)i);
                res += world.func_147439_a(ix, iy, iz).func_149638_a(null);
                ++i;
            }
            if (res < 1.0f) {
                res = 1.0f;
            }
            float eRads = 100.0f;
            eRads /= res;
            ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.HAZMAT2, eRads /= (float)(len * len));
        }
        if (tile.phase == 2 && tile.timer > 40) {
            world.func_72977_a((double)x, (double)y, (double)z, 25.0).func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.LIGHT_PURPLE + "[RAD CONTAINMENT SYSTEM]" + EnumChatFormatting.RESET + " Diagnostics found containment failure, commencing lockdown"));
            for (int i = 1; i < 20; ++i) {
                int checkX = x + direction.offsetX * i;
                int checkY = y + 1;
                int checkZ = z + direction.offsetZ * i;
                Block block = world.func_147439_a(checkX, checkY, checkZ);
                TileEntity te = null;
                if (block instanceof BlockDummyable) {
                    int[] coreCoords = ((BlockDummyable)block).findCore(world, checkX, checkY, checkZ);
                    te = world.func_147438_o(coreCoords[0], coreCoords[1], coreCoords[2]);
                }
                if (!(te instanceof TileEntityDoorGeneric)) continue;
                TileEntityDoorGeneric door = (TileEntityDoorGeneric)te;
                door.setPins(456);
                if (door.state != 0) {
                    door.tryToggle(456);
                }
                door.lock();
                break;
            }
            tile.phase = 3;
        }
    };

    public static List<String> getActionNames() {
        return new ArrayList<String>(actions.keySet());
    }

    static {
        actions.put("FODDER_WAVE", FODDER_WAVE);
        actions.put("ABERRATOR", PHASE_ABERRATOR);
        actions.put("COLLAPSE_ROOF_RAD_5", COLLAPSE_ROOF_RAD_5);
        actions.put("PUZZLE_TEST", PUZZLE_TEST);
        actions.put("MISSILE_STRIKE", MISSILE_STRIKE);
        actions.put("IRRADIATE_ENTITIES_AOE", RAD_CONTAINMENT_SYSTEM);
    }
}

