/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.util;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockPedestal;
import com.hbm.blocks.generic.LogicBlock;
import com.hbm.entity.mob.EntityUndeadSoldier;
import com.hbm.items.ModItems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class LogicBlockConditions {
    public static LinkedHashMap<String, Function<LogicBlock.TileEntityLogicBlock, Boolean>> conditions = new LinkedHashMap();
    public static Function<LogicBlock.TileEntityLogicBlock, Boolean> EMPTY = tile -> false;
    public static Function<LogicBlock.TileEntityLogicBlock, Boolean> ABERRATOR = tile -> {
        boolean aoeCheck;
        World world = tile.func_145831_w();
        if (world.field_73013_u.ordinal() == 0) {
            return false;
        }
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        boolean bl = aoeCheck = !world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y - 2), (double)(z + 1)).func_72314_b(10.0, 10.0, 10.0)).isEmpty();
        if (tile.phase == 0) {
            if (world.func_82737_E() % 20L != 0L) {
                return false;
            }
            return aoeCheck;
        }
        if (tile.phase < 3) {
            if (world.func_82737_E() % 20L != 0L || tile.timer < 60) {
                return false;
            }
            return world.func_72872_a(EntityUndeadSoldier.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x - 2), (double)(y + 1), (double)(z + 1)).func_72314_b(50.0, 20.0, 50.0)).isEmpty() && aoeCheck;
        }
        return false;
    };
    public static Function<LogicBlock.TileEntityLogicBlock, Boolean> PLAYER_CUBE_5 = tile -> {
        int z;
        int y;
        int x;
        World world = tile.func_145831_w();
        return !world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(x = tile.field_145851_c), (double)(y = tile.field_145848_d), (double)(z = tile.field_145849_e), (double)(x + 1), (double)(y - 2), (double)(z + 1)).func_72314_b(5.0, 5.0, 5.0)).isEmpty();
    };
    public static Function<LogicBlock.TileEntityLogicBlock, Boolean> REDSTONE = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        return world.func_72864_z(x, y, z);
    };
    public static Function<LogicBlock.TileEntityLogicBlock, Boolean> PUZZLE_TEST = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase == 0 && world.func_72864_z(x, y, z)) {
            world.func_72977_a((double)x, (double)y, (double)z, 25.0).func_145747_a((IChatComponent)new ChatComponentText("Find a " + EnumChatFormatting.GOLD + "great" + EnumChatFormatting.RESET + " ancient weapon, of questionable use in the modern age"));
            world.func_147449_b(x, y + 1, z, ModBlocks.pedestal);
            return true;
        }
        TileEntity pedestal = world.func_147438_o(x, y + 1, z);
        return tile.phase == 1 && pedestal instanceof BlockPedestal.TileEntityPedestal && ((BlockPedestal.TileEntityPedestal)pedestal).item != null && ((BlockPedestal.TileEntityPedestal)pedestal).item.func_77973_b() == ModItems.big_sword;
    };

    public static List<String> getConditionNames() {
        return new ArrayList<String>(conditions.keySet());
    }

    static {
        conditions.put("EMPTY", EMPTY);
        conditions.put("ABERRATOR", ABERRATOR);
        conditions.put("PLAYER_CUBE_5", PLAYER_CUBE_5);
        conditions.put("REDSTONE", REDSTONE);
        conditions.put("PUZZLE_TEST", PUZZLE_TEST);
    }
}

