/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization;

import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.reflection.Comment;
import net.blay09.mods.balm.api.config.reflection.Config;
import net.blay09.mods.balm.api.config.reflection.NestedType;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Config(value="fertilization")
public class FertilizationConfig {
    @Comment(value="Set to true if compressed bone meal drops should go straight into the player's inventory.")
    public boolean addDropsDirectlyToInventory = false;
    @Comment(value="Set to true if compressed bone meal drops should go straight into the machine's inventory when used automatically.")
    public boolean addDropsDirectlyToInventoryForFakePlayers = true;
    @Comment(value="This enables use of extremely compressed bone meal to turn saplings into large fancy trees.")
    public boolean allowBoneMealOnSaplings = true;
    @Comment(value="This enables use of normal Bone Meal on vines in order to grow them downwards.")
    public boolean allowBoneMealOnVines = true;
    @Comment(value="This enables use of normal Bone Meal on sugar canes in order to grow them upwards.")
    public boolean allowBoneMealOnSugarCanes = true;
    @Comment(value="The amount of bone meal applied to the plant when using compressed bone meal.")
    public int compressedBoneMealPower = 4;
    @Comment(value="The amount of bone meal applied to the plant when using extremely compressed bone meal.")
    public int extremelyCompressedBoneMealPower = 36;
    @Comment(value="The maximum amount of flowers that can spawn when using Florist's Bone Meal on grass.")
    public int floristsBoneMealMaxFlowers = 5;
    @Comment(value="The maximum range that flowers can spawn when using Florist's Bone Meal on grass.")
    public int floristsBoneMealMaxRange = 3;
    @Comment(value="List of blocks that can be duplicated by using Florist's Bone Meal on them.")
    @NestedType(value=class_2960.class)
    public Set<class_2960> flowerBlocks = Set.of(class_2960.method_60656((String)"poppy"), class_2960.method_60656((String)"dandelion"), class_2960.method_60656((String)"blue_orchid"), class_2960.method_60656((String)"allium"), class_2960.method_60656((String)"azure_bluet"), class_2960.method_60656((String)"red_tulip"), class_2960.method_60656((String)"orange_tulip"), class_2960.method_60656((String)"white_tulip"), class_2960.method_60656((String)"pink_tulip"), class_2960.method_60656((String)"oxeye_daisy"), class_2960.method_60656((String)"rose_bush"), class_2960.method_60656((String)"peony"), class_2960.method_60656((String)"lilac"), class_2960.method_60656((String)"sunflower"), class_2960.method_60656((String)"cornflower"), class_2960.method_60656((String)"lily_of_the_valley"));

    public boolean isFlowerBlock(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        return this.flowerBlocks.contains(id);
    }

    public static FertilizationConfig getActive() {
        return (FertilizationConfig)Balm.getConfig().getActiveConfig(FertilizationConfig.class);
    }

    public static void initialize() {
        Balm.getConfig().registerConfig(FertilizationConfig.class);
    }
}

