/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ModWorldGen {
    private static final Map<Block, TreeGrower> treeGrowers = new HashMap<Block, TreeGrower>();

    public static void initialize(BalmWorldGen worldGen) {
        ModWorldGen.registerFancyTree(Blocks.OAK_SAPLING, "oak");
        ModWorldGen.registerFancyTree(Blocks.SPRUCE_SAPLING, "spruce");
        ModWorldGen.registerFancyTree(Blocks.BIRCH_SAPLING, "birch");
        ModWorldGen.registerFancyTree(Blocks.JUNGLE_SAPLING, "jungle");
        ModWorldGen.registerFancyTree(Blocks.ACACIA_SAPLING, "acacia");
        ModWorldGen.registerFancyTree(Blocks.DARK_OAK_SAPLING, "dark_oak");
    }

    private static void registerFancyTree(Block sapling, String name) {
        ResourceKey fancyTree = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ModWorldGen.id("fancy_" + name));
        ResourceKey fancyTreeBees = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ModWorldGen.id("fancy_" + name + "_bees"));
        treeGrowers.put(sapling, new TreeGrower(name, Optional.empty(), Optional.of(fancyTree), Optional.of(fancyTreeBees)));
    }

    @Nullable
    public static TreeGrower getFancyTreeForSapling(BlockState state) {
        return treeGrowers.get(state.getBlock());
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"fertilization", (String)name);
    }
}

