/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization;

import java.util.Set;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.config.reflection.Comment;
import net.blay09.mods.balm.platform.config.reflection.Config;
import net.blay09.mods.balm.platform.config.reflection.NestedType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;

@Config(value="fertilization")
public class FertilizationConfig {
    @Comment(value="Set to true if compressed bone meal drops should go straight into the player's inventory.")
    public boolean addDropsDirectlyToInventory = false;
    @Comment(value="Set to true if compressed bone meal drops should go straight into the machine's inventory when used automatically.")
    public boolean addDropsDirectlyToInventoryForFakePlayers = true;
    @Comment(value="This enables use of extremely compressed bone meal to turn saplings into large fancy trees.")
    public boolean allowBoneMealOnSaplings = true;
    @Comment(value="This enables use of normal Bone Meal on vines in order to grow them downwards.")
    public boolean allowBoneMealOnVines = true;
    @Comment(value="This enables use of normal Bone Meal on sugar canes in order to grow them upwards.")
    public boolean allowBoneMealOnSugarCanes = true;
    @Comment(value="The amount of bone meal applied to the plant when using compressed bone meal.")
    public int compressedBoneMealPower = 4;
    @Comment(value="The amount of bone meal applied to the plant when using extremely compressed bone meal.")
    public int extremelyCompressedBoneMealPower = 36;
    @Comment(value="The maximum amount of flowers that can spawn when using Florist's Bone Meal on grass.")
    public int floristsBoneMealMaxFlowers = 5;
    @Comment(value="The maximum range that flowers can spawn when using Florist's Bone Meal on grass.")
    public int floristsBoneMealMaxRange = 3;
    @Comment(value="List of blocks that can be duplicated by using Florist's Bone Meal on them.")
    @NestedType(value=Identifier.class)
    public Set<Identifier> flowerBlocks = Set.of(Identifier.withDefaultNamespace((String)"poppy"), Identifier.withDefaultNamespace((String)"dandelion"), Identifier.withDefaultNamespace((String)"blue_orchid"), Identifier.withDefaultNamespace((String)"allium"), Identifier.withDefaultNamespace((String)"azure_bluet"), Identifier.withDefaultNamespace((String)"red_tulip"), Identifier.withDefaultNamespace((String)"orange_tulip"), Identifier.withDefaultNamespace((String)"white_tulip"), Identifier.withDefaultNamespace((String)"pink_tulip"), Identifier.withDefaultNamespace((String)"oxeye_daisy"), Identifier.withDefaultNamespace((String)"rose_bush"), Identifier.withDefaultNamespace((String)"peony"), Identifier.withDefaultNamespace((String)"lilac"), Identifier.withDefaultNamespace((String)"sunflower"), Identifier.withDefaultNamespace((String)"cornflower"), Identifier.withDefaultNamespace((String)"lily_of_the_valley"));

    public boolean isFlowerBlock(Block block) {
        Identifier id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return this.flowerBlocks.contains(id);
    }

    public static FertilizationConfig getActive() {
        return (FertilizationConfig)Balm.config().getActiveConfig(FertilizationConfig.class);
    }

    public static void initialize() {
        Balm.config().registerConfig(FertilizationConfig.class);
    }
}

