/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.fertilization.FertilizationConfig;
import net.blay09.mods.fertilization.mixin.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BoneMealHelper {
    @Nullable
    public static Item getSeedFromCrop(BlockState state) {
        if (state.getBlock() == Blocks.COCOA) {
            return Items.COCOA_BEANS;
        }
        if (state.getBlock() instanceof CropBlockAccessor) {
            return ((CropBlockAccessor)state.getBlock()).callGetBaseSeedId().asItem();
        }
        return null;
    }

    public static boolean isGrassBlock(BlockState state) {
        return state.getBlock() == Blocks.GRASS_BLOCK;
    }

    public static boolean tryHarvest(@Nullable Player player, Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (BoneMealHelper.tryHarvestGeneric(player, level, pos, state, it -> it.getBlock() instanceof CropBlock && ((CropBlock)it.getBlock()).isMaxAge(it), () -> ((CropBlock)state.getBlock()).getStateForAge(0), 0.25f)) {
            return true;
        }
        return BoneMealHelper.tryHarvestGeneric(player, level, pos, state, it -> it.getBlock() == Blocks.COCOA && (Integer)it.getValue((Property)CocoaBlock.AGE) >= 2, () -> ((Block)Blocks.COCOA).defaultBlockState(), -0.75f);
    }

    public static boolean tryHarvestGeneric(@Nullable Player player, Level level, BlockPos pos, BlockState state, Predicate<BlockState> isMature, Supplier<BlockState> newCropState, float spawnOffsetY) {
        ItemStack seedInInventory;
        if (!isMature.test(state)) {
            return false;
        }
        List drops = level instanceof ServerLevel ? Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null) : Collections.emptyList();
        Item seedItem = BoneMealHelper.getSeedFromCrop(state);
        if (seedItem == null) {
            return false;
        }
        boolean foundSeed = false;
        for (ItemStack itemStack : drops) {
            if (itemStack.isEmpty() || itemStack.getItem() != seedItem) continue;
            itemStack.shrink(1);
            foundSeed = true;
            break;
        }
        ItemStack itemStack = seedInInventory = player != null ? BoneMealHelper.findSeedInInventory(player, seedItem) : ItemStack.EMPTY;
        if (!foundSeed && !seedInInventory.isEmpty()) {
            seedInInventory.shrink(1);
            foundSeed = true;
        }
        if (!foundSeed) {
            return false;
        }
        if (!level.isClientSide()) {
            level.setBlockAndUpdate(pos, newCropState.get());
            for (ItemStack itemStack2 : drops) {
                if ((seedInInventory.isEmpty() && itemStack2.getItem() == seedItem || FertilizationConfig.getActive().addDropsDirectlyToInventory || FertilizationConfig.getActive().addDropsDirectlyToInventoryForFakePlayers && Balm.getHooks().isFakePlayer(player)) && player != null && player.getInventory().add(itemStack2)) continue;
                ItemEntity entityItem = new ItemEntity(level, (double)pos.getX() + 0.5, (double)((float)pos.getY() + spawnOffsetY), (double)pos.getZ() + 0.5, itemStack2);
                entityItem.setPickUpDelay(10);
                level.addFreshEntity((Entity)entityItem);
            }
        }
        return true;
    }

    private static ItemStack findSeedInInventory(Player player, Item seedItem) {
        int slot = player.getInventory().findSlotMatchingItem(new ItemStack((ItemLike)seedItem));
        if (slot != -1) {
            return player.getInventory().getItem(slot);
        }
        return ItemStack.EMPTY;
    }

    public static boolean isStemCrop(BlockState state) {
        return state.getBlock() == Blocks.MELON_STEM || state.getBlock() == Blocks.PUMPKIN_STEM;
    }

    public static boolean isGrowableDisabledForCompressed(BlockState state) {
        return BoneMealHelper.isGrassBlock(state) || state.getBlock() == Blocks.TALL_GRASS;
    }
}

