/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ArmorStandPreviewWidget;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class ArmorTrimEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_8053> onSave;
    private DropdownWidget materialDropdown;
    private DropdownWidget patternDropdown;
    private ArmorStandPreviewWidget previewWidget;
    private final List<class_6880<class_8054>> allMaterials = new ArrayList<class_6880<class_8054>>();
    private final List<class_6880<class_8056>> allPatterns = new ArrayList<class_6880<class_8056>>();

    public ArmorTrimEditorGui(class_437 parent, class_8053 initial, Consumer<class_8053> onSave) {
        super("Armor Trim Editor", parent);
        this.onSave = onSave;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.loadTrims();
        int centerX = this.field_22789 / 2;
        int leftPanelWidth = 320;
        int leftPanelX = 20;
        int previewSize = 180;
        int previewX = leftPanelX + leftPanelWidth + 20;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lArmor Trim Editor", -1, true, true);
        this.addWidget(title);
        this.previewWidget = new ArmorStandPreviewWidget("armor_preview", previewX, 40, previewSize, 240, -15066598);
        this.addWidget(this.previewWidget);
        LabelWidget previewLabel = new LabelWidget("preview_label", previewX + previewSize / 2, 285, "\u00a7ePreview", -1, true, false);
        this.addWidget(previewLabel);
        LabelWidget patternLabel = new LabelWidget("pattern_label", leftPanelX, 40, "\u00a7eTrim Pattern:", -1, false, false);
        this.addWidget(patternLabel);
        this.patternDropdown = new DropdownWidget("pattern_dropdown", leftPanelX, 55, leftPanelWidth, 20);
        for (class_6880<class_8056> class_68802 : this.allPatterns) {
            Optional optional = class_68802.method_40230();
            String name = optional.isPresent() ? ((class_5321)optional.get()).method_29177().method_12832().replace("_", " ") : "unknown";
            this.patternDropdown.addOption(name);
        }
        if (this.patternDropdown.getOptions().isEmpty()) {
            this.patternDropdown.addOption("No patterns available");
        }
        this.patternDropdown.setOnChanged(idx -> this.updatePreview());
        this.addWidget(this.patternDropdown);
        LabelWidget materialLabel = new LabelWidget("material_label", leftPanelX, 90, "\u00a7eTrim Material:", -1, false, false);
        this.addWidget(materialLabel);
        this.materialDropdown = new DropdownWidget("material_dropdown", leftPanelX, 105, leftPanelWidth, 20);
        for (class_6880<class_8054> class_68803 : this.allMaterials) {
            Optional key = class_68803.method_40230();
            String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832().replace("_", " ") : "unknown";
            this.materialDropdown.addOption(name);
        }
        if (this.materialDropdown.getOptions().isEmpty()) {
            this.materialDropdown.addOption("No materials available");
        }
        this.materialDropdown.setOnChanged(idx -> this.updatePreview());
        this.addWidget(this.materialDropdown);
        LabelWidget labelWidget = new LabelWidget("info_label", leftPanelX, 145, "\u00a77Select a pattern and material to see", -5592406, false, false);
        this.addWidget(labelWidget);
        LabelWidget labelWidget2 = new LabelWidget("info2_label", leftPanelX, 160, "\u00a77the trim applied to armor on the right.", -5592406, false, false);
        this.addWidget(labelWidget2);
        LabelWidget info3Label = new LabelWidget("info3_label", leftPanelX, 180, "\u00a77Common Patterns:", -5592406, false, false);
        this.addWidget(info3Label);
        LabelWidget info4Label = new LabelWidget("info4_label", leftPanelX, 195, "\u00a77  vex, ward, coast, dune, wild, sentry", -5592406, false, false);
        this.addWidget(info4Label);
        LabelWidget info5Label = new LabelWidget("info5_label", leftPanelX, 215, "\u00a77Common Materials:", -5592406, false, false);
        this.addWidget(info5Label);
        LabelWidget info6Label = new LabelWidget("info6_label", leftPanelX, 230, "\u00a77  quartz, iron, gold, diamond, netherite", -5592406, false, false);
        this.addWidget(info6Label);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveTrim();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
        this.updatePreview();
    }

    private void updatePreview() {
        if (this.previewWidget == null) {
            return;
        }
        int patternIdx = this.patternDropdown.getSelectedIndex();
        int materialIdx = this.materialDropdown.getSelectedIndex();
        class_1799 helmet = new class_1799((class_1935)class_1802.field_8805);
        class_1799 chestplate = new class_1799((class_1935)class_1802.field_8058);
        class_1799 leggings = new class_1799((class_1935)class_1802.field_8348);
        class_1799 boots = new class_1799((class_1935)class_1802.field_8285);
        if (patternIdx >= 0 && patternIdx < this.allPatterns.size() && materialIdx >= 0 && materialIdx < this.allMaterials.size()) {
            class_6880<class_8054> material = this.allMaterials.get(materialIdx);
            class_6880<class_8056> pattern = this.allPatterns.get(patternIdx);
            class_8053 trim = new class_8053(material, pattern);
            helmet.method_57379(class_9334.field_49607, (Object)trim);
            chestplate.method_57379(class_9334.field_49607, (Object)trim);
            leggings.method_57379(class_9334.field_49607, (Object)trim);
            boots.method_57379(class_9334.field_49607, (Object)trim);
        }
        this.previewWidget.setAllArmor(helmet, chestplate, leggings, boots);
    }

    private void loadTrims() {
        if (this.field_22787 != null && this.field_22787.field_1687 != null) {
            try {
                class_5455 registryAccess = this.field_22787.field_1687.method_30349();
                class_2378 materialRegistry = registryAccess.method_30530(class_7924.field_42083);
                class_2378 patternRegistry = registryAccess.method_30530(class_7924.field_42082);
                materialRegistry.method_42017().forEach(m -> this.allMaterials.add((class_6880<class_8054>)m));
                patternRegistry.method_42017().forEach(p -> this.allPatterns.add((class_6880<class_8056>)p));
            }
            catch (Exception e) {
                this.addFallbackTrims();
            }
        }
        if (this.allMaterials.isEmpty() || this.allPatterns.isEmpty()) {
            this.addFallbackTrims();
        }
    }

    private void addFallbackTrims() {
    }

    private void saveTrim() {
        int patternIdx = this.patternDropdown.getSelectedIndex();
        int materialIdx = this.materialDropdown.getSelectedIndex();
        if (patternIdx < 0 || patternIdx >= this.allPatterns.size() || materialIdx < 0 || materialIdx >= this.allMaterials.size()) {
            return;
        }
        class_6880<class_8054> material = this.allMaterials.get(materialIdx);
        class_6880<class_8056> pattern = this.allPatterns.get(patternIdx);
        class_8053 trim = new class_8053(material, pattern);
        if (this.onSave != null) {
            this.onSave.accept(trim);
        }
    }
}

