/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.SearchableDropdownWidget;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class BannerPatternsEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9307> onSave;
    private final class_1799 bannerStack;
    private final List<class_9307.class_9308> layers = new ArrayList<class_9307.class_9308>();
    private ScrollMenuWidget layerList;
    private SearchableDropdownWidget patternDropdown;
    private SearchableDropdownWidget colorDropdown;
    private final List<String> patternNames = new ArrayList<String>();
    private final List<class_6880<class_2582>> patterns = new ArrayList<class_6880<class_2582>>();
    private final class_1767[] colors = class_1767.values();

    public BannerPatternsEditorGui(class_437 parent, class_1799 bannerStack, class_9307 current, Consumer<class_9307> onSave) {
        super("Banner Patterns Editor", parent);
        this.onSave = onSave;
        this.bannerStack = bannerStack.method_7972();
        if (current != null) {
            this.layers.addAll(current.comp_2428());
        }
    }

    private void loadPatterns() {
        class_2378 registry;
        if (this.field_22787 != null && this.field_22787.field_1687 != null && (registry = (class_2378)this.field_22787.field_1687.method_30349().method_46759(class_7924.field_41252).orElse(null)) != null) {
            for (Map.Entry entry : registry.method_29722()) {
                this.patternNames.add(((class_5321)entry.getKey()).method_29177().toString());
                this.patterns.add((class_6880<class_2582>)registry.method_47983((Object)((class_2582)entry.getValue())));
            }
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.loadPatterns();
        int centerX = this.field_22789 / 2;
        int panelWidth = 320;
        int panelX = centerX - panelWidth / 2;
        int previewWidth = 120;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lBanner Patterns Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget instructions = new LabelWidget("instructions", centerX, 30, "\u00a77Add patterns to customize your banner", -5592406, true, false);
        this.addWidget(instructions);
        LabelWidget patternLabel = new LabelWidget("pattern_label", panelX, 60, "Pattern:", -5592406, false, false);
        this.addWidget(patternLabel);
        this.patternDropdown = new SearchableDropdownWidget("pattern", panelX, 80, 200, 20);
        for (String string : this.patternNames) {
            this.patternDropdown.addOption(string);
        }
        if (!this.patternNames.isEmpty()) {
            this.patternDropdown.setSelectedIndex(0);
        }
        this.addWidget(this.patternDropdown);
        LabelWidget colorLabel = new LabelWidget("color_label", panelX, 110, "Color:", -5592406, false, false);
        this.addWidget(colorLabel);
        this.colorDropdown = new SearchableDropdownWidget("color", panelX, 130, 200, 20);
        for (class_1767 color : this.colors) {
            this.colorDropdown.addOption(color.method_7792());
        }
        this.colorDropdown.setSelectedIndex(0);
        this.addWidget(this.colorDropdown);
        ButtonWidget buttonWidget = new ButtonWidget("add", panelX + 210, 105, 80, 20, "Add Layer", -13996502, -13004999, -1);
        buttonWidget.setOnPress(this::addLayer);
        this.addWidget(buttonWidget);
        LabelWidget layersLabel = new LabelWidget("layers_label", panelX, 165, "\u00a7eLayers (" + this.layers.size() + "):", -1, false, false);
        this.addWidget(layersLabel);
        this.layerList = new ScrollMenuWidget("layers", panelX, 185, 200, 150, -15066598, -14013910, -12632257, -1, -10461088);
        this.layerList.setItemHeight(20);
        this.addWidget(this.layerList);
        this.refreshLayerList();
        ButtonWidget removeBtn = new ButtonWidget("remove", panelX + 210, 185, 80, 20, "Remove", -9557462, -7390919, -1);
        removeBtn.setOnPress(this::removeLayer);
        this.addWidget(removeBtn);
        ButtonWidget upBtn = new ButtonWidget("up", panelX + 210, 215, 80, 20, "Move Up", -12961170, -11908465, -1);
        upBtn.setOnPress(this::moveUp);
        this.addWidget(upBtn);
        ButtonWidget downBtn = new ButtonWidget("down", panelX + 210, 245, 80, 20, "Move Down", -12961170, -11908465, -1);
        downBtn.setOnPress(this::moveDown);
        this.addWidget(downBtn);
        ButtonWidget clearBtn = new ButtonWidget("clear", panelX + 210, 305, 80, 20, "Clear All", -9737365, -7697782, -1);
        clearBtn.setOnPress(this::clearAll);
        this.addWidget(clearBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::save);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void addLayer() {
        int patternIndex = this.patternDropdown.getSelectedIndex();
        int colorIndex = this.colorDropdown.getSelectedIndex();
        if (patternIndex >= 0 && patternIndex < this.patterns.size() && colorIndex >= 0 && colorIndex < this.colors.length) {
            class_6880<class_2582> pattern = this.patterns.get(patternIndex);
            class_1767 color = this.colors[colorIndex];
            this.layers.add(new class_9307.class_9308(pattern, color));
            this.refreshLayerList();
            this.updatePreview();
        }
    }

    private void removeLayer() {
        int selected = this.layerList.getSelectedIndex();
        if (selected >= 0 && selected < this.layers.size()) {
            this.layers.remove(selected);
            this.refreshLayerList();
            this.updatePreview();
        }
    }

    private void moveUp() {
        int selected = this.layerList.getSelectedIndex();
        if (selected > 0 && selected < this.layers.size()) {
            class_9307.class_9308 layer = this.layers.remove(selected);
            this.layers.add(selected - 1, layer);
            this.refreshLayerList();
            this.updatePreview();
        }
    }

    private void moveDown() {
        int selected = this.layerList.getSelectedIndex();
        if (selected >= 0 && selected < this.layers.size() - 1) {
            class_9307.class_9308 layer = this.layers.remove(selected);
            this.layers.add(selected + 1, layer);
            this.refreshLayerList();
            this.updatePreview();
        }
    }

    private void clearAll() {
        this.layers.clear();
        this.refreshLayerList();
        this.updatePreview();
    }

    private void refreshLayerList() {
        this.layerList.clearItems();
        for (int i = 0; i < this.layers.size(); ++i) {
            class_9307.class_9308 layer = this.layers.get(i);
            String patternName = layer.comp_2429().method_40230().map(k -> k.method_29177().method_12832()).orElse("unknown");
            String colorName = layer.comp_2430().method_7792();
            this.layerList.addItem(i + 1 + ". " + patternName + " (" + colorName + ")");
        }
        LabelWidget label = (LabelWidget)this.getWidget("layers_label");
        if (label != null) {
            label.setText("\u00a7eLayers (" + this.layers.size() + "):");
        }
    }

    private void updatePreview() {
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int previewX = this.field_22789 / 2 + 140;
        int previewY = 100;
        class_1799 preview = this.bannerStack.method_7972();
        if (!this.layers.isEmpty()) {
            preview.method_57379(class_9334.field_49619, (Object)new class_9307(this.layers));
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)previewX, (float)previewY, 0.0f);
        graphics.method_51448().method_22905(4.0f, 4.0f, 1.0f);
        graphics.method_51427(preview, 0, 0);
        graphics.method_51448().method_22909();
        graphics.method_51433(this.field_22787.field_1772, "\u00a76\u00a7lPreview:", previewX - 10, previewY - 15, -22016, false);
        if (this.layers.isEmpty()) {
            graphics.method_51433(this.field_22787.field_1772, "\u00a77No patterns", previewX, previewY + 70, -8355712, false);
        }
    }

    private void save() {
        class_9307 patternLayers = new class_9307(this.layers);
        if (this.onSave != null) {
            this.onSave.accept(patternLayers);
        }
        this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aBanner patterns saved! (" + this.layers.size() + " layers)")), false);
        this.method_25419();
    }
}

