/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.minecraft.class_1767;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class BaseColorEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_1767> onSave;
    private DropdownWidget colorDropdown;

    public BaseColorEditorGui(class_437 parent, class_1767 initial, Consumer<class_1767> onSave) {
        super("Base Color Selector", parent);
        this.onSave = onSave;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 280;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lBase Color", -1, true, true);
        this.addWidget(title);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 35, "\u00a77For maps, banners, and shields", -5592406, false, false);
        this.addWidget(infoLabel);
        LabelWidget colorLabel = new LabelWidget("color_label", panelX, 60, "\u00a7eDye Color:", -1, false, false);
        this.addWidget(colorLabel);
        this.colorDropdown = new DropdownWidget("color_dropdown", panelX, 75, panelWidth, 20);
        for (class_1767 color : class_1767.values()) {
            String colorCode = this.getColorCode(color);
            this.colorDropdown.addOption(colorCode + color.method_7792());
        }
        this.addWidget(this.colorDropdown);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveColor();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private String getColorCode(class_1767 color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7952 -> "\u00a7f";
            case class_1767.field_7946 -> "\u00a76";
            case class_1767.field_7958 -> "\u00a7d";
            case class_1767.field_7951 -> "\u00a7b";
            case class_1767.field_7947 -> "\u00a7e";
            case class_1767.field_7961 -> "\u00a7a";
            case class_1767.field_7954 -> "\u00a7d";
            case class_1767.field_7944 -> "\u00a77";
            case class_1767.field_7967 -> "\u00a77";
            case class_1767.field_7955 -> "\u00a73";
            case class_1767.field_7945 -> "\u00a75";
            case class_1767.field_7966 -> "\u00a79";
            case class_1767.field_7957 -> "\u00a76";
            case class_1767.field_7942 -> "\u00a72";
            case class_1767.field_7964 -> "\u00a7c";
            case class_1767.field_7963 -> "\u00a70";
        };
    }

    private void saveColor() {
        int idx = this.colorDropdown.getSelectedIndex();
        if (idx < 0 || idx >= class_1767.values().length) {
            return;
        }
        class_1767 color = class_1767.values()[idx];
        if (this.onSave != null) {
            this.onSave.accept(color);
        }
    }
}

