/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.ConsumeEffectEditorGui;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_10124;
import net.minecraft.class_10134;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class ConsumableEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_10124> onSave;
    private TextBoxWidget consumeSecondsInput;
    private DropdownWidget animationDropdown;
    private DropdownWidget soundDropdown;
    private ButtonWidget hasConsumeParticles;
    private ScrollMenuWidget effectsList;
    private final List<class_10134> consumeEffects = new ArrayList<class_10134>();
    private boolean particles = true;

    public ConsumableEditorGui(class_437 parent, class_10124 initial, Consumer<class_10124> onSave) {
        super("Consumable Editor", parent);
        this.onSave = onSave;
        if (initial != null) {
            this.particles = initial.comp_3088();
            this.consumeEffects.addAll(initial.comp_3089());
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lConsumable Properties", -1, true, true);
        this.addWidget(title);
        LabelWidget consumeLabel = new LabelWidget("consume_label", panelX, 35, "\u00a7eConsume Time (seconds):", -1, false, false);
        this.addWidget(consumeLabel);
        this.consumeSecondsInput = new TextBoxWidget("consume_seconds", panelX, 50, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.consumeSecondsInput.setValue("1.6");
        this.consumeSecondsInput.setMaxLength(6);
        this.consumeSecondsInput.setHint("Default: 1.6");
        this.addWidget(this.consumeSecondsInput);
        LabelWidget animLabel = new LabelWidget("anim_label", panelX, 80, "\u00a7eConsume Animation:", -1, false, false);
        this.addWidget(animLabel);
        this.animationDropdown = new DropdownWidget("animation_dropdown", panelX, 95, panelWidth, 20);
        this.animationDropdown.addOption("eat");
        this.animationDropdown.addOption("drink");
        this.animationDropdown.addOption("block");
        this.animationDropdown.addOption("bow");
        this.animationDropdown.addOption("spear");
        this.animationDropdown.addOption("crossbow");
        this.animationDropdown.addOption("spyglass");
        this.animationDropdown.addOption("toot_horn");
        this.animationDropdown.addOption("brush");
        this.addWidget(this.animationDropdown);
        LabelWidget soundLabel = new LabelWidget("sound_label", panelX, 125, "\u00a7eConsume Sound:", -1, false, false);
        this.addWidget(soundLabel);
        this.soundDropdown = new DropdownWidget("sound_dropdown", panelX, 140, panelWidth, 20);
        this.soundDropdown.addOption("entity.generic.eat");
        this.soundDropdown.addOption("entity.generic.drink");
        this.soundDropdown.addOption("item.honey_bottle.drink");
        this.soundDropdown.addOption("entity.player.burp");
        this.soundDropdown.addOption("item.bottle.fill");
        this.soundDropdown.addOption("item.bottle.empty");
        this.addWidget(this.soundDropdown);
        LabelWidget particlesLabel = new LabelWidget("particles_label", panelX, 170, "\u00a7eShow Consume Particles:", -1, false, false);
        this.addWidget(particlesLabel);
        this.hasConsumeParticles = new ButtonWidget("particles_toggle", panelX, 185, 120, 20, this.particles ? "\u00a7aYes" : "\u00a7cNo", this.particles ? -13996502 : -9557462, this.particles ? -13004999 : -7390919, -1);
        this.hasConsumeParticles.setOnPress(() -> {
            this.particles = !this.particles;
            this.hasConsumeParticles.setText(this.particles ? "\u00a7aYes" : "\u00a7cNo");
        });
        this.addWidget(this.hasConsumeParticles);
        LabelWidget effectsLabel = new LabelWidget("effects_label", panelX, 215, "\u00a7eConsume Effects:", -1, false, false);
        this.addWidget(effectsLabel);
        this.effectsList = new ScrollMenuWidget("effects_list", panelX, 230, panelWidth, 80, -15066598, -14013910, -12632257, -1, -10461088);
        this.effectsList.setItemHeight(20);
        this.updateEffectsList();
        this.addWidget(this.effectsList);
        ButtonWidget addEffectBtn = new ButtonWidget("add_effect", panelX, 320, 110, 20, "Add Effect", -13996502, -13004999, -1);
        addEffectBtn.setOnPress(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ConsumeEffectEditorGui(this, null, effect -> {
                    this.consumeEffects.add((class_10134)effect);
                    this.updateEffectsList();
                }));
            }
        });
        this.addWidget(addEffectBtn);
        ButtonWidget removeEffectBtn = new ButtonWidget("remove_effect", panelX + 120, 320, 110, 20, "Remove", -9557462, -7390919, -1);
        removeEffectBtn.setOnPress(() -> {
            int selected = this.effectsList.getSelectedIndex();
            if (selected >= 0 && selected < this.consumeEffects.size()) {
                this.consumeEffects.remove(selected);
                this.updateEffectsList();
            }
        });
        this.addWidget(removeEffectBtn);
        ButtonWidget clearEffectsBtn = new ButtonWidget("clear_effects", panelX + 240, 320, 110, 20, "Clear All", -9557462, -7390919, -1);
        clearEffectsBtn.setOnPress(() -> {
            this.consumeEffects.clear();
            this.updateEffectsList();
        });
        this.addWidget(clearEffectsBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveConsumable();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void updateEffectsList() {
        this.effectsList.clearItems();
        for (class_10134 effect : this.consumeEffects) {
            String type = effect.getClass().getSimpleName();
            this.effectsList.addItem(type);
        }
    }

    private void saveConsumable() {
        String animStr;
        float consumeSeconds = 1.6f;
        try {
            consumeSeconds = Float.parseFloat(this.consumeSecondsInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        class_1839 animation = switch (animStr = this.animationDropdown.getSelectedOption()) {
            case "drink" -> class_1839.field_8946;
            case "block" -> class_1839.field_8949;
            case "bow" -> class_1839.field_8953;
            case "spear" -> class_1839.field_8951;
            case "crossbow" -> class_1839.field_8947;
            case "spyglass" -> class_1839.field_27079;
            case "toot_horn" -> class_1839.field_39058;
            case "brush" -> class_1839.field_42717;
            default -> class_1839.field_8950;
        };
        String soundStr = this.soundDropdown.getSelectedOption();
        class_3414 soundEvent = class_3414.method_47908((class_2960)class_2960.method_60654((String)soundStr));
        class_6880 sound = class_6880.method_40223((Object)soundEvent);
        class_10124 consumable = new class_10124(consumeSeconds, animation, sound, this.particles, this.consumeEffects);
        if (this.onSave != null) {
            this.onSave.accept(consumable);
        }
    }
}

